/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.DBRouteInfo;

public abstract class AbstractJobRecordUpgradeService
implements IUpgradeService {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final String TABLE_NAME = "t_wf_jobrecord";

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.wrapResultMap(resultMap, true, "", "", "success");
        return resultMap;
    }

    protected Map<String, Object> wrapResultMap(Map<String, Object> resultMap, boolean success, String log, String el, String errorInfo) {
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", el);
        resultMap.put("errorInfo", errorInfo);
        return resultMap;
    }

    protected Set<String> getWorkflowRouteKeys() {
        HashSet<String> wfRouteKeys = new HashSet<String>();
        wfRouteKeys.add("wftask");
        wfRouteKeys.add("wfs");
        wfRouteKeys.add("wf");
        return wfRouteKeys;
    }

    protected List<DBRouteInfo> getAllDBRoutes() {
        ArrayList<DBRouteInfo> dbRoutes = new ArrayList<DBRouteInfo>();
        HashMap<String, DBRouteInfo> routeMap = new HashMap<String, DBRouteInfo>();
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        List dbs = account.getDBInstanceList();
        DBRouteInfo routeInfo = null;
        for (DBInstance dbInstance : dbs) {
            String routeKey = dbInstance.getRouteKey();
            String insid = String.format("%s.%s.%s.%s.%s", dbInstance.getDbtype(), dbInstance.getDbip(), dbInstance.getDbport(), dbInstance.getDBInsatnce(), dbInstance.getDbuser());
            routeInfo = (DBRouteInfo)routeMap.get(insid);
            if (routeInfo == null) {
                routeInfo = new DBRouteInfo(insid, dbInstance.getDbtype(), new DBRoute(routeKey));
                routeMap.put(insid, routeInfo);
                dbRoutes.add(routeInfo);
            }
            routeInfo.getRouteKeys().add(routeKey);
        }
        return dbRoutes;
    }

    protected boolean isExistTable(DBRoute dbRoute, String tableName) {
        boolean existTable = false;
        try {
            existTable = DB.exitsTable((DBRoute)dbRoute, (String)tableName);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return existTable;
    }

    protected int exitsIndex(DBRoute dbRoute, String tableName, String indexName) {
        int existIndex = 0;
        try {
            if (DB.exitsIndex((DBRoute)dbRoute, (String)tableName, (String)indexName)) {
                existIndex = 1;
            }
        }
        catch (Exception e) {
            existIndex = 2;
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return existIndex;
    }
}

