/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.AbstractJobRecordUpgradeService;
import kd.bos.workflow.upgrade.DBRouteInfo;

public class AddJobRecordLockTimeIndexServiceImpl
extends AbstractJobRecordUpgradeService {
    private static final String IDX_EVT_JOBRECORD_LOCKSTATE = "IDX_EVT_JOBRECORD_LOCKSTATE";
    private static final String IDX_EVT_JOBREC_BUSKEY_STATE = "IDX_EVT_JOBREC_BUSKEY_STATE";
    private static final String IDX_EVT_JOBRECORD_CREATEDATE = "IDX_EVT_JOBRECORD_CREATEDATE";
    private static final String IDX_EVT_JOBRECORD_HANDTYPE = "IDX_EVT_JOBRECORD_HANDTYPE";
    private static final String IDX_EVT_JOBRECORD_ROOTEVTID = "IDX_EVT_JOBRECORD_ROOTEVTID";
    private static final String IDX_EVT_JOBRECORD_ROOTJOBID = "IDX_EVT_JOBRECORD_ROOTJOBID";
    private static final String IDX_EVT_JOBRECORD_ROOTTRACE = "IDX_EVT_JOBRECORD_ROOTTRACE";
    private static final String IDX_WF_JOBRECORD_LOCKSTATE = "IDX_WF_JOBRECORD_LOCKSTATE";
    private static final String IDX_WF_JOBREC_BUSKEY_STATE = "IDX_WF_JOBREC_BUSKEY_STATE";
    private static final String IDX_WF_JOBRECORD_EXECUTION = "IDX_WF_JOBRECORD_EXECUTION";
    private static final String IDX_WF_JOBRECORD_HANDLERTYPE = "IDX_WF_JOBRECORD_HANDLERTYPE";
    private static final String IDX_WF_JOBRECORD_PROCDEF = "IDX_WF_JOBRECORD_PROCDEF";
    private static final String IDX_WF_JOBRECORD_PROCINST = "IDX_WF_JOBRECORD_PROCINST";
    private static final String IDX_WF_JOBRECORD_ROOTJOBID = "IDX_WF_JOBRECORD_ROOTJOBID";
    private static final String LOCKTIME = "FLOCKEXPTIME,FSTATE";
    private static final String BUSINESSKEY = "FBUSINESSKEY,FSTATE";
    private static final String CREATEDATE = "FCREATEDATE";
    private static final String HANDLERTYPE = "FHANDLERTYPE";
    private static final String ROOTEVENTINSTID = "FROOTEVENTINSTID";
    private static final String FROOTJOBID = "FROOTJOBID";
    private static final String FROOTTRACENO = "FROOTTRACENO";
    private static final String EXECUTIONID = "FEXECUTIONID";
    private static final String PROCDEFID = "FPROCDEFID";
    private static final String PROCESSINSTANCEID = "FPROCESSINSTANCEID";
    private static final String ROOTJOBID = "FROOTJOBID";
    private static final String EVTJOBRECORD = "t_evt_jobrecord";
    private static final String WFJOBRECORD = "t_wf_jobrecord";
    private static final String SQLEVT = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_LOCKSTATE", "IDX_EVT_JOBRECORD_LOCKSTATE", "t_evt_jobrecord", "FLOCKEXPTIME,FSTATE");
    private static final String SQLEVT1 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBREC_BUSKEY_STATE", "IDX_EVT_JOBREC_BUSKEY_STATE", "t_evt_jobrecord", "FBUSINESSKEY,FSTATE");
    private static final String SQLEVT2 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_CREATEDATE", "IDX_EVT_JOBRECORD_CREATEDATE", "t_evt_jobrecord", "FCREATEDATE");
    private static final String SQLEVT3 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_HANDTYPE", "IDX_EVT_JOBRECORD_HANDTYPE", "t_evt_jobrecord", "FHANDLERTYPE");
    private static final String SQLEVT4 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_ROOTEVTID", "IDX_EVT_JOBRECORD_ROOTEVTID", "t_evt_jobrecord", "FROOTEVENTINSTID");
    private static final String SQLEVT5 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_ROOTJOBID", "IDX_EVT_JOBRECORD_ROOTJOBID", "t_evt_jobrecord", "FROOTJOBID");
    private static final String SQLEVT6 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_ROOTTRACE", "IDX_EVT_JOBRECORD_ROOTTRACE", "t_evt_jobrecord", "FROOTTRACENO");
    private static final String SQLWF = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_LOCKSTATE", "IDX_WF_JOBRECORD_LOCKSTATE", "t_wf_jobrecord", "FLOCKEXPTIME,FSTATE");
    private static final String SQLWF1 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBREC_BUSKEY_STATE", "IDX_WF_JOBREC_BUSKEY_STATE", "t_wf_jobrecord", "FBUSINESSKEY,FSTATE");
    private static final String SQLWF2 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_EXECUTION", "IDX_WF_JOBRECORD_EXECUTION", "t_wf_jobrecord", "FEXECUTIONID");
    private static final String SQLWF3 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_HANDLERTYPE", "IDX_WF_JOBRECORD_HANDLERTYPE", "t_wf_jobrecord", "FHANDLERTYPE");
    private static final String SQLWF4 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_PROCDEF", "IDX_WF_JOBRECORD_PROCDEF", "t_wf_jobrecord", "FPROCDEFID");
    private static final String SQLWF5 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_PROCINST", "IDX_WF_JOBRECORD_PROCINST", "t_wf_jobrecord", "FPROCESSINSTANCEID");
    private static final String SQLWF6 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_WF_JOBRECORD_ROOTJOBID", "IDX_WF_JOBRECORD_ROOTJOBID", "t_wf_jobrecord", "FROOTJOBID");
    private static final String SQLEVTFIX = "IF EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_EVT_JOBRECORD_ROOTEV') DROP INDEX T_EVT_JOBRECORD.IDX_EVT_JOBRECORD_ROOTEV;";

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set<String> wfRouteKeys = this.getWorkflowRouteKeys();
        List<DBRouteInfo> dbRoutes = this.getAllDBRoutes();
        StringBuilder sb = new StringBuilder("start...");
        boolean success = true;
        for (DBRouteInfo routeInfo : dbRoutes) {
            String key = routeInfo.getInsid();
            List<String> routeKeys = routeInfo.getRouteKeys();
            try {
                DBRoute dbRoute = routeInfo.getDbRoute();
                if (dbRoute == null) {
                    this.log.debug("dbRoute is null!");
                    continue;
                }
                if (wfRouteKeys.contains(dbRoute.getRouteKey().toLowerCase())) continue;
                sb.append(key).append(routeKeys).append(" begin! ");
                this.addEvtIndex(routeInfo);
                this.addWfIndex(routeInfo);
                sb.append(key).append(routeKeys).append(" end! ");
            }
            catch (Exception e) {
                success = false;
                String err = WfUtils.getExceptionStacktrace((Throwable)e);
                sb.append(key).append(routeKeys).append(" alter failed! ").append(err);
                this.log.debug(String.format("%s alter failed! %s", routeKeys, err));
            }
        }
        sb.append("finish...");
        this.wrapResultMap(resultMap, success, "", "", sb.toString());
        return resultMap;
    }

    protected void addEvtIndex(DBRouteInfo routeInfo) {
        DBRoute dbRoute = routeInfo.getDbRoute();
        boolean existTable = this.isExistTable(dbRoute, EVTJOBRECORD);
        if (!existTable) {
            this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d\u4e0d\u5b58\u5728 %3$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD));
            return;
        }
        TXHandle h = TX.beginNew();
        try {
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, "IDX_EVT_JOBRECORD_ROOTEV") == 1) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVTFIX, (Object[])new Object[0]);
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBRECORD_LOCKSTATE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBRECORD_LOCKSTATE));
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBREC_BUSKEY_STATE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT1, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBREC_BUSKEY_STATE));
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBRECORD_CREATEDATE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT2, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBRECORD_CREATEDATE));
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBRECORD_HANDTYPE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT3, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBRECORD_HANDTYPE));
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBRECORD_ROOTEVTID) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT4, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBRECORD_ROOTEVTID));
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBRECORD_ROOTJOBID) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT5, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBRECORD_ROOTJOBID));
            }
            if (this.exitsIndex(dbRoute, EVTJOBRECORD, IDX_EVT_JOBRECORD_ROOTTRACE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLEVT6, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), EVTJOBRECORD, IDX_EVT_JOBRECORD_ROOTTRACE));
            }
        }
        catch (Exception e) {
            h.markRollback();
            throw e;
        }
        finally {
            h.end();
        }
    }

    protected void addWfIndex(DBRouteInfo routeInfo) {
        DBRoute dbRoute = routeInfo.getDbRoute();
        boolean existTable = this.isExistTable(dbRoute, WFJOBRECORD);
        if (!existTable) {
            this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d\u4e0d\u5b58\u5728 %3$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD));
            return;
        }
        TXHandle h = TX.beginNew();
        try {
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBRECORD_LOCKSTATE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBRECORD_LOCKSTATE));
            }
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBREC_BUSKEY_STATE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF1, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBREC_BUSKEY_STATE));
            }
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBRECORD_EXECUTION) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF2, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBRECORD_EXECUTION));
            }
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBRECORD_HANDLERTYPE) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF3, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBRECORD_HANDLERTYPE));
            }
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBRECORD_PROCDEF) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF4, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBRECORD_PROCDEF));
            }
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBRECORD_PROCINST) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF5, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBRECORD_PROCINST));
            }
            if (this.exitsIndex(dbRoute, WFJOBRECORD, IDX_WF_JOBRECORD_ROOTJOBID) == 0) {
                DB.execute((DBRoute)dbRoute, (String)SQLWF6, (Object[])new Object[0]);
            } else {
                this.log.debug(String.format("%1$s %2$s \u5e93\u4e2d %3$s \u8868 \u5df2\u5b58\u5728\u7d22\u5f15%4$s\u3002", routeInfo.getInsid(), routeInfo.getRouteKeys(), WFJOBRECORD, IDX_WF_JOBRECORD_ROOTJOBID));
            }
        }
        catch (Exception e) {
            h.markRollback();
            throw e;
        }
        finally {
            h.end();
        }
    }
}

