/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.AbstractJobRecordUpgradeService;
import kd.bos.workflow.upgrade.DBRouteInfo;

public class AddJobRecordOrgFieldsServiceImpl
extends AbstractJobRecordUpgradeService {
    private static final String FIELD_ORGUNITID = "FORGUNITID";
    private static final String FIELD_ORGVIEWID = "FORGVIEWID";
    private static final String SQL1 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='%s') ALTER TABLE %s ADD (%s BIGINT DEFAULT 0 NOT NULL );", "t_wf_jobrecord", "FORGUNITID", "t_wf_jobrecord", "FORGUNITID");
    private static final String SQL2 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='%s') ALTER TABLE %s ADD (%s VARCHAR(50) DEFAULT ' ' NOT NULL );", "t_wf_jobrecord", "FORGVIEWID", "t_wf_jobrecord", "FORGVIEWID");

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set<String> wfRouteKeys = this.getWorkflowRouteKeys();
        List<DBRouteInfo> dbRoutes = this.getAllDBRoutes();
        StringBuilder sb = new StringBuilder("start...");
        boolean success = true;
        for (DBRouteInfo routeInfo : dbRoutes) {
            String key = routeInfo.getInsid();
            List<String> routeKeys = routeInfo.getRouteKeys();
            try {
                DBRoute dbRoute = routeInfo.getDbRoute();
                if (dbRoute == null) {
                    this.log.debug("dbRoute is null!");
                    continue;
                }
                if (wfRouteKeys.contains(dbRoute.getRouteKey().toLowerCase())) continue;
                sb.append(key).append(routeKeys).append(" begin! ");
                this.addBizTraceNoField(routeInfo);
                sb.append(key).append(routeKeys).append(" end! ");
            }
            catch (Exception e) {
                success = false;
                String err = WfUtils.getExceptionStacktrace((Throwable)e);
                sb.append(key).append(routeKeys).append(" alter failed! ").append(err);
                this.log.debug(String.format("%s alter failed! %s", routeKeys, err));
            }
        }
        sb.append("finish...");
        this.wrapResultMap(resultMap, success, "", "", sb.toString());
        return resultMap;
    }

    protected void addBizTraceNoField(DBRouteInfo routeInfo) {
        DBRoute dbRoute = routeInfo.getDbRoute();
        boolean existTable = this.isExistTable(dbRoute, "t_wf_jobrecord");
        if (existTable) {
            TXHandle h = TX.beginNew();
            try {
                DB.execute((DBRoute)dbRoute, (String)SQL1, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQL2, (Object[])new Object[0]);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
            finally {
                h.end();
            }
        } else {
            this.log.debug(String.format("%s %s \u5e93\u4e2d\u4e0d\u5b58\u5728 %s\uff01", routeInfo.getInsid(), routeInfo.getRouteKeys(), "t_wf_jobrecord"));
        }
    }
}

