/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.AbstractJobRecordUpgradeService;
import kd.bos.workflow.upgrade.DBRouteInfo;

public class AlterJobRecordFieldServiceImpl
extends AbstractJobRecordUpgradeService {
    private static final String ALTER_SQL_1 = "ALTER TABLE t_wf_jobrecord ADD FHANDLERCFGTEMP NCLOB; ";
    private static final String ALTER_SQL_2 = "UPDATE t_wf_jobrecord SET FHANDLERCFGTEMP = FHANDLERCFG;";
    private static final String ALTER_SQL_3 = "ALTER TABLE t_wf_jobrecord DROP COLUMN FHANDLERCFG; ";
    private static final String ALTER_SQL_4 = "ALTER TABLE t_wf_jobrecord ADD FHANDLERCFG NCLOB; ";
    private static final String ALTER_SQL_5 = "UPDATE t_wf_jobrecord SET FHANDLERCFG = FHANDLERCFGTEMP; ";
    private static final String ALTER_SQL_6 = "ALTER TABLE t_wf_jobrecord DROP COLUMN FHANDLERCFGTEMP; ";

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set<String> wfRouteKeys = this.getWorkflowRouteKeys();
        List<DBRouteInfo> dbRoutes = this.getAllDBRoutes();
        StringBuilder sb = new StringBuilder("start...");
        boolean success = true;
        for (DBRouteInfo routeInfo : dbRoutes) {
            String key = routeInfo.getInsid();
            List<String> routeKeys = routeInfo.getRouteKeys();
            try {
                DBRoute dbRoute = routeInfo.getDbRoute();
                if (dbRoute == null) {
                    this.log.debug("dbRoute is null!");
                    continue;
                }
                String route = dbRoute.getRouteKey().toLowerCase();
                if (wfRouteKeys.contains(route) || this.isSameDatabaseWithWorkflow(wfRouteKeys, route)) continue;
                sb.append(key).append(routeKeys).append(" begin! ");
                this.alterTableField(routeInfo);
                sb.append(key).append(routeKeys).append(" end! ");
            }
            catch (Exception e) {
                success = false;
                String err = WfUtils.getExceptionStacktrace((Throwable)e);
                sb.append(key).append(routeKeys).append(" alter failed! ").append(err);
                this.log.debug(String.format("%s alter failed! %s", routeKeys, err));
            }
        }
        sb.append("finish...");
        this.wrapResultMap(resultMap, success, "", "", sb.toString());
        return resultMap;
    }

    private boolean isSameDatabaseWithWorkflow(Set<String> wfRouteKeys, String route) {
        for (String wfRoute : wfRouteKeys) {
            if (!DB.isUseTheSameDatabase((String[])new String[]{route, wfRoute})) continue;
            this.log.debug(String.format("%s and %s in the same database", route, wfRoute));
            return true;
        }
        return false;
    }

    private void alterTableField(DBRouteInfo routeInfo) {
        DBRoute dbRoute = routeInfo.getDbRoute();
        boolean existTable = this.isExistTable(dbRoute, "t_wf_jobrecord");
        if (existTable) {
            TXHandle h = TX.beginNew();
            try {
                DB.execute((DBRoute)dbRoute, (String)ALTER_SQL_1, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)ALTER_SQL_2, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)ALTER_SQL_3, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)ALTER_SQL_4, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)ALTER_SQL_5, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)ALTER_SQL_6, (Object[])new Object[0]);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
            finally {
                h.end();
            }
        } else {
            this.log.debug(String.format("%s %s \u5e93\u4e2d\u4e0d\u5b58\u5728 %s\uff01", routeInfo.getInsid(), routeInfo.getRouteKeys(), "t_wf_jobrecord"));
        }
    }
}

