/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class ClearEntityOperationCacheServiceImpl
implements IUpgradeService {
    private Log log = LogFactory.getLog(this.getClass());

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("start...");
        boolean success = true;
        try {
            Set<String> entityOps = this.getAllEntityOperations();
            if (entityOps != null && !entityOps.isEmpty()) {
                WfCacheHelper.removeCacheByKeys((String[])entityOps.toArray(new String[entityOps.size()]));
            }
            sb.append("finish...");
        }
        catch (Exception e) {
            this.log.warn("error clear cache when upgrade.");
        }
        this.wrapResultMap(resultMap, success, "", "", sb.toString());
        return resultMap;
    }

    private Set<String> getAllEntityOperations() {
        HashSet<String> set = new HashSet<String>(16);
        String sql = "select FENTITYNUMBER,FOPERATION from t_wf_procdefinfo";
        try (DataSet ds = DB.queryDataSet((String)"ClearEntityOperationCache.beforeExecuteSql", (DBRoute)DBRoute.workflow, (String)sql);){
            if (!ds.isEmpty()) {
                for (Row row : ds) {
                    set.add(WfCacheHelper.getWholeKey((String[])new String[]{row.getString("FENTITYNUMBER"), row.getString("FOPERATION")}));
                }
            }
        }
        return set;
    }

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.wrapResultMap(resultMap, true, "", "", "success");
        return resultMap;
    }

    private Map<String, Object> wrapResultMap(Map<String, Object> resultMap, boolean success, String log, String el, String errorInfo) {
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", el);
        resultMap.put("errorInfo", errorInfo);
        return resultMap;
    }
}

