/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.UpgradeServiceUtil;

public class ModelAndProcdefApplicationIdUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ModelAndProcdefApplicationIdUpgradeServiceImpl.class);

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean success = true;
        String log = null;
        StringBuilder info = new StringBuilder();
        try {
            int modelCount = 0;
            List<Object[]> modelParams = this.getApplicationIdUpdateParams("t_wf_model");
            String updateModelSql = "update t_wf_model set fapplicationid = ? where fid= ? and fapplicationid = ' ' ";
            try (TXHandle tx = TX.requiresNew();){
                modelCount = WfUtils.executeBatch((String)updateModelSql, modelParams, (Integer)5000);
            }
            if (0 == modelCount) {
                info.append(ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u8ba1\u5217\u8868\u4e2d\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"ModelAndProcdefApplicationIdUpgradeServiceImpl_0", (String)"bos-wf-servicehelper", (Object[])new Object[0]));
            } else {
                info.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fee\u590d\u6d41\u7a0b\u8bbe\u8ba1\u5217\u8868\uff1a\u201c%s\u201d\u6761\u6570\u636e\u3002", (String)"ModelAndProcdefApplicationIdUpgradeServiceImpl_1", (String)"bos-wf-servicehelper", (Object[])new Object[0]), modelCount));
            }
            int procdefCount = 0;
            List<Object[]> procdefParams = this.getApplicationIdUpdateParams("t_wf_procdef");
            String updateProcdefSql = "update t_wf_procdef set fapplicationid = ? where fid= ? and fapplicationid = ' ' ";
            try (TXHandle th = TX.requiresNew();){
                procdefCount = WfUtils.executeBatch((String)updateProcdefSql, procdefParams, (Integer)5000);
            }
            if (0 == procdefCount) {
                info.append(ResManager.loadKDString((String)"\u6d41\u7a0b\u7ba1\u7406\u5217\u8868\u4e2d\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"ModelAndProcdefApplicationIdUpgradeServiceImpl_2", (String)"bos-wf-servicehelper", (Object[])new Object[0]));
            } else {
                info.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fee\u590d\u6d41\u7a0b\u7ba1\u7406\u5217\u8868\uff1a\u201c%s\u201d\u6761\u6570\u636e\u3002", (String)"ModelAndProcdefApplicationIdUpgradeServiceImpl_3", (String)"bos-wf-servicehelper", (Object[])new Object[0]), procdefCount));
            }
            log = "ModelAndProcdefApplicationIdUpgradeServiceImpl upgrade success!";
        }
        catch (Exception e) {
            success = false;
            log = "ModelAndProcdefApplicationIdUpgradeServiceImpl upgrade error!";
            info.append(WfUtils.getExceptionStacktrace((Throwable)e));
            logger.warn("ModelAndProcdefApplicationIdUpgradeServiceImpl upgrade error,reason:" + info);
        }
        UpgradeServiceUtil.wrapResultMap(resultMap, success, log, "", info.toString());
        return resultMap;
    }

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        return UpgradeServiceUtil.afterExecuteSql(null);
    }

    private List<Object[]> getApplicationIdUpdateParams(String tableName) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String sql = "select fid,fentrabillid from " + tableName + " where fapplicationid = ' ' ";
        try (DataSet ds = DB.queryDataSet((String)"ModelAndProcdefApplicationIdUpgradeServiceImpl.beforeExecuteSql", (DBRoute)DBRoute.workflow, (String)sql);){
            if (!ds.isEmpty()) {
                Iterator rows = ds.iterator();
                while (rows.hasNext()) {
                    this.getUpdateParam(params, rows);
                }
            }
        }
        return params;
    }

    private void getUpdateParam(List<Object[]> params, Iterator<Row> rows) {
        Row row = rows.next();
        String entraBillId = row.getString("fentrabillid");
        if (WfUtils.isNotEmpty((String)entraBillId)) {
            try {
                String applicationId;
                DynamicObject dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)entraBillId);
                if (dynamicObject != null && WfUtils.isNotEmpty((String)(applicationId = dynamicObject.getString("id")))) {
                    params.add(new Object[]{applicationId, row.get("fid")});
                }
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u5165\u53e3\u5355\u636eId(entraBillId)\u83b7\u53d6\u5e94\u7528Id\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
    }
}

