/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.upgrade.UpgradeServiceUtil;

@Deprecated
public class ParticipantModelActNameUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ParticipantModelActNameUpgradeServiceImpl.class);

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean success = true;
        String log = null;
        StringBuilder info = new StringBuilder();
        int partModelCount = 0;
        try (TXHandle tx = TX.requiresNew();){
            List<Object[]> params = this.getParticipantModelUpdateParams();
            String updatePartModelSql = "update t_wf_participantmodel set factivityname = ? where fid= ? ";
            partModelCount = WfUtils.executeBatch((String)updatePartModelSql, params, (Integer)5000);
            String updatePartModelMultiLangSql = "update t_wf_participantmodel_l set factivityname = ? where fid= ? and flocaleid = 'zh_CN' ";
            WfUtils.executeBatch((String)updatePartModelMultiLangSql, params, (Integer)5000);
        }
        String msg = 0 == partModelCount ? ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u6a21\u578b\u8868\u4e2d\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\uff01", (String)"ParticipantModelActNameUpgradeServiceImpl_0", (String)"bos-wf-servicehelper", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u529f\u4fee\u590d\u53c2\u4e0e\u4eba\u6a21\u578b\u8868\uff1a%s\u6761\u6570\u636e\uff01", (String)"ParticipantModelActNameUpgradeServiceImpl_0", (String)"bos-wf-servicehelper", (Object[])new Object[]{partModelCount});
        info.append(msg);
        log = "ParticipantModelActNameUpgradeServiceImpl upgrade success!";
        UpgradeServiceUtil.wrapResultMap(resultMap, success, log, "", info.toString());
        return resultMap;
    }

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        return UpgradeServiceUtil.afterExecuteSql(null);
    }

    private List<Object[]> getParticipantModelUpdateParams() {
        ArrayList<Object[]> paramsList = null;
        String sql = "select fid,fprocdefid,fmodelid,ftaskactivityid,factivityname from t_wf_participantmodel";
        try (DataSet ds = DB.queryDataSet((String)"ParticipantModelActNameUpgradeServiceImpl.getParticipantModelUpdateParams", (DBRoute)DBRoute.workflow, (String)sql);){
            if (!ds.isEmpty()) {
                paramsList = new ArrayList<Object[]>();
                Iterator rows = ds.iterator();
                Object[] params = null;
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    Long partModelId = row.getLong("fid");
                    Long procDefId = row.getLong("fprocdefid");
                    Long modelId = row.getLong("fmodelid");
                    String activityId = row.getString("ftaskactivityid");
                    String activityName = row.getString("factivityname");
                    if (!WfUtils.isEmpty((String)activityName)) continue;
                    String flowElementName = "";
                    if (!WfUtils.isEmpty((Long)procDefId)) {
                        flowElementName = this.getActivityNameByProcDefId(procDefId, activityId);
                    } else if (!WfUtils.isEmpty((Long)modelId)) {
                        flowElementName = this.getActivityNameByModelId(modelId, activityId);
                    }
                    if (WfUtils.isEmpty((String)flowElementName)) continue;
                    params = new Object[]{flowElementName, partModelId};
                    paramsList.add(params);
                }
            }
        }
        return paramsList;
    }

    private String getActivityNameByProcDefId(Long procDefId, String activityId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)procDefId)};
        DynamicObject procDef = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)String.format("%s,%s", "resourceid", "entrabill"), (QFilter[])filters);
        if (procDef == null) {
            return null;
        }
        String entityNumber = procDef.getString("entrabill");
        if (!this.validateEntityNumber(entityNumber)) {
            logger.debug(String.format("%s not exist.", entityNumber));
            return null;
        }
        Long resourceId = procDef.getLong("resourceid");
        return this.getActivityNameByResourceId(activityId, resourceId);
    }

    private String getActivityNameByModelId(Long modelId, String activityId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)modelId)};
        DynamicObject model = QueryServiceHelper.queryOne((String)"wf_model", (String)String.format("%s,%s", "bpmnxmlid", "entrabill"), (QFilter[])filters);
        if (model == null) {
            return null;
        }
        String entityNumber = model.getString("entrabill");
        if (!this.validateEntityNumber(entityNumber)) {
            logger.debug(String.format("%s not exist.", entityNumber));
            return null;
        }
        Long resourceId = model.getLong("bpmnxmlid");
        return this.getActivityNameByResourceId(activityId, resourceId);
    }

    private boolean validateEntityNumber(String entityNumber) {
        return QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityNumber)});
    }

    private String getActivityNameByResourceId(String activityId, Long resourceId) {
        if (WfUtils.isEmpty((Long)resourceId)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)resourceId)};
        DynamicObject resource = QueryServiceHelper.queryOne((String)"wf_resource", (String)"data", (QFilter[])filters);
        if (resource == null) {
            return null;
        }
        String modelJson = resource.getString("data");
        if (WfUtils.isEmpty((String)modelJson)) {
            return null;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)modelJson);
        if (bpmnModel == null) {
            return null;
        }
        FlowElement flowElement = bpmnModel.getFlowElement(activityId);
        if (flowElement != null) {
            return flowElement.getName();
        }
        return null;
    }
}

