/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class ProcessConfigUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ProcessConfigUpgradeServiceImpl.class);
    private static final String PROCDEFID = "procdefid";
    private static final String CONTENT = "content";
    private static final String ENABLE = "enable";
    private static final String ENTRABILL = "entrabill";
    private static final String OPERATION = "operation";
    private static final String CREATEDATE = "createdate";
    private static final String MODIFYDATE = "modifydate";
    private static final String SUCCESS = "success";

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String sql = "SELECT res.FCONTENT as FCONTENT,procdef.FID as fprocdefid,procdef.FENABLE as FENABLE,procdef.FENTRABILL as FENTRABILL,procdef.FOPERATION as FOPERATION,procdef.FCREATEDATE as FCREATEDATE,procdef.FMODIFYDATE as FMODIFYDATE FROM t_wf_procdef procdef left join t_wf_gebytearray res on procdef.FRESOURCEID=res.fid where procdef.fid in (select fprocdefid from t_wf_processconfig where Fentitynumber = ' ')";
            ResultSetHandler<List<Map<String, Object>>> action = new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> configDatas = new ArrayList<Map<String, Object>>(7);
                    while (rs.next()) {
                        HashMap<String, Object> configData = new HashMap<String, Object>();
                        configData.put(ProcessConfigUpgradeServiceImpl.PROCDEFID, rs.getLong("fprocdefid"));
                        configData.put(ProcessConfigUpgradeServiceImpl.CONTENT, rs.getString("FCONTENT"));
                        configData.put(ProcessConfigUpgradeServiceImpl.ENABLE, rs.getString("FENABLE"));
                        configData.put(ProcessConfigUpgradeServiceImpl.ENTRABILL, rs.getString("FENTRABILL"));
                        configData.put(ProcessConfigUpgradeServiceImpl.OPERATION, rs.getString("FOPERATION"));
                        configData.put(ProcessConfigUpgradeServiceImpl.CREATEDATE, rs.getDate("FCREATEDATE"));
                        configData.put(ProcessConfigUpgradeServiceImpl.MODIFYDATE, rs.getDate("FMODIFYDATE"));
                        configDatas.add(configData);
                    }
                    return configDatas;
                }
            };
            List configDatas = (List)DB.query((DBRoute)DBRoute.workflow, (String)sql, null, (ResultSetHandler)action);
            if (configDatas != null && configDatas.size() > 0) {
                ArrayList<SqlParameter[]> sqlParameters = new ArrayList<SqlParameter[]>(configDatas.size());
                String updateConfigSql = "UPDATE t_wf_processconfig SET fentitynumber=?,foperation=?,fisallownextperson=?,fenable=?,fcreatedate=?,fmodifydate=? WHERE fprocdefid=?";
                for (Map configData : configDatas) {
                    String enable;
                    String allowNextPersonWhenStartFieldVal = "0";
                    if (configData.get(CONTENT) != null) {
                        String content = (String)configData.get(CONTENT);
                        Object allowNextPersonObj = BpmnModelUtil.getProcessProperty((String)content, (String)"properties.allowNextPersonSettingModel.allowNextPersonWhenMatch");
                        if (null == allowNextPersonObj) {
                            allowNextPersonObj = BpmnModelUtil.getProcessProperty((String)content, (String)"properties.allowNextPersonWhenStart");
                        }
                        if (Boolean.TRUE.equals(allowNextPersonObj)) {
                            allowNextPersonWhenStartFieldVal = "1";
                        }
                    }
                    String enableFieldVal = "0";
                    if (configData.get(ENABLE) != null && ENABLE.equalsIgnoreCase(enable = (String)configData.get(ENABLE))) {
                        enableFieldVal = "1";
                    }
                    Long procDefIdFieldVal = null;
                    if (configData.get(PROCDEFID) != null) {
                        procDefIdFieldVal = (Long)configData.get(PROCDEFID);
                    }
                    String entityNumberFieldVal = " ";
                    if (configData.get(ENTRABILL) != null) {
                        entityNumberFieldVal = (String)configData.get(ENTRABILL);
                    }
                    String operationFieldVal = " ";
                    if (configData.get(OPERATION) != null) {
                        operationFieldVal = (String)configData.get(OPERATION);
                    }
                    Date createDateFieldVal = null;
                    if (configData.get(CREATEDATE) != null) {
                        createDateFieldVal = (Date)configData.get(CREATEDATE);
                    }
                    Date modifyDateFieldVal = null;
                    if (configData.get(MODIFYDATE) != null) {
                        modifyDateFieldVal = (Date)configData.get(MODIFYDATE);
                    }
                    SqlParameter[] params = new SqlParameter[]{new SqlParameter(":fentitynumber", 12, (Object)entityNumberFieldVal), new SqlParameter(":foperation", 12, (Object)operationFieldVal), new SqlParameter(":fisallownextperson", 1, (Object)allowNextPersonWhenStartFieldVal), new SqlParameter(":fenable", 1, (Object)enableFieldVal), new SqlParameter(":fcreatedate", 91, (Object)createDateFieldVal), new SqlParameter(":fmodifydate", 91, (Object)modifyDateFieldVal), new SqlParameter(":fprocdefid", -5, (Object)procDefIdFieldVal)};
                    sqlParameters.add(params);
                }
                DB.executeBatch((DBRoute)DBRoute.workflow, (String)updateConfigSql, sqlParameters);
            }
            this.wrapResultMap(resultMap, true, "", "", SUCCESS);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = Arrays.toString(e.getStackTrace());
            }
            logger.info("ProcessConfigUpgradeServiceImpl--- upgrade is error:" + e.getMessage());
            this.wrapResultMap(resultMap, false, e.getMessage(), "", e.getMessage());
        }
        return resultMap;
    }

    private Map<String, Object> wrapResultMap(Map<String, Object> resultMap, boolean success, String log, String el, String errorInfo) {
        resultMap.put(SUCCESS, success);
        resultMap.put("log", log);
        resultMap.put("el", el);
        resultMap.put("errorInfo", errorInfo);
        return resultMap;
    }

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.wrapResultMap(resultMap, true, "", "", SUCCESS);
        return resultMap;
    }
}

