/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.UpgradeServiceUtil;

public class ProcessInstanceUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ProcessInstanceUpgradeServiceImpl.class);

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean success = true;
        String log = null;
        StringBuffer info = new StringBuffer();
        try {
            int executionCount = 0;
            List<Object[]> params = this.getProcessInstanceUpdateParams();
            String updateExecutionSql = "update t_wf_execution set fbillno = ? where fprocinstid= ? ";
            try (TXHandle tx = TX.requiresNew();){
                executionCount = WfUtils.executeBatch((String)updateExecutionSql, params, (Integer)5000);
            }
            if (0 == executionCount) {
                info.append(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u8868\u4e2d\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"ProcessInstanceUpgradeServiceImpl_1", (String)"bos-wf-servicehelper", (Object[])new Object[0]));
            } else {
                info.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fee\u590d\u6d41\u7a0b\u5b9e\u4f8b\u8868\uff1a%s\u6761\u6570\u636e\u3002", (String)"ProcessInstanceUpgradeServiceImpl_2", (String)"bos-wf-servicehelper", (Object[])new Object[0]), executionCount));
            }
            int hiprocinstCount = 0;
            String updateHiprocinstSql = "update t_wf_hiprocinst set fbillno = ? where fid= ? ";
            try (TXHandle th = TX.requiresNew();){
                hiprocinstCount = WfUtils.executeBatch((String)updateHiprocinstSql, params, (Integer)5000);
            }
            if (0 == hiprocinstCount) {
                info.append(ResManager.loadKDString((String)"\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u8868\u4e2d\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"ProcessInstanceUpgradeServiceImpl_3", (String)"bos-wf-servicehelper", (Object[])new Object[0]));
            } else {
                info.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fee\u590d\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u8868\uff1a%s\u6761\u6570\u636e\u3002", (String)"ProcessInstanceUpgradeServiceImpl_4", (String)"bos-wf-servicehelper", (Object[])new Object[0]), hiprocinstCount));
            }
            log = "ProcessInstanceUpgradeServiceImpl upgrade success!";
        }
        catch (Exception e) {
            success = false;
            log = "ProcessInstanceUpgradeServiceImpl upgrade error!";
            info.append(WfUtils.getExceptionStacktrace((Throwable)e));
            logger.warn("ProcessInstanceUpgradeServiceImpl upgrade error,reason:" + info);
        }
        UpgradeServiceUtil.wrapResultMap(resultMap, success, log, "", info.toString());
        return resultMap;
    }

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        return UpgradeServiceUtil.afterExecuteSql(null);
    }

    private List<Object[]> getProcessInstanceUpdateParams() {
        ArrayList<Object[]> paramsList = null;
        String sql = "select distinct hip.fid,hitask.fbillno from t_wf_hiprocinst hip left join t_wf_hitaskinst hitask on hip.fid = hitask.fprocinstid where hip.fbillno = ' ' ";
        try (DataSet ds = DB.queryDataSet((String)"ProcessInstanceUpgradeServiceImpl.beforeExecuteSql", (DBRoute)DBRoute.workflow, (String)sql);){
            if (!ds.isEmpty()) {
                paramsList = new ArrayList<Object[]>();
                Iterator rows = ds.iterator();
                Object[] params = null;
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    if (!WfUtils.isNotEmpty((String)row.getString("fbillno"))) continue;
                    params = new Object[]{row.get("fbillno"), row.get("fid")};
                    paramsList.add(params);
                }
            }
        }
        return paramsList;
    }
}

