/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.upgrade.UpgradeServiceUtil;

public class RepairParticipantNameUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(RepairParticipantNameUpgradeServiceImpl.class);

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean success = true;
        String log = null;
        StringBuilder info = new StringBuilder();
        try (TXHandle tx = TX.requiresNew();){
            log = "RepairParticipantNameUpgradeServiceImpl--- insert is success!";
            info.append(this.getInfoForInsert("t_wf_participant", "wf_participant", "t_wf_participant_l")).append(this.getInfoForInsert("t_wf_hiparticipant", "wf_hiparticipant", "t_wf_hiparticipant_l"));
        }
        catch (Exception e) {
            success = false;
            log = "RepairParticipantNameUpgradeServiceImpl--- insert is error!";
            info.append(e.getMessage());
            if (StringUtils.isBlank((CharSequence)info)) {
                info.append(Arrays.toString(e.getStackTrace()));
            }
            logger.info("RepairParticipantNameUpgradeServiceImpl--- insert is error:" + info);
        }
        UpgradeServiceUtil.wrapResultMap(resultMap, success, log, "", info.toString());
        return resultMap;
    }

    private String getInfoForInsert(String tableName, String entityName, String tableNameForMul) {
        String info = null;
        int count = 0;
        List<Object[]> paramsList = this.getParamsList(tableName, entityName, tableNameForMul);
        if (WfUtils.isNotEmptyForCollection(paramsList)) {
            String insertSql = "INSERT into " + tableNameForMul + " VALUES(?, ?, ?, ?) ";
            try {
                count = WfUtils.executeBatch((String)insertSql, paramsList, (Integer)1000);
            }
            catch (Exception e) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        info = 0 == count ? String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"RepairParticipantNameUpgradeServiceImpl_4", (String)"bos-wf-servicehelper", (Object[])new Object[0]), tableNameForMul) : String.format(ResManager.loadKDString((String)"\u6210\u529f\u4fee\u590d\u6570\u636e%s\u6761\u3002", (String)"RepairParticipantNameUpgradeServiceImpl_5", (String)"bos-wf-servicehelper", (Object[])new Object[0]), tableNameForMul);
        return info;
    }

    private List<Object[]> getParamsList(String tableName, String entityName, String tableNameForMul) {
        ArrayList<Object[]> paramsList;
        block34: {
            paramsList = null;
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT count(1) num from ").append(tableNameForMul);
            try (DataSet dsForMul = DB.queryDataSet((String)("RepairParticipantNameUpgradeServiceImpl.beforeExecuteSql." + tableNameForMul), (DBRoute)DBRoute.workflow, (String)sql.toString());){
                if (dsForMul.isEmpty()) break block34;
                Iterator rows = dsForMul.iterator();
                Row row = null;
                int count = 0;
                if (null != rows && rows.hasNext() && null != (row = (Row)rows.next())) {
                    count = row.getInteger("num");
                }
                if (count != 0) break block34;
                sql = new StringBuilder();
                sql.append("SELECT fid, fuserid from ").append(tableName);
                try (DataSet ds = DB.queryDataSet((String)("RepairParticipantNameUpgradeServiceImpl.beforeExecuteSql." + tableName), (DBRoute)DBRoute.workflow, (String)sql.toString());){
                    if (null == ds) break block34;
                    paramsList = new ArrayList<Object[]>();
                    Object[] params = null;
                    Object fpkid = null;
                    Long userId = null;
                    String userName = null;
                    rows = ds.iterator();
                    if (null == rows) break block34;
                    try {
                        Object[] fpkids = ORM.create().genStringIds(entityName, ds.count("fid", false));
                        int i = 0;
                        if (WfUtils.isNotEmptyForArrays((Object[])fpkids) && i < fpkids.length) {
                            while (rows.hasNext()) {
                                row = (Row)rows.next();
                                if (null != row && null != (userName = WfUtils.findUserNameForSimplifiedCHINESE((Long)(userId = row.getLong("fuserid")))) && WfUtils.isNotEmpty((String)(fpkid = fpkids[i]))) {
                                    params = new Object[]{fpkid, row.get("fid"), Locale.SIMPLIFIED_CHINESE.toString(), userName};
                                    paramsList.add(params);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                    }
                }
                catch (Exception e) {
                    logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
            catch (Exception e) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return paramsList;
    }

    public Map<String, Object> afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        return UpgradeServiceUtil.afterExecuteSql(null);
    }
}

