/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.ProcTemplateExportModel;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowPresetProcTemplateServiceImpl
implements IUpgradeService {
    protected Log log = LogFactory.getLog(this.getClass());

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String fields = "id, filecontent, issuccess, executiontime, errorinfo";
        QFilter[] filters = new QFilter[]{new QFilter("filename", "=", (Object)sqlFileName)};
        DynamicObject[] deployInfos = BusinessDataServiceHelper.load((String)"wf_deploysql", (String)fields, (QFilter[])filters, (String)"id desc");
        if (deployInfos.length < 1) {
            UpgradeResult result = new UpgradeResult();
            result.setSuccess(false);
            result.setErrorInfo(String.format("The deployInfo of %s can not found.", sqlFileName));
            return result;
        }
        return this.deployProcTemplate(deployInfos[0]);
    }

    protected UpgradeResult deployProcTemplate(DynamicObject deployInfo) {
        UpgradeResult result = new UpgradeResult();
        ArrayList<Long> entryIds = new ArrayList<Long>(16);
        try {
            deployInfo.set("executiontime", (Object)WfUtils.now());
            String content = deployInfo.getString("filecontent");
            if (WfUtils.isEmpty((String)content)) {
                StringBuilder datas = new StringBuilder();
                String sql = String.format("SELECT FENTRYID,FCONTENT FROM T_WF_DEPLOYSQLDETAIL WHERE FID = %s ORDER BY FSEQ ASC;", deployInfo.get("id"));
                try (DataSet ds = DB.queryDataSet((String)"wf.deploysql.querySqlContent", (DBRoute)WfUtils.WFS, (String)sql);){
                    for (Row row : ds) {
                        datas.append(row.getString("FCONTENT"));
                        entryIds.add(row.getLong("FENTRYID"));
                    }
                }
                content = datas.toString();
            }
            String procTplXml = (String)SerializationUtils.deSerializeFromBase64((String)content);
            DcxmlSerializer serializer = new DcxmlSerializer(ProcTemplateExportModel.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            ProcTemplateExportModel model = (ProcTemplateExportModel)serializer.deserializeFromString(procTplXml, null);
            DynamicObject template = (DynamicObject)model.getTemplates().get(0);
            template.set("preset", (Object)true);
            template.set("status", (Object)"enable");
            this.importProcTemplate(model, template);
            result.setSuccess(true);
            deployInfo.set("issuccess", (Object)true);
        }
        catch (Exception e) {
            String errorInfo = WfUtils.getExceptionStacktrace((Throwable)e);
            deployInfo.set("errorinfo", (Object)errorInfo);
            result.setSuccess(false);
            result.setErrorInfo(errorInfo);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{deployInfo});
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"wf_deploysql");
        EntityType entryEntityType = (EntityType)entityType.getAllEntities().get("entryentity");
        DeleteServiceHelper.delete((IDataEntityType)entryEntityType, (Object[])entryIds.toArray());
        return result;
    }

    private void importProcTemplate(ProcTemplateExportModel model, DynamicObject template) {
        String templateNumber = template.getString("number");
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)templateNumber)};
        boolean isCover = QueryServiceHelper.exists((String)"wf_proctemplate", (QFilter[])filters);
        RepositoryService repositoryService = service.getRepositoryService();
        repositoryService.importProcTemplate(model, isCover, Boolean.valueOf(false));
        try {
            List entities = repositoryService.findEntitiesByFilters("wf_proctemplate", filters, "id", "MODIFYDATE DESC");
            if (!entities.isEmpty()) {
                String sql = "UPDATE T_WF_PROCTPL SET FCREATEDATE = ?, FMODIFYDATE = ?, FCREATORID = ?, FMODIFIERID = ? WHERE FID = ?;";
                Object[] params = new Object[]{template.getDate("createDate"), template.getDate("modifyDate"), template.getLong("creatorid_id"), template.getLong("modifierid_id"), ((Entity)entities.get(0)).getId()};
                DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])params);
            }
        }
        catch (Exception e) {
            this.log.info(String.format("update template info failed. %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }
}

