/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class BecSystemParamterUtils {
    private static final String BECAPPID = "0P2FWW95+QU6";
    private static final String QUERYTIMERJOBCOUNT = "querytimerjobcount";
    private static final String RETENTIONTIME = "retentiontime";
    private static final String MUTEXCHECKFOROPERATIONS = "mutexcheckforoperations";
    public static final Log logger = LogFactory.getLog(BecSystemParamterUtils.class);

    public static Object getSysParamConfig(String key) {
        AppParam param = new AppParam();
        param.setAppId(BECAPPID);
        String userId = RequestContext.get().getUserId();
        logger.debug("userId may has exception, result:" + userId);
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(userId));
        logger.debug("mainOrgId may has exception, result:" + mainOrgId);
        if (StringUtils.isBlank((Object)mainOrgId) || mainOrgId.equals(0L)) {
            param.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        } else {
            param.setOrgId(mainOrgId);
        }
        param.setViewType("01");
        Object obj = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)key);
        logger.debug("getSysParamConfig may has exception:" + param.getOrgId() + " and result:" + obj);
        param.setViewType("15");
        Object obj1 = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)key);
        logger.debug("getSysParamConfig may has exception:" + param.getOrgId() + " and result:" + obj1);
        return obj;
    }

    public static int getQuerytimerJobCount() {
        try {
            Object queryCount = BecSystemParamterUtils.getSysParamConfig(QUERYTIMERJOBCOUNT);
            if (queryCount != null) {
                return (Integer)queryCount;
            }
            logger.debug("getQuerytimerJobCount is null");
            return 50;
        }
        catch (Exception e) {
            logger.warn(QUERYTIMERJOBCOUNT + WfUtils.getExceptionStacktrace(e));
            return 50;
        }
    }

    public static int getRetentionTime() {
        try {
            Object retentiontime = BecSystemParamterUtils.getSysParamConfig(RETENTIONTIME);
            if (retentiontime != null) {
                return (Integer)retentiontime;
            }
            logger.debug("getRetentionTime is null");
            return 7;
        }
        catch (Exception e) {
            logger.info(RETENTIONTIME + WfUtils.getExceptionStacktrace(e));
            return 7;
        }
    }

    public static boolean isMutexCheckForOperations() {
        boolean isMutexCheckForOperations = Boolean.TRUE;
        try {
            Object mutexCheckForOperations = BecSystemParamterUtils.getSysParamConfig(MUTEXCHECKFOROPERATIONS);
            if (StringUtils.isNotBlank((Object)mutexCheckForOperations)) {
                isMutexCheckForOperations = (Boolean)mutexCheckForOperations;
            }
        }
        catch (Exception e) {
            logger.info(String.format("BecSystemParamterUtils-%s-%s", "isMutexCheckForOperations", e.getMessage()));
        }
        return isMutexCheckForOperations;
    }
}

