/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class EvtConfigurationUtil {
    protected static Log logger = LogFactory.getLog(EvtConfigurationUtil.class);
    private static final String VALUE = "value";
    private static final String KEYWORD = "key";
    public static final String BATCHSENDMESSAGEMAXCOUNT = "batchSendMessageMaxCount";
    public static final String DOWNGRADEQUEUE = "bec.engine.downGradeQueue";
    public static final String IFNEEDDEGRADE = "bec.engine.ifNeedDegrade";
    public static final String SLOWEVENTQUEUE = "bec.engine.slowEventQueue";
    public static final String URGENTEVENTQUEUE = "bec.engine.urgentEventQueue";
    public static final String ENGINESENDEVTTHRESHOLD = "bec.engine.sendEvtMqThreshold";
    public static final String ENGINEIFNEEDSUBAPP = "bec.engine.ifNeedSubApp";
    public static final String IFMOVEHIJOB = "bec.engine.ifMoveToHiJob";
    public static final String BUSINESSKEYMAXCOUNT = "bec.engine.businesskeyMaxCount";

    private EvtConfigurationUtil() {
    }

    public static Object getConfigCenterVal(String key) {
        try {
            DynamicObject t;
            Iterator iter;
            QFilter qs = new QFilter(KEYWORD, "=", (Object)key);
            Map ret = BusinessDataServiceHelper.loadFromCache((String)"wf_confcenter", (String)VALUE, (QFilter[])new QFilter[]{qs});
            if (ret != null && ret.size() > 0 && (iter = ret.values().iterator()).hasNext() && (t = (DynamicObject)iter.next()) != null) {
                return t.get(VALUE);
            }
        }
        catch (Exception e) {
            logger.info(String.format("there is error on getting configcenter value,msg is [%s]", e.getMessage()));
        }
        return null;
    }

    private static boolean getBooleanConfigCenterVal(String key) {
        Object val = EvtConfigurationUtil.getConfigCenterVal(key);
        return val != null ? "true".equals(val) : false;
    }

    public static int getBatchSendMessageMaxCount() {
        int count = 150;
        try {
            Object ret = EvtConfigurationUtil.getConfigCenterVal(BATCHSENDMESSAGEMAXCOUNT);
            if (ret != null) {
                count = Integer.parseInt((String)ret);
            }
        }
        catch (Exception e) {
            logger.info("getBatchSendMessageMaxCount function has exception:" + EvtUtils.getExceptionStacktrace(e));
        }
        return count;
    }

    public static String getSendEvtMqThreshold() {
        try {
            return (String)WfConfigurationUtil.getConfigCenterVal(ENGINESENDEVTTHRESHOLD);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isEvtNeedSubApp() {
        try {
            return EvtConfigurationUtil.getBooleanConfigCenterVal(ENGINEIFNEEDSUBAPP);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean ifNeedDegrade(Long executionId) {
        try {
            if (WfUtils.isEmpty(executionId)) {
                return false;
            }
            Object executionIds = EvtConfigurationUtil.getConfigCenterVal(IFNEEDDEGRADE);
            if (executionIds != null && WfUtils.isNotEmptyString(executionIds)) {
                List<String> result = Arrays.asList(((String)executionIds).split(","));
                return result.contains(executionId.toString());
            }
        }
        catch (Exception e) {
            logger.error(String.format("get ifNeedDegrade system params is error: %s", WfUtils.getExceptionStacktrace(e)));
            return false;
        }
        return false;
    }

    public static boolean ifNeedDownGrade(Long eventId) {
        try {
            if (WfUtils.isEmpty(eventId)) {
                return false;
            }
            Object downGradeQueue = WfConfigurationUtil.getConfigCenterVal(DOWNGRADEQUEUE);
            if (downGradeQueue != null && WfUtils.isNotEmptyString(downGradeQueue)) {
                List<String> result = Arrays.asList(((String)downGradeQueue).split(","));
                if (result.size() < 3) {
                    return false;
                }
                int hour = LocalDateTime.now().getHour();
                int low = Integer.parseInt(result.get(0));
                int high = Integer.parseInt(result.get(1));
                if (hour >= low && hour < high) {
                    return result.contains(eventId.toString());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Integer getBecTriggerBusinesskeyMaxCount() {
        Integer result = 10000;
        try {
            Object val = EvtConfigurationUtil.getConfigCenterVal(BUSINESSKEYMAXCOUNT);
            if (null != val && WfUtils.isNotEmptyString(val)) {
                return Integer.valueOf(val.toString());
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }
}

