/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.BizErrorInfo;
import kd.bos.workflow.exception.ExceptionUtil;

public class EvtEngineUtils {
    protected static Log logger = LogFactory.getLog(EvtEngineUtils.class);

    public static boolean checkIfContinue(String sharingId) {
        String[] jobIds = EvtCacheHelper.getAcquireEvtJobIds(sharingId);
        if (jobIds == null || jobIds.length < 1) {
            return true;
        }
        for (String jobId : jobIds) {
            EvtJobEntity entity = Context.getCommandContext().getEvtJobEntityManager().findBothJobById(Long.valueOf(jobId));
            if (entity == null || !JobStateEnum.ERRORED.getNumber().equals(entity.getState()) && !JobStateEnum.COMPLETED.getNumber().equals(entity.getState())) {
                logger.info(String.format("\u6361\u6f0fcheckIfContinue\u4e0a\u6b21\u8fd8\u6ca1\u6d88\u8d39-%1$s-%2$s", sharingId, jobId));
                return false;
            }
            logger.info(String.format("\u6361\u6f0fcheckIfContinue\u4e0a\u6b21\u7684\u5df2\u7ecf\u6d88\u8d39\u4e86-%1$s-%2$s", sharingId, jobId));
        }
        EvtCacheHelper.removeAcquireEvtJobId(sharingId);
        return true;
    }

    public static boolean ifMatchWhiteList(ExecuteJob job, Throwable exception) {
        try {
            if (!EvtEngineUtils.isInWhiteList(job.getExecutionId())) {
                return false;
            }
            logger.debug(String.format("\u547d\u4e2d\u767d\u540d\u5355\uff1a%s", job.getExecutionId()));
            Map<String, String> cacheExceptionMap = EvtCacheHelper.getWhiteListMap(String.valueOf(job.getExecutionId()));
            if (cacheExceptionMap == null) {
                cacheExceptionMap = new HashMap<String, String>(1);
            }
            if (!cacheExceptionMap.isEmpty()) {
                return EvtEngineUtils.matchException(job, cacheExceptionMap, exception);
            }
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)job.getExecutionId(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"evt_whitelist_config"));
            DynamicObjectCollection entities = dyn.getDynamicObjectCollection("entryentity");
            int i = 1;
            int j = 10001;
            for (DynamicObject entity : entities) {
                if (!"1".equalsIgnoreCase(entity.getString("status"))) continue;
                String type = entity.getString("type");
                ILocaleString map = entity.getLocaleString("content");
                if (StringUtils.isEmpty((CharSequence)type)) continue;
                for (Map.Entry entry : map.entrySet()) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                    if ("0".equalsIgnoreCase(type)) {
                        cacheExceptionMap.put(String.valueOf(i), String.valueOf(entry.getKey()) + "##" + (String)entry.getValue());
                        ++i;
                        continue;
                    }
                    if (!"1".equalsIgnoreCase(type)) continue;
                    cacheExceptionMap.put(String.valueOf(j), String.valueOf(entry.getKey()) + "##" + (String)entry.getValue());
                    ++j;
                }
            }
            if (cacheExceptionMap.isEmpty()) {
                cacheExceptionMap.put("10000", "");
            }
            EvtCacheHelper.addWhiteListMap(String.valueOf(job.getExecutionId()), cacheExceptionMap);
            return EvtEngineUtils.matchException(job, cacheExceptionMap, exception);
        }
        catch (Exception e) {
            logger.warn(String.format("there is error on getting matchWhiteList value,msg is [%s]", e.getMessage()));
            return false;
        }
    }

    private static boolean isInWhiteList(Long id) {
        try {
            if (WfUtils.isEmpty(id)) {
                return false;
            }
            String subscriptionId = String.valueOf(id);
            String[] whiteListArr = EvtCacheHelper.getWhiteList();
            if (whiteListArr != null && whiteListArr.length > 0) {
                return new HashSet<String>(Arrays.asList(whiteListArr)).contains(subscriptionId);
            }
            HashSet<String> whiteListSet = new HashSet<String>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"GetEventWhiteListConfig", (String)"evt_whitelist_config", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.status", "=", (Object)"1")}, null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    String idStr = row.getString("id");
                    if (whiteListSet.add(idStr)) continue;
                }
            }
            if (whiteListSet.size() < 1) {
                whiteListSet.add("000");
            }
            EvtCacheHelper.addWhiteList(whiteListSet);
            return whiteListSet.contains(subscriptionId);
        }
        catch (Exception e) {
            logger.warn(String.format("there is error on getting isInWhiteList value,msg is [%s]", e.getMessage()));
            return false;
        }
    }

    private static boolean matchException(ExecuteJob job, Map<String, String> cacheExceptionMap, Throwable exception) {
        try {
            if (!(exception instanceof KDException)) {
                return false;
            }
            BizErrorInfo errorInfo = ExceptionUtil.getBizErrorCodeAndMsg(exception);
            String code = null;
            List<String> codeList = null;
            if (WfUtils.isNotEmpty(errorInfo.getErrCode()) && errorInfo.getErrCode().contains(",")) {
                codeList = Arrays.asList(StringUtils.split((String)errorInfo.getErrCode(), (String)","));
            } else {
                code = errorInfo.getErrCode();
            }
            String message = errorInfo.getErrMsg();
            if (StringUtils.isEmpty((CharSequence)code) && StringUtils.isEmpty((CharSequence)message)) {
                return false;
            }
            int matchCodes = 0;
            for (Map.Entry<String, String> entry : cacheExceptionMap.entrySet()) {
                String content;
                if (!RequestContext.get().getLang().toString().equals(entry.getValue().split("##")[0]) || StringUtils.isEmpty((CharSequence)(content = entry.getValue().split("##")[1]))) continue;
                int key = Integer.parseInt(entry.getKey());
                if (key < 10000 && content.equals(code)) {
                    logger.debug(String.format("hit white list error code\uff1a%s", content));
                    job.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u547d\u4e2d\u5f02\u5e38\u767d\u540d\u5355\uff0c\u6b63\u5e38\u6267\u884c\uff0c\u5f02\u5e38\u7f16\u7801\uff1a%1$s\uff0c\u547d\u4e2d\u7f16\u7801\uff1a%2$s\u3002", (String)"EvtEngineUtils_0", (String)"bos-wf-engine", (Object[])new Object[0]), code, code));
                    return true;
                }
                if (key < 10000 && codeList != null && codeList.contains(content)) {
                    logger.debug(String.format("hit white list error code\uff1a%s", content));
                    ++matchCodes;
                }
                if (key <= 10000 || !StringUtils.isNotEmpty((CharSequence)message) || !message.contains(content)) continue;
                logger.debug(String.format("hit white list error msg\uff1a%s", content));
                job.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u547d\u4e2d\u5f02\u5e38\u767d\u540d\u5355\uff0c\u6b63\u5e38\u6267\u884c\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%1$s\uff0c\u547d\u4e2d\u5173\u952e\u5b57\uff1a%2$s\u3002", (String)"EvtEngineUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), message, content));
                return true;
            }
            if (codeList != null && matchCodes > 0) {
                job.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u547d\u4e2d\u5f02\u5e38\u767d\u540d\u5355\uff0c\u6b63\u5e38\u6267\u884c\uff0c\u5f02\u5e38\u7f16\u7801\u96c6\u5408\uff1a%1$s\uff0c\u547d\u4e2d\uff1a%2$s\u6b21\u3002", (String)"EvtEngineUtils_2", (String)"bos-wf-engine", (Object[])new Object[0]), codeList, matchCodes));
                return true;
            }
        }
        catch (Exception e) {
            logger.error(String.format("there is error on getting matchException value,msg is [%s]", e.getMessage()));
        }
        return false;
    }

    public static void insertOneTask(CommandContext commandContext, Long subscriptionId, String type) {
        if (QueryServiceHelper.exists((String)"evt_devops_task", (QFilter[])new QFilter[]{new QFilter("subscriptionid", "=", (Object)subscriptionId), new QFilter("type", "=", (Object)type)})) {
            return;
        }
        StringBuilder batchSql = new StringBuilder();
        batchSql.append("insert into t_evt_devopstask").append(" (fid,fsubscriptionid,ftype,fcreatedate,fmodifydate)").append(" values").append(" (?,?,?,?,?)");
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(1);
        long id = ORM.create().genLongId("evt_devops_task");
        insertParamsList.add(new Object[]{id, subscriptionId, type, WfUtils.now(), WfUtils.now()});
        commandContext.getDbSqlSession().addBatchSQLInfo(new BatchSQLInfo(batchSql.toString(), insertParamsList, 1));
    }

    public static void deleteTask(CommandContext commandContext, Long subscriptionId, String type) {
        String sql = "delete from t_evt_devopstask where fsubscriptionid = ? and ftype = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        params.add(new Object[]{subscriptionId, type});
        commandContext.getDbSqlSession().addBatchSQLInfo(new BatchSQLInfo(sql, params, 1));
    }

    public static void updateTask(CommandContext commandContext, Long subscriptionId, String type) {
        String batchSql = "update t_evt_devopstask set fmodifydate = ? where fsubscriptionid = ? and ftype = ? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList.add(new Object[]{WfUtils.now(), subscriptionId, type});
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql, paramsList, 1);
        commandContext.getDbSqlSession().addBatchSQLInfo(batchSQLInfo);
    }
}

