/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.bec.engine.EvtEngineUtils;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntityImpl;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;

public class EvtJobDAO {
    protected static Log logger = LogFactory.getLog(EvtJobDAO.class);
    private static final String JOBTABLENAME = "t_evt_jobrecord";
    private static final String UPDATE = "update ";
    private static final String ADDPRIMARYKEY = "ALTER TABLE t_evt_jobrecord ADD CONSTRAINT PK_EVT_JOBRECORD PRIMARY KEY (FID)";
    private static final String CREATEJOBSQL = "CREATE TABLE t_evt_jobrecord (  FID bigint NOT NULL DEFAULT 0,  FTYPE varchar(30) NOT NULL DEFAULT ' ',  FLOCKEXPTIME datetime DEFAULT NULL,  FLOCKOWNERID varchar(100) NOT NULL DEFAULT ' ',  FEXCLUSIVE char(1) DEFAULT NULL,  FEXECUTIONID bigint NOT NULL DEFAULT 0,  FPROCESSINSTANCEID bigint NOT NULL DEFAULT 0,  FPROCDEFID bigint NOT NULL DEFAULT 0,  FRETRIES int NOT NULL DEFAULT 3,  FEXCEPTIONMSG NCLOB ,  FDUEDATE datetime DEFAULT NULL,    FREPEAT varchar(30) NOT NULL DEFAULT ' ',  FHANDLERTYPE varchar(30) NOT NULL DEFAULT ' ',  FHANDLERCFG NCLOB,  FBUSINESSKEY varchar(36) NOT NULL DEFAULT ' ',  FOPERATION varchar(100) NOT NULL DEFAULT ' ',  FENTITYNUMBER varchar(50) NOT NULL DEFAULT ' ',  FELEMENTID varchar(80) NOT NULL DEFAULT ' ',  FCREATEDATE datetime DEFAULT NULL,  FMODIFYDATE datetime DEFAULT NULL,  FSRCJOBID bigint NOT NULL DEFAULT 0,  FROOTTRACENO varchar(100) NOT NULL DEFAULT ' ',  FExecutor varchar(100) NOT NULL DEFAULT ' ',  FSUCCESS char(1) NOT NULL DEFAULT '0',  fendtime datetime DEFAULT NULL,  fduration bigint NOT NULL DEFAULT 0,  fstate varchar(100) NOT NULL DEFAULT ' ',  FSOURCE varchar(100) NOT NULL DEFAULT ' ',  FSRCTRACEID varchar(100) NOT NULL DEFAULT ' ',  FBIZKEY varchar(500) NOT NULL DEFAULT ' ',  FROOTEVENTINSTID bigint NOT NULL DEFAULT 0,  FROOTJOBID bigint NOT NULL DEFAULT 0  )";
    private static final String INSERTJOBSQL = "insert into t_evt_jobrecord(  FID,  FTYPE,  FLOCKEXPTIME,  FLOCKOWNERID,  FEXECUTIONID,  FPROCESSINSTANCEID,  FPROCDEFID,  FEXCEPTIONMSG,  FHANDLERTYPE,  FHANDLERCFG,  FBUSINESSKEY,  FOPERATION,  FENTITYNUMBER,  FELEMENTID,  FCREATEDATE,  FMODIFYDATE,  FROOTTRACENO,  FSTATE,  FSOURCE,  FROOTJOBID, FRETRIES, FBIZKEY, FSRCTRACEID,FROOTEVENTINSTID ) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String IDX_EVT_JOBRECORD_LOCKSTATE = "IDX_EVT_JOBRECORD_LOCKSTATE";
    private static final String LOCKTIME = "FLOCKEXPTIME,FSTATE";
    private static final String EVTJOBRECORD = "t_evt_jobrecord";
    private static final String SQLEVT = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_LOCKSTATE", "IDX_EVT_JOBRECORD_LOCKSTATE", "t_evt_jobrecord", "FLOCKEXPTIME,FSTATE");
    private static final String IDX_EVT_JOBREC_BUSKEY_STATE = "IDX_EVT_JOBREC_BUSKEY_STATE";
    private static final String IDX_EVT_JOBRECORD_CREATEDATE = "IDX_EVT_JOBRECORD_CREATEDATE";
    private static final String IDX_EVT_JOBRECORD_HANDTYPE = "IDX_EVT_JOBRECORD_HANDTYPE";
    private static final String IDX_EVT_JOBRECORD_ROOTEVTID = "IDX_EVT_JOBRECORD_ROOTEVTID";
    private static final String IDX_EVT_JOBRECORD_ROOTJOBID = "IDX_EVT_JOBRECORD_ROOTJOBID";
    private static final String IDX_EVT_JOBRECORD_ROOTTRACE = "IDX_EVT_JOBRECORD_ROOTTRACE";
    private static final String BUSINESSKEY = "FBUSINESSKEY,FSTATE";
    private static final String CREATEDATE = "FCREATEDATE";
    private static final String HANDLERTYPE = "FHANDLERTYPE";
    private static final String ROOTEVENTINSTID = "FROOTEVENTINSTID";
    private static final String FROOTJOBID = "FROOTJOBID";
    private static final String FROOTTRACENO = "FROOTTRACENO";
    private static final String SQLEVT1 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBREC_BUSKEY_STATE", "IDX_EVT_JOBREC_BUSKEY_STATE", "t_evt_jobrecord", "FBUSINESSKEY,FSTATE");
    private static final String SQLEVT2 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_CREATEDATE", "IDX_EVT_JOBRECORD_CREATEDATE", "t_evt_jobrecord", "FCREATEDATE");
    private static final String SQLEVT3 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_HANDTYPE", "IDX_EVT_JOBRECORD_HANDTYPE", "t_evt_jobrecord", "FHANDLERTYPE");
    private static final String SQLEVT4 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_ROOTEVTID", "IDX_EVT_JOBRECORD_ROOTEVTID", "t_evt_jobrecord", "FROOTEVENTINSTID");
    private static final String SQLEVT5 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_ROOTJOBID", "IDX_EVT_JOBRECORD_ROOTJOBID", "t_evt_jobrecord", "FROOTJOBID");
    private static final String SQLEVT6 = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( %s );", "IDX_EVT_JOBRECORD_ROOTTRACE", "IDX_EVT_JOBRECORD_ROOTTRACE", "t_evt_jobrecord", "FROOTTRACENO");

    public void insert(List<EvtJobEntity> jobs, String operation, String entityNumber, String dbrouteKey) {
        DBRoute dbRoute = DBRoute.workflow;
        if (WfUtils.isNotEmpty(dbrouteKey)) {
            dbRoute = DBRoute.of((String)dbrouteKey);
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(jobs.size());
        boolean existTable = WfCacheHelper.existEvtJobRecordTable(dbRoute.getRouteKey());
        if (!existTable) {
            existTable = DB.exitsTable((DBRoute)dbRoute, (String)"t_evt_jobrecord");
            if (!existTable) {
                long begin = System.currentTimeMillis();
                DB.execute((DBRoute)dbRoute, (String)CREATEJOBSQL, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)ADDPRIMARYKEY, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT1, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT2, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT3, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT4, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT5, (Object[])new Object[0]);
                DB.execute((DBRoute)dbRoute, (String)SQLEVT6, (Object[])new Object[0]);
                logger.debug(String.format("\u5728[%s]\u4e2d\u5efa\u8868\uff0c\u8017\u65f6[%s]", dbrouteKey, System.currentTimeMillis() - begin));
            } else {
                logger.debug(String.format("[%s]\u4e2d\u5df2\u5b58\u5728\u8be5\u8868", dbrouteKey));
            }
            WfCacheHelper.putEventJobSourceOfDbRouteKey(dbRoute.getRouteKey());
        }
        for (EvtJobEntity job : jobs) {
            job.setSource(JobHandleStrategyFactory.genenateSource(dbRoute.getRouteKey()));
            params.add(this.getInsertParam(job, operation, entityNumber));
        }
        if (!params.isEmpty()) {
            long begin = System.currentTimeMillis();
            DB.executeBatch((DBRoute)dbRoute, (String)INSERTJOBSQL, params);
            logger.debug(String.format("\u5728[%s]\u4e2d\u5411t_evt_jobrecord\u8868\u5199\u6570\u636e\uff0c\u8017\u65f6[%s]", dbrouteKey, System.currentTimeMillis() - begin));
        }
    }

    private Object[] getInsertParam(EvtJobEntity job, String operation, String entityNumber) {
        Long id = job.getId();
        if (WfUtils.isEmpty(job.getRootJobId())) {
            job.setRootJobId(id);
        }
        Date date = WfUtils.now();
        Object[] params = new Object[]{id, this.rightVal(job.getJobType()), job.getLockExpirationTime(), this.rightVal(job.getLockOwnerId()), this.rightVal(job.getExecutionId()), this.rightVal(job.getEventId()), this.rightVal(job.getProcessDefinitionId()), this.rightVal(job.getExceptionMessage()), this.rightVal(job.getJobHandlerType()), this.rightVal(job.getJobHandlerConfiguration()), this.rightVal(job.getBusinessKey()), this.rightVal(operation), this.rightVal(entityNumber), this.rightVal(job.getElementId()), date, date, this.rightVal(job.getRootTraceNo()), JobStateEnum.ERRORED.getNumber().equals(job.getState()) ? job.getState() : JobStateEnum.CREATED.getNumber(), this.rightVal(job.getSource()), this.rightVal(job.getRootJobId()), job.getRetries(), this.rightVal(job.getBizKey()), this.rightVal(job.getSrcTraceId()), this.rightVal(job.getRootEventInstId())};
        return params;
    }

    private String rightVal(String val) {
        return WfUtils.isEmpty(val) ? " " : val;
    }

    private Long rightVal(Long val) {
        return val == null ? Long.valueOf(0L) : val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String dbKey, ExecuteJob entity) {
        String sql = "update t_evt_jobrecord set FEXECUTOR = ?,FSTATE = ?,FROOTTRACENO=? where fid = ?";
        TXHandle h = TX.beginNew();
        try {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{entity.getExecutor(), entity.getState(), entity.getRootTraceNo(), entity.getId()});
        }
        catch (Exception e) {
            h.markRollback();
            logger.warn(String.format("\u66f4\u65b0job[%s]\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a[%s]", entity.getId(), e.getMessage()));
        }
        finally {
            h.end();
        }
    }

    public EvtJobEntity findById(Long id, String dbKey) {
        String sql = "select  FID, FTYPE, FLOCKEXPTIME, FLOCKOWNERID, FEXECUTIONID, FPROCESSINSTANCEID, FPROCDEFID, FEXCEPTIONMSG, FHANDLERTYPE, FHANDLERCFG, FBUSINESSKEY, FOPERATION, FENTITYNUMBER, FELEMENTID, FCREATEDATE, FMODIFYDATE, FROOTTRACENO, FSTATE, FSOURCE, FROOTJOBID, FRETRIES, FBIZKEY, FSRCTRACEID,  FEXECUTOR, FROOTEVENTINSTID from t_evt_jobrecord where fid = ?";
        EvtJobEntity job = (EvtJobEntity)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<EvtJobEntity>(){

            public EvtJobEntity handle(ResultSet rs) throws Exception {
                EvtJobEntityImpl job = null;
                if (rs.next()) {
                    job = new EvtJobEntityImpl();
                    EvtJobDAO.this.setJobInfo(rs, job);
                }
                return job;
            }
        });
        return job;
    }

    private void setJobInfo(ResultSet rs, EvtJobEntity job) throws SQLException {
        job.setId(rs.getLong("FID"));
        job.setJobType(rs.getString("FTYPE"));
        if (rs.getTimestamp("FLOCKEXPTIME") != null) {
            job.setLockExpirationTime(new Date(rs.getTimestamp("FLOCKEXPTIME").getTime()));
        }
        job.setLockOwnerId(rs.getString("FLOCKOWNERID"));
        job.setExecutionId(rs.getLong("FEXECUTIONID"));
        job.setProcessDefinitionId(rs.getLong("FPROCDEFID"));
        job.setProcessInstanceId(rs.getLong("FPROCESSINSTANCEID"));
        job.setExceptionMessage(rs.getString("FEXCEPTIONMSG"));
        job.setJobHandlerType(rs.getString(HANDLERTYPE));
        job.setJobHandlerConfiguration(rs.getString("FHANDLERCFG"));
        job.setBusinessKey(rs.getString("FBUSINESSKEY"));
        job.setOperation(rs.getString("FOPERATION"));
        job.setEntityNumber(rs.getString("FENTITYNUMBER"));
        job.setElementId(rs.getString("FELEMENTID"));
        if (rs.getTimestamp(CREATEDATE) != null) {
            job.setCreateDate(new Date(rs.getTimestamp(CREATEDATE).getTime()));
        }
        if (rs.getTimestamp("FMODIFYDATE") != null) {
            job.setModifyDate(new Date(rs.getTimestamp("FMODIFYDATE").getTime()));
        }
        job.setRootTraceNo(rs.getString(FROOTTRACENO));
        job.setState(rs.getString("FSTATE"));
        job.setSource(rs.getString("FSOURCE"));
        job.setRootJobId(rs.getLong(FROOTJOBID));
        job.setRetries(rs.getInt("FRETRIES"));
        job.setBizKey(rs.getString("FBIZKEY"));
        job.setSrcTraceId(rs.getString("FSRCTRACEID"));
        job.setRootEventInstId(rs.getLong(ROOTEVENTINSTID));
        job.setExecutor(rs.getString("FEXECUTOR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJob(EvtJobEntity jobEntity) {
        String dbKey = JobHandleStrategyFactory.getDBRouteKey(jobEntity.getSource());
        if (!DBRoute.workflow.getRouteKey().equals(dbKey)) {
            String sql = "delete from t_evt_jobrecord where fid = ?";
            TXHandle h = TX.beginNew();
            try {
                DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{jobEntity.getId()});
            }
            catch (Exception e) {
                h.markRollback();
                logger.warn(String.format("\u5220\u9664\u8fdc\u7aef\u5e93\u4e2d\u7684job[%s]\u5931\u8d25.", jobEntity.getId()));
            }
            finally {
                h.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String dbKey, EvtJobEntity entity) {
        String sql = "update t_evt_jobrecord set FLOCKEXPTIME = ?,FLOCKOWNERID = ?,FRETRIES=?,FSTATE = ? where fid = ?";
        TXHandle h = TX.beginNew();
        try {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{entity.getLockExpirationTime(), entity.getLockOwnerId(), entity.getRetries(), entity.getState(), entity.getId()});
        }
        catch (Exception e) {
            h.markRollback();
            logger.warn(String.format("\u5220\u9664\u8fdc\u7aef\u5e93\u4e2d\u7684job[%s]\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a[%s]", entity.getId(), e.getMessage()));
        }
        finally {
            h.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String dbKey, List<Object[]> params) {
        String sql = "update t_evt_jobrecord set FLOCKEXPTIME = ?,FLOCKOWNERID = ?,FRETRIES=?,FSTATE = ? where fid = ? and fstate in ('created','received','executing')";
        try (TXHandle h = TX.requiresNew();){
            WfDBUtils.executeBatch(DBRoute.of((String)dbKey), sql, params, 100);
        }
    }

    public List<EvtJobEntity> findExpiredJobs(String dbKey) {
        String sharingId;
        boolean exist = WfCacheHelper.existEvtJobRecordTable(dbKey);
        if (!exist) {
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)dbKey), (String)"t_evt_jobrecord");
            if (!existTable) {
                WfCacheHelper.removeSingleEventJobSourceOfDBRouteKey(dbKey);
                return Collections.emptyList();
            }
            WfCacheHelper.putEventJobSourceOfDbRouteKey(dbKey);
        }
        if ((sharingId = EvtCacheHelper.getSharingIdOfDbRouteKey(dbKey)) != null && !EvtEngineUtils.checkIfContinue(sharingId)) {
            return Collections.emptyList();
        }
        Object countVal = WfConfigurationUtil.getConfigCenterVal("acquireCountBec");
        int count = 50;
        try {
            if (countVal != null) {
                count = Integer.parseInt(String.valueOf(countVal));
            }
        }
        catch (Exception e) {
            logger.warn("val\u5728\u7c7b\u578b\u8f6c\u6362\u65f6\u51fa\u9519\uff01\u539f\u56e0\uff1a%s" + e.getMessage());
        }
        String sql = "select top  " + count + "  FID,   FTYPE,   FLOCKEXPTIME,   FLOCKOWNERID,   FEXECUTIONID,   FPROCESSINSTANCEID,   FPROCDEFID,   FEXCEPTIONMSG,   FHANDLERTYPE,   FHANDLERCFG,   FBUSINESSKEY,   FOPERATION,   FENTITYNUMBER,   FELEMENTID,   FCREATEDATE,   FMODIFYDATE,   FROOTTRACENO,   FSTATE,   FSOURCE,   FROOTJOBID,   FRETRIES ,  FBIZKEY,  FSRCTRACEID,  FEXECUTOR,  FROOTEVENTINSTID from " + "t_evt_jobrecord" + " where fstate in (?,?,?) and FLOCKEXPTIME <= ? order by FLOCKEXPTIME asc";
        Date date = WfUtils.now();
        try {
            logger.info(String.format("findExpiredJobs in databse[%s]", dbKey));
            List jobs = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber(), date}, (ResultSetHandler)new ResultSetHandler<List<EvtJobEntity>>(){

                public List<EvtJobEntity> handle(ResultSet rs) throws Exception {
                    ArrayList<EvtJobEntity> ret = new ArrayList<EvtJobEntity>(rs.getRow());
                    while (rs.next()) {
                        EvtJobEntityImpl job = new EvtJobEntityImpl();
                        EvtJobDAO.this.setJobInfo(rs, job);
                        ret.add(job);
                    }
                    return ret;
                }
            });
            EvtCacheHelper.removeAcquireEvtJobId(sharingId);
            if (jobs != null) {
                if (jobs.size() == 1) {
                    EvtCacheHelper.putAcquireEvtJobId(sharingId, new String[]{((EvtJobEntity)jobs.get(0)).getId().toString()});
                } else if (jobs.size() > 1) {
                    EvtCacheHelper.putAcquireEvtJobId(sharingId, new String[]{((EvtJobEntity)jobs.get(0)).getId().toString(), ((EvtJobEntity)jobs.get(jobs.size() - 1)).getId().toString()});
                }
            }
            return jobs;
        }
        catch (Exception e) {
            if (e instanceof KDException && ((KDException)((Object)e)).getErrorCode() != null && "bos.sQLTableNotExist".equalsIgnoreCase(((KDException)((Object)e)).getErrorCode().getCode())) {
                WfCacheHelper.removeSingleEventJobSourceOfDBRouteKey(dbKey);
            }
            logger.warn(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorMsg(String dbKey, Long taskId, String error) {
        String sql = "update t_evt_jobrecord set FEXCEPTIONMSG = ? where fid = ?";
        TXHandle h = TX.beginNew();
        try {
            DB.execute((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])new Object[]{error, taskId});
        }
        catch (Exception e) {
            h.markRollback();
            logger.warn(String.format("\u66f4\u65b0job[%s]\u9519\u8bef\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a[%s]", taskId, e.getMessage()));
        }
        finally {
            h.end();
        }
    }
}

