/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine;

import java.util.Collection;
import java.util.List;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.service.EvtService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.util.WfCommonUtil;
import org.apache.commons.lang.exception.ExceptionUtils;

public class EvtUtils {
    private static Log logger = LogFactory.getLog(EvtUtils.class);

    public static boolean isNotEmptyForCollection(Collection collection) {
        return !EvtUtils.isEmptyForCollection(collection);
    }

    public static EvtService getEvtService() {
        return (EvtService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(EvtService.class);
    }

    public static boolean isEmptyForCollection(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static String getExceptionStacktrace(Throwable exception) {
        if (exception == null) {
            return "exception is null!!!!";
        }
        if (exception instanceof WFEngineException && ((WFEngineException)((Object)exception)).getErrorCode() != null && (WFErrorCode.licenseVerifyException().getCode().equalsIgnoreCase(((WFEngineException)((Object)exception)).getErrorCode().getCode()) || WFErrorCode.licenseExceedLimitException().getCode().equalsIgnoreCase(((WFEngineException)((Object)exception)).getErrorCode().getCode()))) {
            return exception.getMessage();
        }
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    public static DynamicObject findBusinessObject(String businessKey, String entityNumber) {
        return EvtUtils.findBusinessObject(businessKey, entityNumber, null);
    }

    public static DynamicObject findBusinessObject(String businessKey, String entityNumber, String fields) {
        if (WfUtils.isEmpty(businessKey)) {
            return null;
        }
        try {
            DynamicObject obj;
            CommandContext commandContext = Context.getCommandContext();
            String cacheKey = String.format("findbizobj_%s.%s", entityNumber, businessKey);
            if (commandContext != null && fields == null && (obj = commandContext.getCachedDynamicObj().get(cacheKey)) != null) {
                return obj;
            }
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DynamicObject dynObj = null;
            int limit = WfConfigurationUtil.getMaxEntryCount(entityNumber);
            dynObj = entity.getPrimaryKey() instanceof LongProp ? (fields != null ? BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(businessKey), (String)entityNumber, (String)fields) : (limit == -1 ? BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(businessKey), (String)entityNumber) : BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(businessKey), (DynamicObjectType)entity, (int)-1, (int)limit))) : (fields != null ? BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber, (String)fields) : (limit == -1 ? BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber) : BusinessDataServiceHelper.loadSingle((Object)businessKey, (DynamicObjectType)entity, (int)-1, (int)limit)));
            if (commandContext != null && fields == null) {
                commandContext.getCachedDynamicObj().put(cacheKey, dynObj);
            }
            return dynObj;
        }
        catch (Exception e) {
            logger.info(String.format("\u5355\u636e[%s]\u53ef\u80fd\u5df2\u88ab\u5220\u9664,\u9519\u8bef\u539f\u56e0[%s]", businessKey, e.getMessage()));
            return null;
        }
    }

    public static boolean checkJobExecutorAlive(EvtJobEntity entity, List<ServiceInfo> services) {
        boolean alive = WfCommonUtil.isServiceNodeAlive(services, (String)entity.getExecutor());
        if (alive) {
            logger.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6267\u884c\u673a\u72b6\u6001\u6b63\u5e38\uff0c\u66f4\u65b0\u7f13\u5b58\u3002", entity.getId()));
            WfCacheHelper.putCurrentExecuteRootJobInc(entity.getRootJobId());
            return true;
        }
        logger.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u539f\u6267\u884c\u673a\u5df2\u5b95\u673a\uff0c\u5220\u9664\u7f13\u5b58\u3002", entity.getId()));
        WfCacheHelper.removeCurrentExecuteRootJob(entity.getRootJobId());
        return false;
    }
}

