/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.asyncexecutor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.asyncexecutor.EvtJobManager;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.devops.rule.cmd.CompleteRelieveSuspendSubCmd;
import kd.bos.bec.engine.eventauxiliary.EventAuxiliaryFactory;
import kd.bos.bec.engine.persistence.job.AbstractEvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtAbnormalInstanceEntity;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntity;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntityImpl;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.workflow.devopos.WFDevopsUtils;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.jobexecutor.EventDispatchJobsListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DefaultEvtJobManager
implements EvtJobManager {
    protected static Log logger = LogFactory.getLog(DefaultEvtJobManager.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultEvtJobManager() {
    }

    public DefaultEvtJobManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    protected AsyncExecutor getAsyncExecutor() {
        return this.processEngineConfiguration.getAsyncExecutor();
    }

    protected EvtJobEntity internalCreateLockedAsyncEventJob(boolean exclusive, String jobType) {
        EvtJobEntity asyncJob = (EvtJobEntity)this.processEngineConfiguration.getEvtJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, exclusive, jobType);
        JobUtil.setJobLockProperty(asyncJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return asyncJob;
    }

    protected void fillDefaultAsyncJobInfo(EvtJobEntity jobEntity, boolean exclusive, String jobType) {
        jobEntity.setJobType("event");
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExclusive(exclusive);
        jobEntity.setJobHandlerType(jobType);
    }

    private void fillPayload(EvtJobEntity jobEntity, Map<String, Object> payload) {
        if (payload == null) {
            payload = new HashMap<String, Object>();
        }
        RequestContext requestContext = RequestContext.get();
        Map<String, Object> context = WfUtils.dumpRequestContext(requestContext);
        context.put("srcLang", requestContext.getLang().toString());
        payload.put("_requestContext_", context);
        jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        jobEntity.setSource(JobHandleStrategyFactory.getWFSource());
        jobEntity.setState(JobStateEnum.CREATED.getNumber());
    }

    private void dealEventShower(Map<String, Object> params, EvtJobEntity job, String eventType) {
        String traceId = RequestContext.get().getTraceId();
        String eventBizkey = EventAuxiliaryFactory.getEventAuxiliary(eventType).getEventBizKey(params);
        job.setBizKey(eventBizkey);
        job.setSrcTraceId(traceId);
    }

    @Override
    public EvtJobEntity createEventDispatchJob(Map<String, Object> params, Map<String, Object> variable) {
        EvtJobEntity jobEntity = this.internalCreateLockedAsyncEventJob(false, "async-event-dispatch");
        HashMap<String, Object> payload = params == null ? new HashMap<String, Object>() : params;
        String eventNumber = (String)payload.get("eventNumber");
        if (WfUtils.isNotEmpty(eventNumber)) {
            Long id = null;
            if (payload.get("eventParamsId") != null) {
                id = Long.valueOf((String)payload.get("eventParamsId"));
            }
            if (WfUtils.isEmpty(id)) {
                Long eventId = null;
                Boolean passoperparam = null;
                String sourceStr = null;
                Map<String, String> eventParams = EvtCacheHelper.getCacheEventMap(eventNumber);
                if (eventParams != null && !eventParams.isEmpty() && eventParams.get("eventId") != null) {
                    eventId = Long.valueOf(eventParams.get("eventId"));
                    passoperparam = Boolean.valueOf(eventParams.get("passoperparam"));
                    sourceStr = eventParams.get("sourceStr");
                } else {
                    QFilter filter = new QFilter("number", "=", (Object)eventNumber);
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"evt_event", (String)"number,id,source,entity,passoperparam", (QFilter[])new QFilter[]{filter});
                    eventId = obj.getLong("id");
                    passoperparam = (Boolean)obj.get("passoperparam");
                    DynamicObject source = (DynamicObject)obj.get("source");
                    if (null != source) {
                        sourceStr = (String)source.get("number");
                    }
                    if (sourceStr == null) {
                        String appidRes;
                        String eventEntity = null;
                        DynamicObject eventObj = (DynamicObject)obj.get("entity");
                        if (eventObj != null) {
                            eventEntity = (String)eventObj.get("number");
                        }
                        if (WfUtils.isNotEmpty(eventEntity) && (appidRes = WfCacheHelper.getAppIdByEntityNumber(eventEntity)) != null) {
                            sourceStr = BizAppServiceHelp.getAppNumByAppId((String)appidRes);
                        }
                    }
                    if (eventParams == null) {
                        eventParams = new HashMap<String, String>(4);
                    }
                    eventParams.put("eventId", obj.getString("id"));
                    eventParams.put("passoperparam", obj.getString("passoperparam"));
                    eventParams.put("sourceStr", sourceStr);
                    EvtCacheHelper.addCacheEventMap(eventNumber, eventParams);
                }
                jobEntity.setProcessInstanceId(eventId);
                if (passoperparam != null && passoperparam.booleanValue() && variable != null) {
                    payload.put("becEventOperationParams", variable);
                }
                if (sourceStr != null) {
                    jobEntity.setAppNumForSubApp(sourceStr);
                    payload.put("appNumForSubApp", sourceStr);
                    logger.debug(String.format("operateAppId--[%s]", sourceStr));
                }
                this.dealEventShower(params, jobEntity, "entityEvent");
            } else {
                jobEntity.setProcessInstanceId(id);
                String sourceStr = (String)payload.get("appNumForSubApp");
                if (WfUtils.isNotEmpty(sourceStr)) {
                    jobEntity.setAppNumForSubApp(sourceStr);
                    logger.debug(String.format("customAppId--[%s]", sourceStr));
                }
                this.dealEventShower(params, jobEntity, "jsonEvent");
            }
        }
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public EvtJobEntity createCommonEvtJob(EventDispatchContext context, String type) {
        EvtJobEntity jobEntity = this.internalCreateLockedAsyncEventJob(false, type);
        this.fillPayload(jobEntity, null);
        RequestContext requestContext = RequestContext.get();
        Map<String, Object> requiredContext = WfUtils.dumpRequestContext(requestContext);
        if (context.getSrcLang() != null) {
            requiredContext.put("srcLang", context.getSrcLang());
        }
        context.set_requestContext_(requiredContext);
        jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString((Object)context));
        return jobEntity;
    }

    @Override
    public EvtTimerJobEntity moveEvtJobToTimerJob(AbstractEvtJobEntity job) {
        Long id;
        EvtTimerJobEntity timerJob = this.createTimerJobFromOtherJob(job);
        Long l = id = job instanceof EvtJobEntity ? ((EvtJobEntity)job).getRootJobId() : job.getId();
        if (QueryServiceHelper.exists((String)"evt_timerjob", (Object)id)) {
            return null;
        }
        timerJob.setRootTraceNo(job.getRootTraceNo());
        this.processEngineConfiguration.getEvtTimerJobEntityManager().insert(timerJob);
        return timerJob;
    }

    protected EvtTimerJobEntity createTimerJobFromOtherJob(AbstractEvtJobEntity otherJob) {
        EvtTimerJobEntity timerJob = (EvtTimerJobEntity)this.processEngineConfiguration.getEvtTimerJobEntityManager().create();
        this.copyJobInfo(timerJob, otherJob);
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            timerJob.setLockOwnerId(lockTag);
        }
        return timerJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvtDeadLetterJobEntity moveEvtJobToDeadLetterJob(AbstractEvtJobEntity job, Throwable exception) {
        EvtDeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(job, exception);
        Long id = job instanceof EvtJobEntity ? ((EvtJobEntity)job).getRootJobId() : job.getId();
        boolean ifneedRemoveLock = false;
        try {
            if (EvtCacheHelper.putLockInc("moveEvtJobToDeadLetterJob", String.valueOf(id), 60) <= 0) {
                logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\u6302\u8d77\uff0c\u4e0d\u518d\u7ee7\u7eed\u6302\u8d77", id));
                EvtDeadLetterJobEntity evtDeadLetterJobEntity = null;
                return evtDeadLetterJobEntity;
            }
            ifneedRemoveLock = true;
            ILocalJobHandleStrategy strategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(job.getJobType());
            boolean exist = strategy.exsitDeadLetterJob(id);
            if (exist) {
                EvtDeadLetterJobEntity evtDeadLetterJobEntity = null;
                return evtDeadLetterJobEntity;
            }
            this.processEngineConfiguration.getEvtDeadLetterJobEntityManager().insert(deadLetterJob);
            if (job instanceof EvtTimerJobEntity) {
                this.processEngineConfiguration.getEvtTimerJobEntityManager().delete((EvtTimerJobEntity)job);
            }
            EvtDeadLetterJobEntity evtDeadLetterJobEntity = deadLetterJob;
            return evtDeadLetterJobEntity;
        }
        finally {
            if (ifneedRemoveLock) {
                EvtCacheHelper.removeLockId("moveEvtJobToDeadLetterJob", String.valueOf(id));
            }
        }
    }

    protected EvtDeadLetterJobEntity createDeadLetterJobFromOtherJob(AbstractEvtJobEntity otherJob, Throwable exception) {
        EvtDeadLetterJobEntity deadLetterJob = (EvtDeadLetterJobEntity)this.processEngineConfiguration.getEvtDeadLetterJobEntityManager().create();
        this.copyJobInfo(deadLetterJob, otherJob);
        WFEngineException wfException = null;
        if (exception != null) {
            if (!(exception instanceof WFEngineException)) {
                wfException = new WFEngineException(exception.getMessage(), exception);
                deadLetterJob.setExceptionMessage(exception.getMessage());
            } else {
                wfException = (WFEngineException)((Object)exception);
                if (exception.getCause() != null) {
                    deadLetterJob.setExceptionMessage(exception.getCause().getMessage());
                }
            }
        } else {
            wfException = new WFEngineException(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38", (String)"DefaultJobManager_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            deadLetterJob.setExceptionMessage(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38", (String)"DefaultJobManager_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (wfException.getErrorCode() != null) {
            deadLetterJob.setErrorCode(wfException.getErrorCode().getCode());
        }
        deadLetterJob.setErrorType(wfException.getType());
        deadLetterJob.setSolution(wfException.getSolution());
        deadLetterJob.setExceptionStackMessage(WfUtils.getExceptionStacktrace(wfException.getCause()));
        return deadLetterJob;
    }

    @Override
    public EvtJobEntity moveEvtTimerJobToExecutableJob(EvtTimerJobEntity evtTimerJob, StringBuilder log) {
        if (evtTimerJob == null) {
            throw new WFEngineException("Empty timer job can not be scheduled");
        }
        if (!QueryServiceHelper.exists((String)"evt_timerjob", (Object)evtTimerJob.getId())) {
            return null;
        }
        if (DLock.getLockInfo((String)String.format("wf/jobexecute/%s", evtTimerJob.getId())) != null) {
            logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88abtimer\u626b\u63cf\u5230\u4e86\uff0c\u8d70\u5230\u8fd9\u91cc\u5f88\u5947\u602a\uff01", evtTimerJob.getId()));
            return null;
        }
        EvtJobEntity executableJob = this.createExecutableJobFromOtherJob(evtTimerJob);
        JSONObject jsonObject = JSON.parseObject((String)executableJob.getJobHandlerConfiguration());
        if (jsonObject != null) {
            String appNumForSubApp = jsonObject.getString("appNumForSubApp");
            logger.debug(String.format("moveEvtTimerJobToExecutableJobAppId--[%s]", appNumForSubApp));
            executableJob.setAppNumForSubApp(appNumForSubApp);
        }
        if (this.processEngineConfiguration.getEvtJobEntityManager().insertJobEntity(executableJob)) {
            this.processEngineConfiguration.getEvtTimerJobEntityManager().delete(evtTimerJob);
            ArrayList<EvtJobEntity> sendMqJobs = new ArrayList<EvtJobEntity>(1);
            sendMqJobs.add(executableJob);
            Context.getCommandContext().addCloseListener(new EventDispatchJobsListener(sendMqJobs));
            return executableJob;
        }
        return null;
    }

    @Override
    public EvtJobEntity moveEvtTimerJobToExecutableJobs(List<EvtTimerJobEntity> evtTimerJobs) {
        ArrayList<EvtJobEntity> sendMqJobs = new ArrayList<EvtJobEntity>(evtTimerJobs.size());
        for (EvtTimerJobEntity evtTimerJob : evtTimerJobs) {
            if (evtTimerJob == null) {
                logger.debug("Empty timer job can not be scheduled");
                continue;
            }
            if (!QueryServiceHelper.exists((String)"evt_timerjob", (Object)evtTimerJob.getId())) continue;
            if (DLock.getLockInfo((String)String.format("wf/jobexecute/%s", evtTimerJob.getId())) != null) {
                logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88abtimer\u626b\u63cf\u5230\u4e86\uff0c\u8d70\u5230\u8fd9\u91cc\u5f88\u5947\u602a\uff01", evtTimerJob.getId()));
                continue;
            }
            EvtJobEntity executableJob = this.createExecutableJobFromOtherJob(evtTimerJob);
            JSONObject jsonObject = JSON.parseObject((String)executableJob.getJobHandlerConfiguration());
            if (jsonObject != null) {
                String appNumForSubApp = jsonObject.getString("appNumForSubApp");
                logger.debug(String.format("moveEvtTimerJobToExecutableJobAppId--[%s]", appNumForSubApp));
                executableJob.setAppNumForSubApp(appNumForSubApp);
            }
            if (!this.processEngineConfiguration.getEvtJobEntityManager().insertJobEntity(executableJob)) continue;
            this.processEngineConfiguration.getEvtTimerJobEntityManager().delete(evtTimerJob);
            sendMqJobs.add(executableJob);
        }
        if (sendMqJobs.size() > 0) {
            if (WfConfigurationUtil.retryIfSlowQueue()) {
                Context.getCommandContext().addCloseListener(new EventDispatchJobsListener(sendMqJobs, "retry"));
                return null;
            }
            Context.getCommandContext().addCloseListener(new EventDispatchJobsListener(sendMqJobs));
        }
        return null;
    }

    private boolean ifSuspendDueToAppDisabled(String appNum) {
        if (WfUtils.isEmpty(appNum) || appNum.equalsIgnoreCase("wf") || appNum.equalsIgnoreCase("bec") || appNum.equalsIgnoreCase("wfs") || appNum.equalsIgnoreCase("wftask") || appNum.equalsIgnoreCase("bpm")) {
            return false;
        }
        try {
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNum);
            if (WfUtils.isEmpty(appId)) {
                return false;
            }
            Set disabledSet = ManageServiceHelper.getDisabledAppIds();
            if (disabledSet != null && disabledSet.contains(appId)) {
                logger.debug(String.format("%s-\u5e94\u7528\u88ab\u7981\u7528\uff0c\u6fc0\u6d3b\u65f6\u4e0d\u5904\u7406", appId));
                return true;
            }
        }
        catch (Throwable exp) {
            logger.warn(WfUtils.getExceptionStacktrace(exp));
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvtJobEntity moveDeadLetterJobToExecutableEvtJob(EvtDeadLetterJobEntity deadLetterJobEntity, int retries) {
        if (deadLetterJobEntity == null || WfUtils.isEmpty(deadLetterJobEntity.getId())) {
            throw new WFIllegalArgumentException("Null job provided");
        }
        boolean ifneedRemoveLock = false;
        try {
            boolean insertSuccesful;
            if (EvtCacheHelper.putLockInc("moveEvtDeadLetterJobToExecutableJob", deadLetterJobEntity.getId().toString(), 60) <= 0) {
                logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88ab\u91cd\u65b0\u6fc0\u6d3b\u5230\u4e86\uff0c\u8d70\u5230\u8fd9\u91cc\u5f88\u5947\u602a\uff01", deadLetterJobEntity.getId()));
                EvtJobEntity evtJobEntity = null;
                return evtJobEntity;
            }
            ifneedRemoveLock = true;
            if (!QueryServiceHelper.exists((String)"evt_deadletterjob", (Object)deadLetterJobEntity.getId())) {
                EvtJobEntity evtJobEntity = null;
                return evtJobEntity;
            }
            EvtJobEntity executableJob = this.createExecutableJobFromOtherJob(deadLetterJobEntity);
            executableJob.setRetries(retries);
            JSONObject jsonObject = JSON.parseObject((String)executableJob.getJobHandlerConfiguration());
            if (jsonObject != null) {
                String appNumForSubApp = jsonObject.getString("appNumForSubApp");
                logger.debug(String.format("moveDeadLetterJobToExecutableEvtJobAppId--[%s]", appNumForSubApp));
                executableJob.setAppNumForSubApp(appNumForSubApp);
                if (this.ifSuspendDueToAppDisabled(appNumForSubApp)) {
                    EvtJobEntity evtJobEntity = null;
                    return evtJobEntity;
                }
            }
            if (insertSuccesful = this.processEngineConfiguration.getEvtJobEntityManager().insertJobEntity(executableJob)) {
                this.processEngineConfiguration.getEvtDeadLetterJobEntityManager().delete(deadLetterJobEntity);
                ArrayList<EvtJobEntity> sendMqJobs = new ArrayList<EvtJobEntity>(1);
                sendMqJobs.add(executableJob);
                Context.getCommandContext().addCloseListener(new EventDispatchJobsListener(sendMqJobs));
                this.collectRecoverTimerJob(executableJob);
                EvtJobEntity evtJobEntity = executableJob;
                return evtJobEntity;
            }
        }
        finally {
            if (ifneedRemoveLock) {
                EvtCacheHelper.removeLockId("moveEvtDeadLetterJobToExecutableJob", deadLetterJobEntity.getId().toString());
            }
        }
        return null;
    }

    private void collectRecoverTimerJob(EvtJobEntity acquiredJob) {
        Date asyncMessageStartTime = WFDevopsUtils.getAsyncMessageStartTime();
        if (acquiredJob.getCreateDate().after(asyncMessageStartTime)) {
            WorkflowDevopsService.create().exceutionDataCollection(new IndicatorInfo("becAsyncMessage", (Object)"fail", -1));
        }
    }

    protected EvtJobEntity createExecutableJobFromOtherJob(AbstractEvtJobEntity job) {
        EvtJobEntity executableJob = null;
        String source = JobHandleStrategyFactory.getWFSource();
        executableJob = (EvtJobEntity)this.processEngineConfiguration.getEvtJobEntityManager().create();
        this.copyJobInfo(executableJob, job);
        executableJob.setSource(source);
        JobUtil.setJobLockProperty(executableJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return executableJob;
    }

    protected AbstractJobEntity copyJobInfo(AbstractEvtJobEntity copyToJob, AbstractEvtJobEntity copyFromJob) {
        copyToJob.setDuedate(copyFromJob.getDuedate());
        copyToJob.setExclusive(copyFromJob.isExclusive());
        copyToJob.setExecutionId(copyFromJob.getExecutionId());
        if (copyFromJob instanceof EvtJobEntity) {
            copyToJob.setId(((EvtJobEntity)copyFromJob).getRootJobId());
        } else if (copyToJob instanceof EvtJobEntity) {
            ((EvtJobEntity)copyToJob).setRootJobId(copyFromJob.getId());
            ((EvtJobEntity)copyToJob).setState(JobStateEnum.CREATED.getNumber());
        } else {
            copyToJob.setId(copyFromJob.getId());
        }
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setJobType(copyFromJob.getJobType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setProcessDefinitionId(copyFromJob.getProcessDefinitionId());
        copyToJob.setProcessInstanceId(copyFromJob.getProcessInstanceId());
        copyToJob.setRepeat(copyFromJob.getRepeat());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setBusinessKey(copyFromJob.getBusinessKey());
        copyToJob.setEntityNumber(copyFromJob.getEntityNumber());
        copyToJob.setOperation(copyFromJob.getOperation());
        copyToJob.setElementId(copyFromJob.getElementId());
        copyToJob.setExecutorServer(copyFromJob.getExecutorServer());
        copyToJob.setBizTraceNo(copyFromJob.getBizTraceNo());
        copyToJob.setRootEventInstId(copyFromJob.getRootEventInstId());
        copyToJob.setBizKey(copyFromJob.getBizKey());
        copyToJob.setSrcTraceId(copyFromJob.getSrcTraceId());
        copyToJob.setSrcJobId(copyFromJob.getSrcJobId());
        return copyToJob;
    }

    @Override
    public void eventSendMqdirct(List<EvtJobEntity> jobs) {
        for (EvtJobEntity job : jobs) {
            this.processEngineConfiguration.getEvtJobEntityManager().insert(job);
        }
        Context.getCommandContext().addCloseListener(new EventDispatchJobsListener(jobs));
    }

    @Override
    public int moveAbnormalInstanceToJob(List<Long> ids) {
        List<EvtAbnormalInstanceEntity> abnormalInstances = this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().findJobsByIds(ids);
        if (abnormalInstances == null || abnormalInstances.size() < 1) {
            return 0;
        }
        return this.moveAbnormalInstanceToJobs(abnormalInstances);
    }

    @Override
    public int moveAbnormalInstanceToJob(Long subscriptionId, int count) {
        List<EvtAbnormalInstanceEntity> abnormalInstances = this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().findJobsBySubscriptionIds(subscriptionId, count);
        if (abnormalInstances == null || abnormalInstances.size() < 1) {
            new CompleteRelieveSuspendSubCmd(subscriptionId).execute(Context.getCommandContext());
            return 0;
        }
        return this.moveAbnormalInstanceToJobs(abnormalInstances);
    }

    @Override
    public int moveEvtJobToAbnormalInstance(List<EvtJobEntity> jobs) {
        if (jobs == null || jobs.size() < 1) {
            return 0;
        }
        for (EvtJobEntity job : jobs) {
            this.moveEvtJobToAbnormalInstance(job);
        }
        return jobs.size();
    }

    @Override
    public int moveTimerJobToAbnormal(Long subscriptionId, int count) {
        List<EvtTimerJobEntity> timerJobs = this.processEngineConfiguration.getEvtTimerJobEntityManager().findJobsBySubscriptionIds(subscriptionId, count);
        if (timerJobs == null || timerJobs.size() < 1) {
            return 0;
        }
        for (EvtTimerJobEntity job : timerJobs) {
            this.moveTimerJobToAbnormal(job);
        }
        return timerJobs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveEvtJobToAbnormalInstance(EvtJobEntity job) {
        boolean ifneedRemoveLock = false;
        try {
            if (EvtCacheHelper.putLockInc("moveEvtJobToAbnormalInstance", String.valueOf(job.getId()), 60) <= 0) {
                logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88ab\u91cd\u65b0\u6fc0\u6d3b\u5230\u4e86\u3002", job.getId()));
                return;
            }
            ifneedRemoveLock = true;
            if (!QueryServiceHelper.exists((String)"evt_job", (Object)job.getId())) {
                return;
            }
            this.processEngineConfiguration.getEvtJobEntityManager().delete(job);
            EvtAbnormalInstanceEntity abnormalInstance = (EvtAbnormalInstanceEntity)this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().create();
            this.transforJob(abnormalInstance, job);
            this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().insert(abnormalInstance);
        }
        finally {
            if (ifneedRemoveLock) {
                EvtCacheHelper.removeLockId("moveEvtJobToAbnormalInstance", String.valueOf(job.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTimerJobToAbnormal(EvtTimerJobEntity job) {
        boolean ifneedRemoveLock = false;
        try {
            if (EvtCacheHelper.putLockInc("moveEvtJobToAbnormalInstance", String.valueOf(job.getId()), 60) <= 0) {
                logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88ab\u91cd\u65b0\u6fc0\u6d3b\u5230\u4e86\u3002", job.getId()));
                return;
            }
            ifneedRemoveLock = true;
            if (!QueryServiceHelper.exists((String)"evt_timerjob", (Object)job.getId())) {
                return;
            }
            this.processEngineConfiguration.getEvtTimerJobEntityManager().delete(job);
            EvtAbnormalInstanceEntity abnormalInstance = (EvtAbnormalInstanceEntity)this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().create();
            this.transforJob(abnormalInstance, job);
            abnormalInstance.setId(null);
            abnormalInstance.setState(JobStateEnum.CREATED.getNumber());
            abnormalInstance.setRootJobId(job.getId());
            this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().insert(abnormalInstance);
        }
        finally {
            if (ifneedRemoveLock) {
                EvtCacheHelper.removeLockId("moveEvtJobToAbnormalInstance", String.valueOf(job.getId()));
            }
        }
    }

    private int moveAbnormalInstanceToJobs(List<EvtAbnormalInstanceEntity> abnormalInstances) {
        ArrayList<EvtJobEntity> sendMqJobs = new ArrayList<EvtJobEntity>(abnormalInstances.size());
        for (EvtAbnormalInstanceEntity abnormalInstance : abnormalInstances) {
            EvtJobEntity job = this.moveAbnormalInstanceToJob(abnormalInstance);
            if (job == null) continue;
            sendMqJobs.add(job);
        }
        if (sendMqJobs.size() > 0) {
            Context.getCommandContext().addCloseListener(new EventDispatchJobsListener(sendMqJobs));
        }
        return sendMqJobs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvtJobEntity moveAbnormalInstanceToJob(EvtAbnormalInstanceEntity abnormalInstance) {
        boolean ifneedRemoveLock = false;
        try {
            if (EvtCacheHelper.putLockInc("moveAbnormalInstanceToJob", String.valueOf(abnormalInstance.getId()), 60) <= 0) {
                logger.info(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88ab\u91cd\u65b0\u6fc0\u6d3b\u5230\u4e86\u3002", abnormalInstance.getId()));
                EvtJobEntity evtJobEntity = null;
                return evtJobEntity;
            }
            ifneedRemoveLock = true;
            if (!QueryServiceHelper.exists((String)"evt_abnormalinstance", (Object)abnormalInstance.getId())) {
                EvtJobEntity evtJobEntity = null;
                return evtJobEntity;
            }
            EvtJobEntity job = (EvtJobEntity)this.processEngineConfiguration.getEvtJobEntityManager().create();
            this.transforJob(job, abnormalInstance);
            String source = JobHandleStrategyFactory.getWFSource();
            job.setSource(source);
            JobUtil.setJobLockProperty(job, this.processEngineConfiguration, this.getAsyncExecutor());
            JSONObject jsonObject = JSON.parseObject((String)job.getJobHandlerConfiguration());
            if (jsonObject != null) {
                String appNumForSubApp = jsonObject.getString("appNumForSubApp");
                logger.info(String.format("moveAbnormalInstanceToJob--[%s]", appNumForSubApp));
                job.setAppNumForSubApp(appNumForSubApp);
            }
            this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().delete(abnormalInstance);
            this.processEngineConfiguration.getEvtJobEntityManager().insert(job);
            EvtJobEntity evtJobEntity = job;
            return evtJobEntity;
        }
        finally {
            if (ifneedRemoveLock) {
                EvtCacheHelper.removeLockId("moveAbnormalInstanceToJob", String.valueOf(abnormalInstance.getId()));
            }
        }
    }

    @Override
    public void eventSuspend(List<EvtJobEntity> jobs) {
        for (EvtJobEntity job : jobs) {
            EvtAbnormalInstanceEntity entity = (EvtAbnormalInstanceEntity)this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().create();
            this.transforJob(entity, job);
            this.processEngineConfiguration.getEvtAbnormalInstanceEntityManager().insert(entity);
        }
    }

    protected AbstractEvtJobEntity transforJob(AbstractEvtJobEntity copyToJob, AbstractEvtJobEntity copyFromJob) {
        copyToJob.setId(copyFromJob.getId());
        copyToJob.setCreateDate(copyFromJob.getCreateDate());
        copyToJob.setExecutionId(copyFromJob.getExecutionId());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setModifyDate(copyFromJob.getModifyDate());
        copyToJob.setRootTraceNo(copyFromJob.getRootTraceNo());
        copyToJob.setDuedate(copyFromJob.getDuedate());
        copyToJob.setExclusive(copyFromJob.isExclusive());
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setJobType(copyFromJob.getJobType());
        copyToJob.setProcessDefinitionId(copyFromJob.getProcessDefinitionId());
        copyToJob.setProcessInstanceId(copyFromJob.getProcessInstanceId());
        copyToJob.setRepeat(copyFromJob.getRepeat());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setBusinessKey(copyFromJob.getBusinessKey());
        copyToJob.setEntityNumber(copyFromJob.getEntityNumber());
        copyToJob.setOperation(copyFromJob.getOperation());
        copyToJob.setElementId(copyFromJob.getElementId());
        copyToJob.setSrcJobId(copyFromJob.getSrcJobId());
        copyToJob.setRootEventInstId(copyFromJob.getRootEventInstId());
        copyToJob.setBizKey(copyFromJob.getBizKey());
        copyToJob.setSrcTraceId(copyFromJob.getSrcTraceId());
        if (copyFromJob instanceof EvtJobEntity && copyToJob instanceof EvtJobEntity) {
            ((EvtJobEntity)copyToJob).setDuration(((EvtJobEntity)copyFromJob).getDuration());
            ((EvtJobEntity)copyToJob).setSource(((EvtJobEntity)copyFromJob).getSource());
            ((EvtJobEntity)copyToJob).setState(((EvtJobEntity)copyFromJob).getState());
            ((EvtJobEntity)copyToJob).setEndTime(((EvtJobEntity)copyFromJob).getEndTime());
            ((EvtJobEntity)copyToJob).setRootJobId(((EvtJobEntity)copyFromJob).getRootJobId());
            ((EvtJobEntity)copyToJob).setLockExpirationTime(((EvtJobEntity)copyFromJob).getLockExpirationTime());
            ((EvtJobEntity)copyToJob).setLockOwnerId(((EvtJobEntity)copyFromJob).getLockOwnerId());
            ((EvtJobEntity)copyToJob).setSuccess(((EvtJobEntity)copyFromJob).isSuccess());
        }
        if (copyFromJob instanceof EvtTimerJobEntity && copyToJob instanceof EvtJobEntity) {
            ((EvtJobEntity)copyToJob).setLockExpirationTime(((EvtTimerJobEntity)copyFromJob).getLockExpirationTime());
            ((EvtJobEntity)copyToJob).setLockOwnerId(((EvtTimerJobEntity)copyFromJob).getLockOwnerId());
        }
        return copyToJob;
    }

    @Override
    public int moveDeadLetterJobToExecutableEvtJob(Long subscriptionId, int count) {
        QFilter[] filters = new QFilter[]{new QFilter("executionid", "=", (Object)subscriptionId), new QFilter("createDate", ">", (Object)new Date(this.processEngineConfiguration.getClock().getCurrentTime().getTime() - 31536000000L))};
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"evt_deadletterjob", (String)Context.getCommandContext().getEvtDeadLetterJobEntityManager().getSelectFields(), (QFilter[])filters, (String)"createdate desc", (int)count);
        if (dyns == null || dyns.size() < 1) {
            return -1;
        }
        int num = 0;
        int retries = Context.getCommandContext().getProcessEngineConfiguration().getAsyncExecutorNumberOfRetries();
        for (DynamicObject dyn : dyns) {
            if (this.moveDeadLetterJobToExecutableEvtJob(new EvtDeadLetterJobEntityImpl(dyn), retries) == null) continue;
            ++num;
        }
        return num;
    }
}

