/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.asyncexecutor;

import kd.bos.bec.engine.cmd.job.ExecuteAsyncEvtJobCmd;
import kd.bos.bec.engine.impl.jobexecutor.EvtJobUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.BizErrorInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFRequestTimeoutException;
import kd.bos.workflow.exception.WFVerifySqlSaveException;

public class ExecuteEvtAsyncRunnable
implements Runnable {
    private static Log log = LogFactory.getLog(ExecuteEvtAsyncRunnable.class);
    protected ExecuteJob job;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ExecuteEvtAsyncRunnable(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ExecuteEvtAsyncRunnable(ExecuteJob job, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.job = job;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public void run() {
        if (this.job == null) {
            log.error("ExecuteAsyncRunnable Job is null!");
            return;
        }
        try {
            this.processEngineConfiguration.getCommandExecutor().execute(new ExecuteAsyncEvtJobCmd(this.job));
        }
        catch (WFVerifySqlSaveException exception) {
            log.error(String.format("evtId--%s--VerifySqlError : %s on finished.", this.job.getId(), exception.getMessage()));
        }
        catch (Throwable exception2) {
            try {
                WFRequestTimeoutException exception2;
                BizErrorInfo bizErrorInfo = ExceptionUtil.getErrorCodeAndMsg(exception2);
                if (BosErrorCode.govRequestTimeout.getCode().equals(bizErrorInfo.getErrCode())) {
                    exception2 = new WFRequestTimeoutException(new Object[0]);
                }
                String message = "Job " + this.job.getId() + " failed to execute, error msg is [" + WfUtils.getExceptionStacktrace((Throwable)((Object)exception2)) + "],try to handle failed job.";
                log.debug(message);
                this.handleFailedJob((Throwable)((Object)exception2));
            }
            catch (WFVerifySqlSaveException WFVerifySqlSaveException2) {
                log.error(String.format("BEC handleFailedJob VerifySqlError jobId[%s] on errored: %s", this.job.getId(), WFVerifySqlSaveException2.getMessage()));
            }
            catch (Exception e) {
                String message = "Job " + this.job.getId() + " failed to retry, error msg is [" + WfUtils.getExceptionStacktrace(exception2) + "], will throw exceptions to jobprocess.";
                log.warn(message);
                throw new KDException((Throwable)e, WFErrorCode.jobExecutingError(), new Object[]{this.job.getId(), WfUtils.getExceptionStacktrace(e)});
            }
        }
    }

    protected void handleFailedJob(Throwable exception) {
        EvtJobUtil.handleFailedJob(this.processEngineConfiguration, this.job, exception);
    }
}

