/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.asyncexecutor.schedule;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.asyncexecutor.schedule.YearsInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class AbstractStatisticsTask
extends AbstractTask {
    private static final String CREATEDATE = "createdate";
    protected static final String ID = "id";
    private static final String COUNT = "count";
    private static final String TOTALTIME = "totaltime";
    private static final String STATE = "state";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String EVT_JOB = "evt_job";
    private static final String PROCESSDEFINITIONID = "processdefinitionid";
    private static final String EXECUTIONID = "executionid";
    private static final String JOBHISTORYCOUNT = "jobhistorycount";
    private static final String JOBCURRENTCOUNT = "jobcurrentcount";
    private static final String TOTALDURATION = "totalduration";
    protected static final String YEAR = "year";
    private static final String JOBSTATE = "jobstate";
    private static final String HANDLERTYPE = "handlertype";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String SERVICENUMBER = "servicenumber";
    private static final String SUBSCRIPTIONNUMBER = "subscriptionnumber";
    private static final String SUBSCRIPTION = "subscription";
    private static final String EVENTNUMBERVIEW = "eventnumberview";
    private static final String EVENTNUMBER = "eventnumber";
    protected static final String EVT_JOBSTATISTICS = "evt_jobstatistics";
    private static final String NUMBERVIEW = "numberview";
    private static final String SERVICE = "service";
    private static final String EVENT = "event";
    private static final String EVT_SUBSCRIPTION = "evt_subscription";
    private static final String NUMBER = "number";
    private static final String SUBSCRIPTION_ID = "subscriptionId";
    protected static final String BEC_SCHEDULE_REALTIMESTATISTICS_MOMENT = "bec.schedule.realtimestatisticsmoment";
    protected static final String BEC_SCHEDULE_STATISTICS_MOMENT = "bec.schedule.statisticsmoment";
    private static Log logger = LogFactory.getLog(AbstractStatisticsTask.class);

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
    }

    protected Date saveRealtimeStatisticsMoment() {
        Date date = null;
        try (DataSet ds = DB.queryDataSet((String)"getQuerySQLForLatestTime", (DBRoute)DBRoute.workflow, (String)this.getQuerySQLForLatestTime());){
            for (Row row : ds) {
                date = (Date)row.get("fcreatedate");
            }
        }
        catch (Exception e) {
            logger.info("statisticsData\u65b9\u6cd5\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        if (null != date) {
            this.saveConfcenter(BEC_SCHEDULE_REALTIMESTATISTICS_MOMENT, this.getRunningTimeDateFormat().format(date));
        }
        return date;
    }

    protected SimpleDateFormat getYearsDateFormat() {
        return new SimpleDateFormat("yyyyMMdd");
    }

    protected SimpleDateFormat getYearsDateFormatToMonth() {
        return new SimpleDateFormat("yyyyMM");
    }

    protected SimpleDateFormat getRunningTimeDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected void saveConfcenter(String key, String years) {
        DynamicObject config = this.getOrCreateConfigObject(key, years);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }

    protected DynamicObject getOrCreateConfigObject(String key, String value) {
        String fieldKey = "key";
        String fieldType = "type";
        String fieldValue = "value";
        QFilter[] filters = new QFilter[]{new QFilter(fieldKey, "=", (Object)key)};
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)String.format("id,%s,%s", fieldKey, fieldValue), (QFilter[])filters);
        if (config == null) {
            config = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_confcenter"));
            config.set(fieldKey, (Object)key);
            config.set(fieldType, (Object)"global");
        }
        config.set(fieldValue, (Object)value);
        return config;
    }

    protected String getQuerySQLForLatestTime() {
        StringBuilder sql = new StringBuilder();
        sql.append("select top 1 ");
        sql.append("fcreatedate ");
        sql.append("from t_evt_jobrecord ");
        sql.append("order by ");
        sql.append("fid desc ");
        return sql.toString();
    }

    protected List<List<Long>> buildBatchData(List<Long> args, Integer batchCount) {
        ArrayList<List<Long>> argsList = new ArrayList<List<Long>>();
        if (WfUtils.isNotEmptyForCollection(args)) {
            int totalCount;
            if (null == batchCount || batchCount <= 0) {
                batchCount = 500;
            }
            int j = (totalCount = args.size()) % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
            try {
                for (int x = 0; x < j; ++x) {
                    int end = (x + 1) * batchCount > totalCount ? totalCount : (x + 1) * batchCount;
                    List<Long> subList = args.subList(x * batchCount, end);
                    argsList.add(subList);
                }
            }
            catch (Exception e) {
                logger.info("\u6570\u636e\u5206\u6279\u5931\u8d25");
            }
        }
        return argsList;
    }

    protected List<DynamicObject> fillDataInfo(List<Map<String, Object>> initDatas, YearsInfo toBeHandled) {
        YearsInfo wholeMonthTime = this.getWholeMonthTime(toBeHandled);
        ArrayList<Long> subscriptionIds = new ArrayList<Long>();
        for (int i = 0; i < initDatas.size(); ++i) {
            Long subscriptionId = (Long)initDatas.get(i).get(SUBSCRIPTION_ID);
            if (subscriptionIds.contains(subscriptionId)) continue;
            subscriptionIds.add(subscriptionId);
        }
        List<List<Long>> batchSubscriptionIds = this.buildBatchData(subscriptionIds, 500);
        ArrayList<Long> notExistSubscription = new ArrayList<Long>();
        ArrayList<DynamicObject> dynObjs = new ArrayList<DynamicObject>();
        for (List<Long> list : batchSubscriptionIds) {
            QFilter[] filters0 = new QFilter[]{new QFilter(ID, "in", list)};
            DynamicObject[] subscriptionEntitys = BusinessDataServiceHelper.load((String)EVT_SUBSCRIPTION, (String)"id,number,service,event", (QFilter[])filters0);
            HashMap<Long, DynamicObject> subscriptionEntityMap = new HashMap<Long, DynamicObject>(16);
            for (int i = 0; i < subscriptionEntitys.length; ++i) {
                subscriptionEntityMap.put(subscriptionEntitys[i].getLong(ID), subscriptionEntitys[i]);
            }
            for (Long subscriptionId : subscriptionIds) {
                if (subscriptionEntityMap.get(subscriptionId) != null) continue;
                notExistSubscription.add(subscriptionId);
            }
            logger.info("\u4e8b\u4ef6\u65e5\u5fd7\u4e2d\u5b58\u5728\u8ba2\u9605\u8868\u4e2d\u4e0d\u5b58\u5728\u7684\u8ba2\u9605\uff0c\u8ba2\u9605ID\u5206\u522b\u4e3a+" + ((Object)notExistSubscription).toString());
            Map<Long, Map<String, Object>> notExistSubsMap = this.getNotExistSubscriptions(wholeMonthTime, notExistSubscription);
            DynamicObject event = null;
            String eventnumber = "";
            String eventnumberview = "";
            DynamicObject subscriptionEntity = null;
            DynamicObject service = null;
            String servicenumber = "";
            String entitynumber = "";
            for (int i = 0; i < initDatas.size(); ++i) {
                DynamicObject jobStatisticsEntity = BusinessDataServiceHelper.newDynamicObject((String)EVT_JOBSTATISTICS);
                Map<String, Object> initData = initDatas.get(i);
                Long subscriptionId = (Long)initData.get(SUBSCRIPTION_ID);
                subscriptionEntity = (DynamicObject)subscriptionEntityMap.get(subscriptionId);
                if (subscriptionEntity != null) {
                    String subscriptionnumber = (String)subscriptionEntity.get(NUMBER);
                    jobStatisticsEntity.set(SUBSCRIPTION, (Object)subscriptionEntity);
                    jobStatisticsEntity.set(SUBSCRIPTIONNUMBER, (Object)subscriptionnumber);
                    service = (DynamicObject)subscriptionEntity.get(SERVICE);
                    servicenumber = (String)service.get(NUMBER);
                    jobStatisticsEntity.set(SERVICE, (Object)service);
                    jobStatisticsEntity.set(SERVICENUMBER, (Object)servicenumber);
                    event = (DynamicObject)subscriptionEntity.get(EVENT);
                    eventnumberview = (String)event.get(NUMBERVIEW);
                    eventnumber = (String)event.get(NUMBER);
                    jobStatisticsEntity.set(EVENT, (Object)event);
                    jobStatisticsEntity.set(EVENTNUMBER, (Object)eventnumber);
                    jobStatisticsEntity.set(EVENTNUMBERVIEW, (Object)eventnumberview);
                    if (null != event && event.get("type").equals("cosmic")) {
                        DynamicObject entity = (DynamicObject)event.get("entity");
                        entitynumber = (String)entity.get(NUMBER);
                        jobStatisticsEntity.set(EVENTNUMBER, (Object)entitynumber);
                    }
                    if (null == initData.get(HANDLERTYPE)) {
                        String jobhandlertype = this.getHandlerType(servicenumber);
                        jobStatisticsEntity.set(HANDLERTYPE, (Object)jobhandlertype);
                    } else {
                        jobStatisticsEntity.set(HANDLERTYPE, initData.get(HANDLERTYPE));
                    }
                    jobStatisticsEntity.set(JOBSTATE, initData.get(STATE));
                    jobStatisticsEntity.set(YEAR, (Object)wholeMonthTime.getYears());
                    jobStatisticsEntity.set(TOTALDURATION, initData.get(TOTALTIME));
                    jobStatisticsEntity.set(JOBCURRENTCOUNT, initData.get(COUNT));
                    jobStatisticsEntity.set(JOBHISTORYCOUNT, initData.get(COUNT));
                    dynObjs.add(jobStatisticsEntity);
                    continue;
                }
                Map<String, Object> subscriptionInfoMap = notExistSubsMap.get(subscriptionId);
                jobStatisticsEntity.set(SERVICE, subscriptionInfoMap.get(PROCESSDEFINITIONID));
                jobStatisticsEntity.set(EVENT, subscriptionInfoMap.get(PROCESSINSTANCEID));
                jobStatisticsEntity.set(SUBSCRIPTION, (Object)subscriptionId);
                jobStatisticsEntity.set(ENTITYNUMBER, subscriptionInfoMap.get(ENTITYNUMBER));
                jobStatisticsEntity.set(HANDLERTYPE, initData.get(HANDLERTYPE));
                jobStatisticsEntity.set(JOBSTATE, subscriptionInfoMap.get(STATE));
                jobStatisticsEntity.set(YEAR, (Object)toBeHandled.getYears());
                jobStatisticsEntity.set(TOTALDURATION, initData.get(TOTALTIME));
                jobStatisticsEntity.set(JOBCURRENTCOUNT, initData.get(COUNT));
                jobStatisticsEntity.set(JOBHISTORYCOUNT, initData.get(COUNT));
                dynObjs.add(jobStatisticsEntity);
            }
        }
        return dynObjs;
    }

    private YearsInfo getWholeMonthTime(YearsInfo toBeHandled) {
        if (toBeHandled.getYears() != null && toBeHandled.getYears().matches("^\\d{6}$")) {
            YearsInfo info = new YearsInfo();
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = this.getYearsDateFormatToMonth().parse(toBeHandled.getYears());
                calendar.setTime(date);
                info.setBegin(calendar.getTime());
                calendar.add(2, 1);
                info.setEnd(calendar.getTime());
                info.setYears(this.getYearsDateFormatToMonth().format(info.getBegin()));
                return info;
            }
            catch (ParseException e) {
                logger.info("getNextToBeHandledYears\u65b9\u6cd5\u8ba1\u7b97\u4e0b\u6b21\u8981\u5904\u7406\u7684\u65f6\u95f4\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        return toBeHandled;
    }

    private Map<Long, Map<String, Object>> getNotExistSubscriptions(YearsInfo toBeHandled, List<Long> notExistSubscription) {
        HashMap initDataMap = Maps.newHashMap();
        if (!notExistSubscription.isEmpty()) {
            QFilter filter0 = new QFilter(CREATEDATE, ">=", (Object)toBeHandled.getBegin());
            QFilter filter1 = new QFilter(CREATEDATE, "<=", (Object)toBeHandled.getEnd());
            QFilter filter2 = new QFilter(EXECUTIONID, "in", notExistSubscription);
            QFilter[] jobRecordFilters = new QFilter[]{filter0, filter1, filter2};
            HashMap subscriptionMap = Maps.newHashMap();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bec_statisticsData", (String)EVT_JOB, (String)"id,executionid,processdefinitionid,processinstanceid,entitynumber,state", (QFilter[])jobRecordFilters, (String)"id asc");){
                for (Row row : dataSet) {
                    if (subscriptionMap.get(row.getLong(EXECUTIONID)) != null) continue;
                    HashMap jobrecordInfoMap = Maps.newHashMap();
                    subscriptionMap.put(row.getLong(EXECUTIONID), row.getLong(ID));
                    jobrecordInfoMap.put(ENTITYNUMBER, row.getString(ENTITYNUMBER));
                    jobrecordInfoMap.put(EXECUTIONID, row.getString(EXECUTIONID));
                    jobrecordInfoMap.put(ID, row.getString(ID));
                    jobrecordInfoMap.put(PROCESSDEFINITIONID, row.getString(PROCESSDEFINITIONID));
                    jobrecordInfoMap.put(PROCESSINSTANCEID, row.getString(PROCESSINSTANCEID));
                    jobrecordInfoMap.put(STATE, row.getString(STATE));
                    initDataMap.put(row.getLong(EXECUTIONID), jobrecordInfoMap);
                }
            }
        }
        return initDataMap;
    }

    protected String getHandlerType(String servicenumber) {
        String jobhandlertype;
        switch (servicenumber) {
            case "sendMsg": {
                jobhandlertype = "event-send-message";
                break;
            }
            case "microService": {
                jobhandlertype = "event-execute-microservice";
                break;
            }
            case "triggerHttpService": {
                jobhandlertype = "trigger-http-api";
                break;
            }
            case "executeOperation": {
                jobhandlertype = "event-execute-operation";
                break;
            }
            case "executePlugin": {
                jobhandlertype = "event-execute-plugin";
                break;
            }
            case "tryCloseBizFlow": {
                jobhandlertype = "tryCloseBizFlow";
                break;
            }
            case "startProcessService": {
                jobhandlertype = "event-start-process";
                break;
            }
            default: {
                jobhandlertype = servicenumber;
            }
        }
        return jobhandlertype;
    }

    protected void saveStatisticsObject(List<DynamicObject> fillDataInfo) {
        ArrayList<DynamicObject> dataInfoToSave = new ArrayList<DynamicObject>(fillDataInfo.size());
        for (int i = 0; i < fillDataInfo.size(); ++i) {
            dataInfoToSave.add(fillDataInfo.get(i));
            if (i == 0 || i % 100 != 0) continue;
            SaveServiceHelper.save((DynamicObject[])dataInfoToSave.toArray(new DynamicObject[0]));
            dataInfoToSave.clear();
        }
        SaveServiceHelper.save((DynamicObject[])dataInfoToSave.toArray(new DynamicObject[0]));
    }

    protected void saveRealTime(String time) {
        DynamicObject config = this.getOrCreateConfigObject(BEC_SCHEDULE_REALTIMESTATISTICS_MOMENT, time);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }
}

