/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.asyncexecutor.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.asyncexecutor.EvtJobManager;
import kd.bos.bec.engine.asyncexecutor.schedule.AbstractStatisticsTask;
import kd.bos.bec.engine.cmd.job.AcquireEvtTimerJobsCmd;
import kd.bos.bec.engine.cmd.job.EvtDevopsTaskCmd;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntity;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.WFDevopsUtils;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.ProcessEngineConfiguration;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;

public class AcquireEvtTimerJobsTask
extends AbstractStatisticsTask {
    private static Log logger = LogFactory.getLog(AcquireEvtTimerJobsTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        logger.info("{} starting to evtacquireTimer async jobs due");
        if (!ProcessEngines.isInitialized()) {
            return;
        }
        try {
            AsyncExecutor asyncExecutor = this.getAsyncExecutor();
            CommandExecutor commandExecutor = asyncExecutor.getProcessEngineConfiguration().getCommandExecutor();
            ArrayList<EvtTimerJobEntity> acquiredEvtJobs = new ArrayList<EvtTimerJobEntity>();
            acquiredEvtJobs.addAll((Collection)commandExecutor.execute(new AcquireEvtTimerJobsCmd(asyncExecutor)));
            if (!acquiredEvtJobs.isEmpty()) {
                this.moveToJobAndSendToMq(commandExecutor, acquiredEvtJobs);
            }
            commandExecutor.execute(new EvtDevopsTaskCmd(param));
        }
        finally {
            logger.info("{} stopped async job due acquisition");
        }
    }

    private void moveToJobAndSendToMq(CommandExecutor commandExecutor, final List<EvtTimerJobEntity> acquiredJobs) {
        try (DLock lock = DLock.create((String)"wf/movetimerJobsToExecute", (String)"move timerJobs to executableJob").fastMode();){
            boolean canLock = lock.tryLock(60000L);
            if (canLock) {
                commandExecutor.execute(new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        EvtJobManager jobManager = AcquireEvtTimerJobsTask.this.getEvtJobManager();
                        if (acquiredJobs != null && acquiredJobs.size() > 0) {
                            jobManager.moveEvtTimerJobToExecutableJobs(acquiredJobs);
                            AcquireEvtTimerJobsTask.this.collectRecoverTimerJob(acquiredJobs);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private void collectRecoverTimerJob(List<EvtTimerJobEntity> acquiredJobs) {
        Date asyncMessageStartTime = WFDevopsUtils.getAsyncMessageStartTime();
        long count = acquiredJobs.stream().filter(job -> job.getCreateDate().after(asyncMessageStartTime)).count();
        WorkflowDevopsService.create().exceutionDataCollection(new IndicatorInfo("becAsyncMessage", (Object)"timing", (int)(-count)));
    }

    public AsyncExecutor getAsyncExecutor() {
        ProcessEngineConfiguration configuration = ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        return configuration.getAsyncExecutor();
    }

    public EvtJobManager getEvtJobManager() {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        return configuration.getEvtJobManager();
    }
}

