/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.asyncexecutor.schedule;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.asyncexecutor.schedule.AbstractStatisticsTask;
import kd.bos.bec.engine.asyncexecutor.schedule.YearsInfo;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

@Deprecated
public class EventCenterStatisticsTask
extends AbstractStatisticsTask {
    private static final String JOBRECORDCOUNT = "jobrecordcount";
    private static final String COUNT = "count";
    private static final String TOTALTIME = "totaltime";
    private static final String STATE = "state";
    private static final String TOTALDURATION = "totalduration";
    private static final String HANDLERTYPE = "handlertype";
    private static final String SUBSCRIPTION_ID = "subscriptionId";
    private static final String FSTATE = "fstate";
    private static final String FEXECUTIONID = "fexecutionid";
    private static final String BEC_SCHEDULE_STATISTICSDAYS = "bec.schedule.statisticsdays";
    private static Log logger = LogFactory.getLog(EventCenterStatisticsTask.class);

    @Override
    public void execute(RequestContext context, Map<String, Object> param) {
    }

    private Date getOldestTime() {
        Date date = null;
        try (DataSet ds = DB.queryDataSet((String)"getQuerySQLForOldestTime", (DBRoute)DBRoute.workflow, (String)this.getQuerySQLForOldestTime());){
            for (Row row : ds) {
                date = (Date)row.get("fcreatedate");
            }
        }
        catch (Exception e) {
            logger.warn("statisticsData\u65b9\u6cd5\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return date;
    }

    private String getQuerySQLForOldestTime() {
        StringBuilder sql = new StringBuilder();
        sql.append("select top 1 ");
        sql.append("fcreatedate ");
        sql.append("from t_evt_jobrecord ");
        sql.append("order by ");
        sql.append("fid asc ");
        return sql.toString();
    }

    private String initHandlerDate() {
        long time = WfUtils.now().getTime();
        String format = this.getYearsDateFormatToMonth().format(time);
        this.saveConfcenter("bec.schedule.statisticsmoment", format);
        String beginSearchTime = (String)WfConfigurationUtil.getConfigCenterVal("bec.schedule.realtimestatisticsmoment");
        if (beginSearchTime == null) {
            this.saveRealtimeStatisticsMoment();
        }
        return format;
    }

    private Map<String, Map<String, Object>> statisticsData(Map<String, Map<String, Object>> initDataMap, YearsInfo theMonth) {
        ArrayList<String> type = new ArrayList<String>();
        type.add("event-execute-plugin");
        type.add("event-send-message");
        type.add("event-execute-operation");
        type.add("trigger-http-api");
        for (int i = 0; i < type.size(); ++i) {
            Object[] params = new Object[]{theMonth.getBegin(), theMonth.getEnd(), type.get(i)};
            try (DataSet ds = DB.queryDataSet((String)"statisticsData", (DBRoute)DBRoute.workflow, (String)this.getQuerySQL(), (Object[])params);){
                for (Row row : ds) {
                    HashMap dataMap = Maps.newHashMap();
                    long count = row.getLong(JOBRECORDCOUNT);
                    String state = row.getString(FSTATE);
                    long totaltime = row.getLong(TOTALDURATION);
                    long subscriptionId = row.getLong(FEXECUTIONID);
                    String subscrStateKey = subscriptionId + "_" + state;
                    Map<String, Object> map = initDataMap.get(subscrStateKey);
                    if (map != null) {
                        count = (Long)map.get(COUNT) + count;
                        map.put(COUNT, count);
                        continue;
                    }
                    dataMap.put(COUNT, count);
                    dataMap.put(STATE, state);
                    dataMap.put(TOTALTIME, totaltime);
                    dataMap.put(SUBSCRIPTION_ID, subscriptionId);
                    dataMap.put(HANDLERTYPE, type.get(i));
                    initDataMap.put(subscrStateKey, dataMap);
                }
                continue;
            }
            catch (Exception e) {
                logger.warn("statisticsData\u65b9\u6cd5\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        return initDataMap;
    }

    private List<YearsInfo> getToBeHandledYearsInfoList(String handledYears, int handledDays) {
        String beginSearchTime = (String)WfConfigurationUtil.getConfigCenterVal("bec.schedule.realtimestatisticsmoment");
        Date realTimeStatisticsMoment = null;
        try {
            realTimeStatisticsMoment = this.getRunningTimeDateFormat().parse(beginSearchTime);
        }
        catch (Exception e) {
            logger.warn("getToBeHandledYearsInfoList\u65b9\u6cd5\u8f6c\u6362\u6570\u636e\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        ArrayList<YearsInfo> yearsInfoList = new ArrayList<YearsInfo>();
        if (handledYears != null && handledYears.matches("^\\d{6}$")) {
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = this.getYearsDateFormatToMonth().parse(handledYears);
                calendar.setTime(date);
                YearsInfo info = null;
                boolean isRealTimeStatisticsMoment = false;
                do {
                    info = new YearsInfo();
                    info.setBegin(calendar.getTime());
                    calendar.add(6, handledDays);
                    if (null != realTimeStatisticsMoment && calendar.getTime().compareTo(realTimeStatisticsMoment) > 0) {
                        info.setEnd(realTimeStatisticsMoment);
                        isRealTimeStatisticsMoment = true;
                    } else {
                        info.setEnd(calendar.getTime());
                    }
                    info.setYears(this.getYearsDateFormatToMonth().format(info.getBegin()));
                    yearsInfoList.add(info);
                } while (this.getYearsDateFormatToMonth().format(info.getEnd()).equals(handledYears) && !isRealTimeStatisticsMoment);
                if (isRealTimeStatisticsMoment) {
                    return yearsInfoList;
                }
                calendar.setTime(date);
                calendar.add(2, 1);
                YearsInfo yearsInfo = (YearsInfo)yearsInfoList.get(yearsInfoList.size() - 1);
                yearsInfo.setEnd(calendar.getTime());
                return yearsInfoList;
            }
            catch (ParseException e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return yearsInfoList;
    }

    private YearsInfo getNextToBeHandledYears(String handledYears) {
        if (handledYears != null && handledYears.matches("^\\d{6}$")) {
            YearsInfo info = new YearsInfo();
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = this.getYearsDateFormatToMonth().parse(handledYears);
                calendar.setTime(date);
                calendar.add(2, -1);
                info.setBegin(calendar.getTime());
                info.setYears(this.getYearsDateFormatToMonth().format(info.getBegin()));
                return info;
            }
            catch (ParseException e) {
                logger.warn("getNextToBeHandledYears\u65b9\u6cd5\u8ba1\u7b97\u4e0b\u6b21\u8981\u5904\u7406\u7684\u65f6\u95f4\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    protected String getQuerySQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append("fexecutionid ,count(1) jobrecordcount ,fstate ,sum(fduration) totalduration ");
        sql.append("from t_evt_jobrecord ");
        sql.append("where ");
        sql.append("fcreatedate  >=  ?  and  fcreatedate < ?   ");
        sql.append("and fhandlertype =  ?  ");
        sql.append("group by fexecutionid,fstate ");
        return sql.toString();
    }

    protected YearsInfo getToBeHandledYearsInfo(String handledYears, int handledDays) {
        if (handledYears != null && handledYears.matches("^\\d{8}$")) {
            YearsInfo info = new YearsInfo();
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = this.getYearsDateFormat().parse(handledYears);
                calendar.setTime(date);
                calendar.add(6, 1);
                info.setEnd(calendar.getTime());
                calendar.add(6, -handledDays);
                info.setBegin(calendar.getTime());
                info.setYears(this.getYearsDateFormat().format(info.getBegin()));
                return info;
            }
            catch (ParseException e) {
                logger.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return null;
    }
}

