/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.cache;

import com.alibaba.fastjson.JSONArray;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class EvtCacheHelper {
    public static final String WORKFLOWDISTRICT = "workflow";
    private static DistributeSessionlessCache disCache = null;
    public static final String KEY_TRACE = "_trace";
    private static Log logger = LogFactory.getLog(EvtCacheHelper.class);
    private static final int ThreeDays = 259200;
    private static final int HalfOneHour = 1800;
    private static final String BECTRIGGERSUBSCRIPTIONS = "Bec_Trigger_Subscriptions";
    private static final String BECTRIGGEREVENT = "Bec_Trigger_Event";
    private static final String RULEOVERTIMES = "Rule_Overtimes";
    private static final String NORETRYSUBS = "Rule_NoRetry_Subs";
    private static final String SUSPENDSUBS = "Rule_Suspend_Subs";
    private static final String EVTWHITELIST = "EvtWhiteList";
    private static final String EVTWHITEIDLIST = "EvtWhiteIdList";
    private static final String EVTQUEUETYPE = "EvtQueueType";

    private static DistributeSessionlessCache getDisCache() {
        if (disCache == null) {
            disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(WORKFLOWDISTRICT, new DistributeCacheHAPolicy());
        }
        return disCache;
    }

    public static String getAccountId() {
        return CacheKeyUtil.getAcctId();
    }

    public static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(EvtCacheHelper.getAccountId()).append(".bec.");
        return WfUtils.strAppend(sb.toString(), ".", args);
    }

    @Deprecated
    public static String[] getSourceEvtsByTrace(String traceId) {
        return new String[0];
    }

    @Deprecated
    public static void removeSourceEvtsByTrace(String traceId) {
    }

    @Deprecated
    public static void setSourceEvtsByTrace(String traceId, String[] sourceEvts) {
    }

    @Deprecated
    public static String[] getSourceEvtsByJob(Long jobId) {
        return new String[0];
    }

    @Deprecated
    public static void removeSourceEvtsByJob(Long jobId) {
    }

    @Deprecated
    public static void setSourceEvtsByJob(Long jobId, String[] sourceEvts) {
    }

    public static String getCacheEventKey(String entityNumber) {
        return EvtCacheHelper.getWholeKey("cacheEvent", entityNumber);
    }

    public static void removeCacheEvents(String[] keys) {
        if (keys != null && keys.length > 0) {
            EvtCacheHelper.getDisCache().remove(keys);
        }
    }

    public static void removeCacheEvent(String entityNumber) {
        logger.debug(String.format("removeCacheEvent %s", entityNumber));
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getCacheEventKey(entityNumber));
    }

    public static String[] getCacheEvent(String entityNumber) {
        return EvtCacheHelper.getDisCache().getSetValues(EvtCacheHelper.getCacheEventKey(entityNumber));
    }

    public static void addCacheSubscriptionMap(String eventNumber, Map<String, String> params) {
        EvtCacheHelper.getDisCache().put(EvtCacheHelper.getWholeKey("cacheEvent", BECTRIGGERSUBSCRIPTIONS, eventNumber), params, 1800);
    }

    public static Map<String, String> getCacheSubscriptionMap(String eventNumber) {
        return EvtCacheHelper.getDisCache().getAll(EvtCacheHelper.getWholeKey("cacheEvent", BECTRIGGERSUBSCRIPTIONS, eventNumber));
    }

    public static void removeCacheSubscriptionMap(List<String> eventNumber) {
        if (eventNumber == null) {
            return;
        }
        int size = eventNumber.size();
        if (size < 1) {
            return;
        }
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = EvtCacheHelper.getWholeKey("cacheEvent", BECTRIGGERSUBSCRIPTIONS, eventNumber.get(i));
        }
        if (keys.length > 0) {
            EvtCacheHelper.getDisCache().remove(keys);
        }
    }

    public static void addCacheEventMap(String eventNumber, Map<String, String> params) {
        EvtCacheHelper.getDisCache().put(EvtCacheHelper.getWholeKey("cacheEvent", BECTRIGGEREVENT, eventNumber), params, 1800);
    }

    public static Map<String, String> getCacheEventMap(String eventNumber) {
        return EvtCacheHelper.getDisCache().getAll(EvtCacheHelper.getWholeKey("cacheEvent", BECTRIGGEREVENT, eventNumber));
    }

    public static void removeCacheEventMap(List<String> eventNumber) {
        if (eventNumber == null) {
            return;
        }
        int size = eventNumber.size();
        if (size < 1) {
            return;
        }
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = EvtCacheHelper.getWholeKey("cacheEvent", BECTRIGGEREVENT, eventNumber.get(i));
        }
        if (keys.length > 0) {
            EvtCacheHelper.getDisCache().remove(keys);
        }
    }

    public static void addCacheEvent(String entityNumber, String[] eventNumbers) {
        StringBuilder sb = new StringBuilder();
        for (String en : eventNumbers) {
            sb.append(en).append(',');
        }
        logger.info(String.format("addCacheEvent %s , %s", entityNumber, sb));
        EvtCacheHelper.getDisCache().addToSet(EvtCacheHelper.getCacheEventKey(entityNumber), eventNumbers, 259200);
    }

    public static void incSentEventMqDirectlyDayAmount(int amount) {
        if (null != WfConfigurationUtil.getSendEvtMqThreshold()) {
            EvtCacheHelper.getDisCache().incrBy(EvtCacheHelper.getWholeKey("sentEventMqDirectlyDayAmount", new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime())), amount);
        }
    }

    public static void incSentEventMqDirectlyDayConsumeAmount() {
        if (null != WfConfigurationUtil.getSendEvtMqThreshold()) {
            EvtCacheHelper.getDisCache().inc(EvtCacheHelper.getWholeKey("sentEventMqDirectlyDayConsumeAmount", new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime())));
        }
    }

    public static boolean ifCanSendEventMqDirectly() {
        try {
            String sendEvtMqThreshold = WfConfigurationUtil.getSendEvtMqThreshold();
            if (sendEvtMqThreshold == null) {
                return true;
            }
            String sentEventMqDirectlyDayAmount = (String)EvtCacheHelper.getDisCache().get(EvtCacheHelper.getWholeKey("sentEventMqDirectlyDayAmount", new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime())));
            if (sentEventMqDirectlyDayAmount == null) {
                return true;
            }
            String sentEventMqDirectlyDayConsumeAmount = (String)EvtCacheHelper.getDisCache().get(EvtCacheHelper.getWholeKey("sentEventMqDirectlyDayConsumeAmount", new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime())));
            if (sentEventMqDirectlyDayConsumeAmount == null) {
                return true;
            }
            return Long.parseLong(sentEventMqDirectlyDayAmount) - Long.parseLong(sentEventMqDirectlyDayConsumeAmount) < Long.parseLong(sendEvtMqThreshold);
        }
        catch (Exception e) {
            logger.error(String.format("\u6821\u9a8c\u9608\u503c\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f: %s", WfUtils.getExceptionStacktrace(e)));
            return true;
        }
    }

    public static void removeSentEventMqDirectlyDayAmount() {
        if (null != WfConfigurationUtil.getSendEvtMqThreshold()) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            String date = new SimpleDateFormat("yyyyMMdd").format(calendar.getTime());
            String key1 = EvtCacheHelper.getWholeKey("sentEventMqDirectlyDayAmount", date);
            String key2 = EvtCacheHelper.getWholeKey("sentEventMqDirectlyDayConsumeAmount", date);
            String[] keys = new String[]{key1, key2};
            EvtCacheHelper.getDisCache().remove(keys);
            logger.debug(String.format("removeSentEventMqDirectlyDayAmount %1$s, %2$s", key1, key2));
        }
    }

    public static void putSharingIdOfDbRouteKey(String dbRouteKey, String sharingId) {
        EvtCacheHelper.getDisCache().put(EvtCacheHelper.getWholeKey(String.format("becSharingId-%s", dbRouteKey)), (Object)sharingId, 86400);
    }

    public static String getSharingIdOfDbRouteKey(String dbRouteKey) {
        return (String)EvtCacheHelper.getDisCache().get(EvtCacheHelper.getWholeKey(String.format("becSharingId-%s", dbRouteKey)));
    }

    public static int putLockInc(String lockName, String lockId, int timeOutSeconds) {
        return EvtCacheHelper.getDisCache().addToSet(EvtCacheHelper.getWholeKey(lockName, lockId), new String[]{lockId}, timeOutSeconds);
    }

    public static void removeLockId(String lockName, String lockId) {
        EvtCacheHelper.getDisCache().removeSetValues(EvtCacheHelper.getWholeKey(lockName, lockId), new String[]{lockId});
    }

    public static boolean existLockId(String lockName, String lockId) {
        String key = EvtCacheHelper.getWholeKey(EvtCacheHelper.getWholeKey(lockName, lockId));
        String[] keys = EvtCacheHelper.getDisCache().getSetValues(key);
        return WfUtils.inArray(keys, key);
    }

    public static String[] getAcquireEvtJobIds(String sharingId) {
        return EvtCacheHelper.getDisCache().getSetValues(EvtCacheHelper.getWholeKey("evtCacheSharingId", sharingId));
    }

    public static void putAcquireEvtJobId(String sharingId, String[] jobids) {
        EvtCacheHelper.getDisCache().addToSet(EvtCacheHelper.getWholeKey("evtCacheSharingId", sharingId), jobids, 1800);
    }

    public static void removeAcquireEvtJobId(String sharingId) {
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getWholeKey("evtCacheSharingId", sharingId));
    }

    public static void putRuleOvertimes(List<Long> ruleOvertimes) {
        if (WfUtils.isEmptyForCollection(ruleOvertimes)) {
            return;
        }
        EvtCacheHelper.getDisCache().put(EvtCacheHelper.getWholeKey(RULEOVERTIMES), (Object)JSONArray.toJSONString(ruleOvertimes), 18000);
    }

    public static List<Long> getRuleOvertimes() {
        String ruleOvertimesStr = (String)EvtCacheHelper.getDisCache().get(EvtCacheHelper.getWholeKey(RULEOVERTIMES));
        if (WfUtils.isNotEmpty(ruleOvertimesStr)) {
            return JSONArray.parseArray((String)ruleOvertimesStr, Long.class);
        }
        return new ArrayList<Long>(0);
    }

    public static void removeRuleOvertimes() {
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getWholeKey(RULEOVERTIMES));
    }

    public static void addNoRetrySubs(String[] evtSubscriptions) {
        if (evtSubscriptions == null || evtSubscriptions.length == 0) {
            return;
        }
        EvtCacheHelper.getDisCache().addToSet(EvtCacheHelper.getWholeKey(NORETRYSUBS), evtSubscriptions, 129600);
    }

    public static void addSuspendSubs(String[] evtSubscriptions) {
        if (evtSubscriptions == null || evtSubscriptions.length == 0) {
            return;
        }
        EvtCacheHelper.getDisCache().addToSet(EvtCacheHelper.getWholeKey(SUSPENDSUBS), evtSubscriptions, 129600);
    }

    public static void removeNoRetrySubs() {
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getWholeKey(NORETRYSUBS));
    }

    public static void removeSuspendSubs() {
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getWholeKey(SUSPENDSUBS));
    }

    public static String[] getNoRetrySubs() {
        return EvtCacheHelper.getDisCache().getSetValues(EvtCacheHelper.getWholeKey(NORETRYSUBS));
    }

    public static String[] getSuspendSubs() {
        return EvtCacheHelper.getDisCache().getSetValues(EvtCacheHelper.getWholeKey(SUSPENDSUBS));
    }

    public static void removeWhiteList() {
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getWholeKey(EVTWHITELIST));
    }

    public static void addWhiteList(Set<String> whiteListSet) {
        EvtCacheHelper.getDisCache().addToSet(EvtCacheHelper.getWholeKey(EVTWHITELIST), whiteListSet.toArray(new String[whiteListSet.size()]), 259200);
    }

    public static String[] getWhiteList() {
        return EvtCacheHelper.getDisCache().getSetValues(EvtCacheHelper.getWholeKey(EVTWHITELIST));
    }

    public static void removeWhiteListMap(List<String> ids) {
        if (ids == null) {
            return;
        }
        int size = ids.size();
        if (size < 1) {
            return;
        }
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = EvtCacheHelper.getWholeKey(EVTWHITEIDLIST, ids.get(i));
        }
        if (keys.length > 0) {
            EvtCacheHelper.getDisCache().remove(keys);
        }
    }

    public static void addWhiteListMap(String id, Map<String, String> params) {
        EvtCacheHelper.getDisCache().put(EvtCacheHelper.getWholeKey(EVTWHITEIDLIST, id), params, 259200);
    }

    public static Map<String, String> getWhiteListMap(String id) {
        return EvtCacheHelper.getDisCache().getAll(EvtCacheHelper.getWholeKey(EVTWHITEIDLIST, id));
    }

    public static Map<String, String> getEvtQueue() {
        return EvtCacheHelper.getDisCache().getAll(EvtCacheHelper.getWholeKey(EVTQUEUETYPE));
    }

    public static void putEvtQueue(Map<String, String> params) {
        EvtCacheHelper.getDisCache().put(EvtCacheHelper.getWholeKey(EVTQUEUETYPE), params, 259200);
    }

    public static void removeEvtQueue() {
        EvtCacheHelper.getDisCache().remove(EvtCacheHelper.getWholeKey(EVTQUEUETYPE));
    }
}

