/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.cmd.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.job.AcquireJobsCmd;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.runtime.ExecuteJob;

public class AcquireEvtJobsCmd
implements Command<List<EvtJobEntity>> {
    protected static Log logger = LogFactory.getLog(AcquireJobsCmd.class);
    private final AsyncExecutor asyncExecutor;

    public AcquireEvtJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public List<EvtJobEntity> execute(CommandContext commandContext) {
        HashSet<String> sharingIdSet = new HashSet<String>();
        String wfSharingId = this.getSharingId(DBRoute.workflow.getRouteKey());
        if (WfUtils.isNotEmpty(wfSharingId)) {
            logger.debug(String.format("\u83b7\u53d6\u5de5\u4f5c\u6d41\u7684SharingId-%s", wfSharingId));
            sharingIdSet.add(wfSharingId);
        }
        ArrayList<EvtJobEntity> jobs = new ArrayList<EvtJobEntity>();
        String[] evtDBKeys = WfCacheHelper.getEventJobSourceOfDBRouteKey();
        logger.debug(WfUtils.listToString(Arrays.asList(evtDBKeys), ","));
        if (evtDBKeys != null && evtDBKeys.length > 0) {
            for (String dbKey : evtDBKeys) {
                String sharingId;
                if ("wf".equalsIgnoreCase(dbKey) || "wfs".equalsIgnoreCase(dbKey) || !WfUtils.isNotEmpty(sharingId = this.getSharingId(dbKey)) || !sharingIdSet.add(sharingId)) continue;
                this.searchExpiredJobs(commandContext, dbKey, jobs, "event");
            }
        }
        this.searchExpiredJobs(commandContext, DBRoute.workflow.getRouteKey(), jobs, "event");
        return jobs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSharingId(String dbKey) {
        if (WfUtils.isEmpty(dbKey)) {
            return null;
        }
        String sharingId = EvtCacheHelper.getSharingIdOfDbRouteKey(dbKey);
        if (WfUtils.isNotEmpty(sharingId)) {
            logger.debug(String.format("\u7f13\u5b58\u83b7\u53d6\u7684SharingId-%s", sharingId));
            return sharingId;
        }
        try (DelegateConnection con = (DelegateConnection)TX.__getConnection((String)dbKey, (boolean)true);){
            if (con == null) return null;
            sharingId = con.getDBConfig().getSharingId();
            logger.debug(String.format("\u83b7\u53d6\u7684SharingId-%s", sharingId));
            EvtCacheHelper.putSharingIdOfDbRouteKey(dbKey, sharingId);
            String string = sharingId;
            return string;
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    private void searchExpiredJobs(CommandContext commandContext, String dbKey, List<EvtJobEntity> jobs, String jobType) {
        JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy(JobHandleStrategyFactory.genenateSource(dbKey), jobType);
        strategy.setProcessEngineConfiguration(commandContext.getProcessEngineConfiguration());
        strategy.setSource(JobHandleStrategyFactory.genenateSource(dbKey));
        List<? extends ExecuteJob> ret = strategy.findExpiredJobs(dbKey);
        if (ret == null || ret.isEmpty()) {
            return;
        }
        jobs.addAll(ret);
    }
}

