/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.cmd.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.bec.engine.BecSystemParamterUtils;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntity;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntityImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class AcquireEvtTimerJobsCmd
implements Command<List<EvtTimerJobEntity>> {
    public static final Log logger = LogFactory.getLog(AcquireEvtTimerJobsCmd.class);
    private final AsyncExecutor asyncExecutor;

    public AcquireEvtTimerJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public List<EvtTimerJobEntity> execute(CommandContext commandContext) {
        ArrayList<EvtTimerJobEntity> timerJobs = new ArrayList<EvtTimerJobEntity>();
        timerJobs.addAll(this.loadEvtTimerJobs(commandContext));
        return timerJobs;
    }

    public List<EvtTimerJobEntity> loadEvtTimerJobs(CommandContext commandContext) {
        ArrayList<EvtTimerJobEntity> timerJobs = new ArrayList<EvtTimerJobEntity>();
        Date now = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        logger.debug(String.format("AcquireEvtTimerJobsCmd\u5f53\u524d\u65f6\u95f4%s", now));
        QFilter filter = new QFilter("duedate", "<=", (Object)now);
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            filter.and("lockOwnerId", "=", (Object)lockTag);
        } else {
            filter.and("lockOwnerId", "=", (Object)" ");
        }
        logger.debug(String.format("\u67e5\u8be2\u53c2\u6570%s,%s,%s,%s", now, lockTag, BecSystemParamterUtils.getQuerytimerJobCount(), this.asyncExecutor.toString()));
        String selectFields = commandContext.getEvtTimerJobEntityManager().getSelectFields();
        DynamicObjectCollection tmp = QueryServiceHelper.query((String)"evt_timerjob", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"duedate desc", (int)BecSystemParamterUtils.getQuerytimerJobCount());
        StringBuilder sb = new StringBuilder();
        if (tmp != null && !tmp.isEmpty()) {
            for (DynamicObject d : tmp) {
                EvtTimerJobEntityImpl t = new EvtTimerJobEntityImpl(d);
                t.setExceptionMessage("");
                timerJobs.add(t);
                sb.append(t.getId()).append(',');
            }
        }
        logger.debug(String.format("\u67e5\u8be2\u51fajob%s", sb));
        return timerJobs;
    }
}

