/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.cmd.job;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntity;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntityImpl;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntity;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntityImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.exception.WFEngineException;
import org.apache.curator.shaded.com.google.common.primitives.Booleans;

public class MoveEvtJobToDeadLetterJobBySubscriptionCmd
implements Command<EvtDeadLetterJobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(MoveEvtJobToDeadLetterJobBySubscriptionCmd.class);
    protected Long subscriptionId;
    private Map<String, Object> param;
    private int count;
    private int loops;
    private Date dateUp;
    private Date dateDown;
    private boolean ifMoveToDeadLetter;
    private boolean ifRecoverAuto;
    private boolean ifRecoverHandle;
    private boolean ifDeleteTimerDirectly;
    private boolean ifDeleteDeadletterDirectly;

    public MoveEvtJobToDeadLetterJobBySubscriptionCmd(Map<String, Object> param) {
        this.param = param;
    }

    @Override
    public EvtDeadLetterJobEntity execute(CommandContext commandContext) {
        if (this.param == null || this.param.isEmpty()) {
            log.debug("\u4e8b\u4ef6\u4e2d\u5fc3\u6e05\u7406\u91cd\u8bd5\u8ba2\u9605\uff0c\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        try {
            String countStr = (String)this.param.get("count");
            this.count = WfUtils.isNotEmpty(countStr) ? Integer.parseInt(countStr) : 1000;
            String loopsStr = (String)this.param.get("loops");
            this.loops = WfUtils.isNotEmpty(loopsStr) ? Integer.parseInt(loopsStr) : 1;
            this.subscriptionId = Long.valueOf((String)this.param.get("subscriptionId"));
            if (WfUtils.isEmpty(this.subscriptionId)) {
                log.debug("\u4e8b\u4ef6\u4e2d\u5fc3\u624b\u5de5\u8c03\u5ea6\uff0c\u8bf7\u914d\u7f6e\u8ba2\u9605id\u548c\u6267\u884c\u6570\u91cf");
                return null;
            }
            String timestampUp = (String)this.param.get("dateTimestampUp");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.dateUp = timestampUp != null ? formatter.parse(timestampUp) : commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
            String timestampDown = (String)this.param.get("dateTimestampDown");
            this.dateDown = timestampDown != null ? formatter.parse(timestampDown) : null;
            this.ifDeleteTimerDirectly = Boolean.parseBoolean((String)this.param.get("ifDeleteTimerDirectly"));
            this.ifDeleteDeadletterDirectly = Boolean.parseBoolean((String)this.param.get("ifDeleteDeadletterDirectly"));
            this.ifMoveToDeadLetter = Boolean.parseBoolean((String)this.param.get("ifMoveToDeadLetter"));
            this.ifRecoverAuto = Boolean.parseBoolean((String)this.param.get("ifRecoverAuto"));
            this.ifRecoverHandle = Boolean.parseBoolean((String)this.param.get("ifRecoverHandle"));
            int trueCount = Booleans.countTrue((boolean[])new boolean[]{this.ifDeleteTimerDirectly, this.ifDeleteDeadletterDirectly, this.ifMoveToDeadLetter, this.ifRecoverAuto, this.ifRecoverHandle});
            if (trueCount != 1) {
                log.debug("\u4e8b\u4ef6\u4e2d\u5fc3\u624b\u5de5\u8c03\u5ea6\uff0c\u5e94\u8be5\u53ea\u5e72\u4e00\u4ef6\u4e8b\uff0c\u8fd4\u56de\u3002");
                return null;
            }
            for (int i = 0; i < this.loops; ++i) {
                this.executeJob(commandContext);
            }
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    private void executeJob(CommandContext commandContext) {
        if (this.ifDeleteTimerDirectly) {
            this.deleteJobLoop("evt_timerjob");
        }
        if (this.ifDeleteDeadletterDirectly) {
            this.deleteJobLoop("evt_deadletterjob");
        }
        if (this.ifMoveToDeadLetter) {
            List<EvtTimerJobEntity> evtTimerJobEntitys = this.loadEvtTimerJobsForSuspand(commandContext);
            for (EvtTimerJobEntity entity : evtTimerJobEntitys) {
                String info = String.format(ResManager.loadKDString((String)"Job[%s]\u91cd\u8bd5\u88ab\u624b\u5de5\u6302\u8d77\u3002", (String)"MoveEvtJobToDeadLetterJobBySubscriptionCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), entity.getId());
                WFEngineException e = new WFEngineException("", new Exception(info));
                e.setType("handleSuspendTimer");
                commandContext.getEvtJobManager().moveEvtJobToDeadLetterJob(entity, (Throwable)((Object)e));
            }
        }
        if (this.ifRecoverAuto || this.ifRecoverHandle) {
            if (this.dateDown == null || this.dateDown.compareTo(this.dateUp) > 0) {
                log.debug("\u8bf7\u89c4\u5b9a\u6b63\u786e\u7684\u65f6\u95f4\u4e0b\u9650\u548c\u65f6\u95f4\u4e0a\u9650");
                return;
            }
            List<Long> evtDeadLetterJobEntitys = this.loadDeadletterJobsForRecover(commandContext);
            for (Long id : evtDeadLetterJobEntitys) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"evt_deadletterjob");
                if (obj == null) continue;
                EvtDeadLetterJobEntityImpl job = new EvtDeadLetterJobEntityImpl(obj);
                int retries = MessageServiceUtil.getJobEntityRestries(job, null, commandContext.getProcessEngineConfiguration().getAsyncExecutorNumberOfRetries());
                commandContext.getEvtJobManager().moveDeadLetterJobToExecutableEvtJob(job, retries);
            }
        }
    }

    private List<Long> loadDeadletterJobsForRecover(CommandContext commandContext) {
        log.debug(String.format("\u6fc0\u6d3b\u67e5\u8be2\u53c2\u6570%1$s,%2$s,%3$s", this.dateUp, this.subscriptionId, this.dateDown));
        ArrayList<Long> idList = new ArrayList<Long>();
        QFilter filter = new QFilter("executionId", "=", (Object)this.subscriptionId);
        filter.and("createDate", ">=", (Object)this.dateDown);
        filter.and("createDate", "<=", (Object)this.dateUp);
        if (this.ifRecoverAuto) {
            filter.and("errorType", "=", (Object)"handleSuspend");
        }
        if (this.ifRecoverHandle) {
            filter.and("errorType", "=", (Object)"handleSuspendTimer");
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MoveEvtJobToDeadLetterJobBySubscriptionCmd", (String)"evt_deadletterjob", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"id asc", (int)this.count);){
            while (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                idList.add(Long.valueOf(row.getString("id")));
            }
        }
        return idList;
    }

    private List<EvtTimerJobEntity> loadEvtTimerJobsForSuspand(CommandContext commandContext) {
        ArrayList<EvtTimerJobEntity> timerJobs = new ArrayList<EvtTimerJobEntity>();
        QFilter filter = new QFilter("executionId", "=", (Object)this.subscriptionId);
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            filter.and("lockOwnerId", "=", (Object)lockTag);
        } else {
            filter.and("lockOwnerId", "=", (Object)" ");
        }
        filter.and("duedate", "<=", (Object)this.dateUp);
        if (this.dateDown != null) {
            filter.and("duedate", ">", (Object)this.dateDown);
        }
        log.debug(String.format("\u67e5\u8be2\u53c2\u6570%1$s,%2$s,%3$s,%4$s", this.dateUp, lockTag, this.subscriptionId, this.dateDown));
        DynamicObjectCollection tmp = QueryServiceHelper.query((String)"evt_timerjob", (String)commandContext.getEvtTimerJobEntityManager().getSelectFields(), (QFilter[])new QFilter[]{filter}, (String)"duedate desc", (int)this.count);
        if (tmp != null && !tmp.isEmpty()) {
            for (DynamicObject d : tmp) {
                EvtTimerJobEntityImpl t = new EvtTimerJobEntityImpl(d);
                timerJobs.add(t);
            }
        }
        log.debug(String.format("loadEvtTimerJobsForSuspand\u67e5\u8be2\u51fajob\u6570\u91cf:%s", timerJobs.size()));
        return timerJobs;
    }

    private void deleteJobLoop(String type) {
        int everytimeCount = this.param.get("everytimecount") == null ? 50000 : Integer.parseInt((String)this.param.get("everytimecount"));
        int times = this.count / everytimeCount + (this.count % everytimeCount != 0 ? 1 : 0);
        for (int i = 0; i < times; ++i) {
            int j = this.deleteEventClosedJob(everytimeCount < this.count ? everytimeCount : this.count, type);
            if (j != 1) continue;
            log.debug(String.format("\u7b2c%1$s\u6279%2$s\u5220\u9664\u7ed3\u675f\u3002", i + 1, type));
            break;
        }
    }

    private int deleteEventClosedJob(Integer maxcount, String type) {
        if (this.dateDown == null || this.dateDown.compareTo(this.dateUp) > 0) {
            log.debug("\u8bf7\u89c4\u5b9a\u6b63\u786e\u7684\u65f6\u95f4\u4e0b\u9650\u548c\u65f6\u95f4\u4e0a\u9650");
            return 1;
        }
        QFilter filter = new QFilter("executionId", "=", (Object)this.subscriptionId);
        if ("evt_timerjob".equals(type)) {
            String lockTag = WfConfigurationUtil.getLockTag();
            if (WfUtils.isNotEmpty(lockTag)) {
                filter.and("lockOwnerId", "=", (Object)lockTag);
            } else {
                filter.and("lockOwnerId", "=", (Object)" ");
            }
            filter.and("duedate", "<=", (Object)this.dateUp);
            filter.and("duedate", ">=", (Object)this.dateDown);
        }
        if ("evt_deadletterjob".equals(type)) {
            filter.and("createDate", "<=", (Object)this.dateUp);
            filter.and("createDate", ">=", (Object)this.dateDown);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MoveEvtJobToDeadLetterJobBySubscriptionCmd", (String)type, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"id desc", (int)maxcount);){
            int i = 0;
            ArrayList<Object> idList = new ArrayList<Object>(16);
            Long id = null;
            while (dataSet != null && dataSet.hasNext()) {
                Row row = dataSet.next();
                id = Long.valueOf(row.getString("id"));
                idList.add(id);
                if (++i % 2000 != 0) continue;
                this.deleteEventClosedExecute(idList, type);
                idList.clear();
            }
            if (i % 2000 > 0) {
                this.deleteEventClosedExecute(idList, type);
            }
            if (i < maxcount) {
                int n = 1;
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEventClosedExecute(List<Object> idList, String type) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        TXHandle handle = TX.requiresNew();
        try {
            String sql;
            sb.append(String.format("Scheduling Task AcquireEvtSuspendJobsTask Delete %s to start execution:", type));
            if ("evt_deadletterjob".equals(type)) {
                sql = "DELETE FROM T_EVT_DEADLETTERJOB WHERE FID in ( ? );";
                WfDBUtils.executeBatchDeleteByIn(sql, idList, 500, true);
                sb.append("Delete table EVT_DEADLETTERJOB event records...");
                String sql1 = "DELETE FROM T_EVT_DEADLETTERJOB_L WHERE FID in ( ? );";
                WfDBUtils.executeBatchDeleteByIn(sql1, idList, 500, true);
                sb.append("Delete table EVT_DEADLETTERJOB_L event records...");
            }
            if ("evt_timerjob".equals(type)) {
                sql = "DELETE FROM T_EVT_TIMERJOB WHERE FID in ( ? ) ;";
                WfDBUtils.executeBatchDeleteByIn(sql, idList, 500, true);
                sb.append("Picking up records of EVT_TIMERJOB events...");
            }
        }
        catch (Exception e) {
            handle.markRollback();
            if ("evt_deadletterjob".equals(type)) {
                log.error(String.format("\u5220\u9664\u5df2\u7ed3\u675f\u4e8b\u4ef6EVT_DEADLETTERJOB\u51fa\u9519\uff01 %s", WfUtils.getExceptionStacktrace(e)));
            }
            if ("evt_timerjob".equals(type)) {
                log.error(String.format("\u6361\u6f0f\u5220\u9664T_EVT_TIMERJOB\u51fa\u9519\uff01 %s", WfUtils.getExceptionStacktrace(e)));
            }
        }
        finally {
            log.debug(sb.toString());
            handle.close();
        }
    }
}

