/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.EvtJobDAO;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.bec.engine.cmd.job.MoveEvtJobToDeadLetterJobCmd;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class DistributeEvtJobHandleStrategy
implements JobHandleStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ProcessEngineConfigurationImpl pf;
    private String dbRouteKey;
    private boolean sourceCanChange = true;

    public DistributeEvtJobHandleStrategy() {
    }

    public DistributeEvtJobHandleStrategy(String source, boolean sourceCanChange) {
        this.sourceCanChange = sourceCanChange;
        this.dbRouteKey = JobHandleStrategyFactory.getDBRouteKey(source);
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.pf = processEngineConfiguration;
    }

    @Override
    public void setSource(String source) {
        if (this.sourceCanChange) {
            this.logger.info("DistributeEvtJobHandleStrategy#setSource:dbRouteKey={},source={}", (Object)this.dbRouteKey, (Object)source);
            this.dbRouteKey = JobHandleStrategyFactory.getDBRouteKey(source);
        }
    }

    @Override
    public EvtJobEntity extraMessageToJob(Map jsonObject) {
        if (jsonObject != null) {
            String configuration = (String)jsonObject.get("jobHandlerConfiguration");
            if (WfUtils.isNotEmpty(configuration)) {
                WfUtils.restoreRequestContext(configuration);
            }
            Long id = (Long)jsonObject.get("id");
            return this.findJob(id, false);
        }
        return null;
    }

    @Override
    public void notifyJobFinished(ExecuteJob jobEntity) {
        if (jobEntity != null) {
            this.deleteJob(jobEntity);
        }
    }

    @Override
    public void deleteJob(ExecuteJob jobEntity) {
        EvtJobDAO dao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
        dao.deleteJob((EvtJobEntity)jobEntity);
    }

    @Override
    public EvtJobEntity findJob(Long id, boolean cache) {
        EvtJobDAO jobDao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
        return jobDao.findById(id, this.dbRouteKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EvtJobEntity> findExpiredJobs(String dbKey) {
        ArrayList<EvtJobEntity> result = new ArrayList<EvtJobEntity>();
        EvtJobDAO jobDao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
        List<EvtJobEntity> ret = jobDao.findExpiredJobs(dbKey);
        if (ret != null && !ret.isEmpty()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            List services = WfCommonUtil.getServiceNodes();
            for (EvtJobEntity entity : ret) {
                if (WfUtils.isEmpty(entity.getId())) continue;
                if (WfCacheHelper.isCurrentExecutingJob(entity.getRootJobId())) {
                    this.logger.info(String.format("job[%s] \u6b63\u5728\u88ab\u6267\u884c,\u8fd9\u4e48\u7f55\u89c1\u7684\u60c5\u51b5\u90fd\u88ab\u4f60\u9047\u5230\u4e86\uff0c\u5728\u6267\u884c\u6d88\u606f\u7684\u8fc7\u7a0b\u4e2d\uff0c\u670d\u52a1\u505c\u6b62\u4e86\uff0c\u6b64\u65f6job\u88ab\u9501\u5b9a\uff0c\u6807\u5fd7\u65e0\u6cd5\u89e3\u9664\uff0c\u53ea\u80fd\u624b\u5de5\u5904\u7406\u4e86\u3002", entity.getId()));
                    continue;
                }
                if ((JobStateEnum.PREEXECUTING.getNumber().equals(entity.getState()) || JobStateEnum.EXECUTING.getNumber().equals(entity.getState())) && EvtUtils.checkJobExecutorAlive(entity, services)) continue;
                try {
                    if (entity.getCreateDate() != null && new Date(WfUtils.now().getTime() - 86400000L).after(entity.getCreateDate())) {
                        String markId = String.format("wf/movetodeadjob/%s", entity.getId());
                        boolean flag = false;
                        try {
                            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) <= 0) continue;
                            flag = true;
                            DynamicObject queryDLJob = null;
                            try {
                                queryDLJob = BusinessDataServiceHelper.loadSingle((Object)entity.getRootJobId(), (String)"evt_deadletterjob");
                            }
                            catch (Exception exception) {
                                this.logger.warn(ExceptionUtils.getExceptionStackTraceMessage((Exception)exception));
                            }
                            if (queryDLJob == null) {
                                CommandConfig commandConfig = this.pf.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                                WFEngineException e = new WFEngineException(new RuntimeException(ResManager.loadKDString((String)"\u5e95\u5c42\u7ec4\u4ef6\u5f02\u5e38", (String)"EvtJobEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.jobUnKnowError(), new Object[0]);
                                this.pf.getCommandExecutor().execute(commandConfig, new MoveEvtJobToDeadLetterJobCmd(entity, (Throwable)((Object)e)));
                            }
                            this.deleteJob(entity);
                            continue;
                        }
                        finally {
                            if (!flag) continue;
                            WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
                            continue;
                        }
                    }
                    JobUtil.setJobLockProperty(entity, this.pf, this.pf.getAsyncExecutor());
                    if (JobStateEnum.EXECUTING.getNumber().equalsIgnoreCase(entity.getState())) {
                        entity.setState(JobStateEnum.PREEXECUTING.getNumber());
                    }
                    params.add(new Object[]{entity.getLockExpirationTime(), entity.getLockOwnerId(), entity.getRetries(), entity.getState(), entity.getId()});
                    JSONObject jsonObject = JSON.parseObject((String)entity.getJobHandlerConfiguration());
                    if (jsonObject != null) {
                        String appNumForSubApp = jsonObject.getString("appNumForSubApp");
                        this.logger.debug(String.format("findExpiredJobs--Id[%s]--AppId--[%s]", entity.getId(), appNumForSubApp));
                        entity.setAppNumForSubApp(appNumForSubApp);
                    }
                    result.add(entity);
                }
                catch (Exception e) {
                    this.logger.error(String.format("job[%s] occurs error when acquiring query in distributejob, error msg is [%s]", entity.getId(), WfUtils.getExceptionStacktrace(e)));
                }
            }
            if (!params.isEmpty()) {
                jobDao.update(dbKey, params);
            }
        }
        return result;
    }

    @Override
    public void updateJobState(ExecuteJob wfJob, boolean cache) {
        EvtJobDAO dao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
        dao.updateState(this.dbRouteKey, wfJob);
    }

    @Override
    public void updateJobErrorMsg(Long jobId, String error) {
        JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
        dao.updateErrorMsg(this.dbRouteKey, jobId, error);
    }

    @Override
    public List<ExecuteJob> findJobs(List<Long> ids, boolean cache) {
        return new ArrayList<ExecuteJob>();
    }
}

