/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule;

import java.util.Map;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class RuleUtil {
    public static ILocaleString getExplain(EvtRuleEntity markedRule) {
        String scene = markedRule.getScene();
        ILocaleString explain = null;
        switch (scene) {
            case "overtime": {
                explain = RuleUtil.getExplainForOvertime(markedRule);
                break;
            }
            case "failureRate": {
                explain = RuleUtil.getExplainForFailureRate(markedRule);
                break;
            }
        }
        return explain;
    }

    public static ILocaleString getExplain(String dealOption) {
        LocaleString explainFormat = ResManager.getLocaleString((String)"\u624b\u52a8\u64cd\u4f5c\uff0c\u5df2\u88ab%s", (String)"RuleUtil_1", (String)"bos-wf-engine");
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)explainFormat, RuleUtil.getDealOptionWords(dealOption));
    }

    private static ILocaleString getExplainForFailureRate(EvtRuleEntity markedRule) {
        LocaleString explainFormat = ResManager.getLocaleString((String)"\u6267\u884c\u5931\u8d25\u7684\u5b9e\u4f8b\u5360\u6bd4\u8d85\u8fc7%1$s\uff0c\u5df2\u88ab%2$s", (String)"RuleUtil_2", (String)"bos-wf-engine");
        LocaleString failureRate = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            failureRate.put(lang.name(), (Object)((int)(markedRule.getFailureRate() * 100.0) + "%"));
        }
        ILocaleString ruleDealOperation = RuleUtil.getDealOptionWords(markedRule.getDealOption());
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)explainFormat, new ILocaleString[]{failureRate, ruleDealOperation});
    }

    private static ILocaleString getExplainForOvertime(EvtRuleEntity markedRule) {
        LocaleString explainFormat = ResManager.getLocaleString((String)"\u6267\u884c\u65f6\u957f\u8d85\u8fc7%1$s\u7684\u5b9e\u4f8b\u5360\u6bd4\u8d85\u8fc7%2$s\uff0c\u5df2\u88ab%3$s", (String)"RuleUtil_3", (String)"bos-wf-engine");
        ILocaleString overtimeDuration = RuleUtil.getOvertimeDurationLocaleString(markedRule.getOvertimeDuration());
        LocaleString overtimeRate = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            overtimeRate.put(lang.name(), (Object)((int)(markedRule.getOvertimeRate() * 100.0) + "%"));
        }
        ILocaleString ruleDealOperation = RuleUtil.getDealOptionWords(markedRule.getDealOption());
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)explainFormat, new ILocaleString[]{overtimeDuration, overtimeRate, ruleDealOperation});
    }

    private static ILocaleString getDealOptionWords(String dealOption) {
        LocaleString dealOptionWords = null;
        switch (dealOption) {
            case "suspendSub": {
                dealOptionWords = ResManager.getLocaleString((String)"\u76f4\u63a5\u6302\u8d77", (String)"RuleUtil_4", (String)"bos-wf-engine");
                break;
            }
            case "isolateSlowqueue": {
                dealOptionWords = ResManager.getLocaleString((String)"\u9694\u79bb\u81f3\u6162\u961f\u5217", (String)"RuleUtil_5", (String)"bos-wf-engine");
                break;
            }
            case "noRetry": {
                dealOptionWords = ResManager.getLocaleString((String)"\u62d2\u7edd\u91cd\u8bd5\u5e76\u4e14\u9694\u79bb\u81f3\u6162\u961f\u5217", (String)"RuleUtil_6", (String)"bos-wf-engine");
                break;
            }
        }
        return dealOptionWords;
    }

    public static ILocaleString getExplainForFailureRate(Map<String, Object> param, String dealOption) {
        if (param == null || param.get("failureRate") == null || WfUtils.isEmpty(dealOption)) {
            return null;
        }
        double failureRateValue = Double.parseDouble(param.get("failureRate").toString());
        LocaleString explainFormat = ResManager.getLocaleString((String)"\u8ba2\u9605\u6267\u884c\u5931\u8d25\u5360\u6bd4\u8d85\u8fc7%1$s\uff0c%2$s\u3002", (String)"RuleUtil_7", (String)"bos-wf-engine");
        LocaleString failureRate = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            failureRate.put(lang.name(), (Object)((int)(failureRateValue * 100.0) + "%"));
        }
        ILocaleString ruleDealOperation = RuleUtil.getDealOptionWords(dealOption);
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)explainFormat, new ILocaleString[]{failureRate, ruleDealOperation});
    }

    public static ILocaleString getExplainForOvertime(Map<String, Object> param, String dealOption) {
        if (param == null || param.get("overtimeDuration") == null || param.get("overtimeRate") == null || WfUtils.isEmpty(dealOption)) {
            return null;
        }
        long overtimeDurationValue = Long.parseLong(param.get("overtimeDuration").toString());
        double overtimeRateValue = Double.parseDouble(param.get("overtimeRate").toString());
        LocaleString explainFormat = ResManager.getLocaleString((String)"\u8ba2\u9605\u6267\u884c\u65f6\u957f\u8d85\u8fc7%1$s\u7684\u5360\u6bd4\u8d85\u8fc7%2$s\uff0c%3$s\u3002", (String)"RuleUtil_8", (String)"bos-wf-engine");
        ILocaleString overtimeDuration = RuleUtil.getOvertimeDurationLocaleString(overtimeDurationValue);
        LocaleString overtimeRate = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            overtimeRate.put(lang.name(), (Object)((int)(overtimeRateValue * 100.0) + "%"));
        }
        ILocaleString ruleDealOperation = RuleUtil.getDealOptionWords(dealOption);
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)explainFormat, new ILocaleString[]{overtimeDuration, overtimeRate, ruleDealOperation});
    }

    private static ILocaleString getOvertimeDurationLocaleString(long overtimeDuration) {
        LocaleString overtimeDurLocaleString;
        long minute = overtimeDuration / 60000L;
        long allSecond = overtimeDuration % 60000L;
        long second = allSecond / 1000L;
        long milliSecond = allSecond % 1000L;
        LocaleString minuteLocaleString = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            minuteLocaleString.put(lang.name(), (Object)String.valueOf(minute));
        }
        LocaleString secondLocaleString = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            secondLocaleString.put(lang.name(), (Object)String.valueOf(second));
        }
        LocaleString milliSecondLocaleString = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            milliSecondLocaleString.put(lang.name(), (Object)String.valueOf(milliSecond));
        }
        if (minute > 0L) {
            if (allSecond == 0L) {
                overtimeDurLocaleString = ResManager.getLocaleString((String)"%1$s\u5206\u949f", (String)"RuleUtil_9", (String)"bos-wf-engine");
                return WfMultiLangUtils.replaceILocaleString((ILocaleString)overtimeDurLocaleString, new ILocaleString[]{minuteLocaleString});
            }
            if (milliSecond == 0L) {
                overtimeDurLocaleString = ResManager.getLocaleString((String)"%1$s\u5206\u949f%2$s\u79d2", (String)"RuleUtil_10", (String)"bos-wf-engine");
                return WfMultiLangUtils.replaceILocaleString((ILocaleString)overtimeDurLocaleString, new ILocaleString[]{minuteLocaleString, secondLocaleString});
            }
            overtimeDurLocaleString = ResManager.getLocaleString((String)"%1$s\u5206\u949f%2$s\u79d2%3$s\u6beb\u79d2", (String)"RuleUtil_11", (String)"bos-wf-engine");
            return WfMultiLangUtils.replaceILocaleString((ILocaleString)overtimeDurLocaleString, new ILocaleString[]{minuteLocaleString, secondLocaleString, milliSecondLocaleString});
        }
        if (second > 0L) {
            if (milliSecond == 0L) {
                overtimeDurLocaleString = ResManager.getLocaleString((String)"%1$s\u79d2", (String)"RuleUtil_12", (String)"bos-wf-engine");
                return WfMultiLangUtils.replaceILocaleString((ILocaleString)overtimeDurLocaleString, new ILocaleString[]{secondLocaleString});
            }
            overtimeDurLocaleString = ResManager.getLocaleString((String)"%1$s\u79d2%2$s\u6beb\u79d2", (String)"RuleUtil_13", (String)"bos-wf-engine");
            return WfMultiLangUtils.replaceILocaleString((ILocaleString)overtimeDurLocaleString, new ILocaleString[]{secondLocaleString, milliSecondLocaleString});
        }
        overtimeDurLocaleString = ResManager.getLocaleString((String)"%1$s\u6beb\u79d2", (String)"RuleUtil_14", (String)"bos-wf-engine");
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)overtimeDurLocaleString, new ILocaleString[]{milliSecondLocaleString});
    }
}

