/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule.calculate.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.devops.rule.calculate.matcher.IRuleMatcher;
import kd.bos.bec.engine.devops.rule.calculate.matcher.RuleMatcherFactory;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;
import kd.bos.dataentity.TypesContainer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ReflectUtil;

public abstract class AbstractCalculateCmd
implements Command<Void> {
    protected List<EvtRuleEntity> ruleEntitys;
    protected Map<Long, EvtRuleEntity> ruleEntityMap;
    protected CommandContext commandContext;

    @Override
    public Void execute(CommandContext commandContext) {
        this.ruleEntitys = commandContext.getEvtRuleEntityManager().findRuleByTriggerTime(this.getTriggerTime());
        if (WfUtils.isEmptyForCollection(this.ruleEntitys)) {
            return null;
        }
        this.ruleEntityMap = new HashMap<Long, EvtRuleEntity>(this.ruleEntitys.size());
        for (EvtRuleEntity entity : this.ruleEntitys) {
            this.ruleEntityMap.put(entity.getId(), entity);
        }
        this.commandContext = commandContext;
        this.calculate();
        return null;
    }

    protected void matchRuleAndCollect(Long subscriptionId, Map<String, Object> params) {
        HashMap<Long, String> matchFailReason = new HashMap<Long, String>(this.ruleEntitys.size());
        if (params == null) {
            this.collectNeedDealSubs(null, subscriptionId, matchFailReason);
            return;
        }
        EvtRuleEntity markedRule = null;
        for (EvtRuleEntity ruleEntity : this.ruleEntitys) {
            String matchResult;
            if (this.isSkip(subscriptionId, ruleEntity)) continue;
            if (WfUtils.isEmpty(ruleEntity.getPlugin())) {
                IRuleMatcher ruleMatcher = RuleMatcherFactory.getRuleMatcher(ruleEntity.getScene());
                matchResult = ruleMatcher.match(ruleEntity, params);
            } else {
                matchResult = (String)ReflectUtil.invoke(TypesContainer.createInstance((String)ruleEntity.getPlugin()), "match", new Object[]{ruleEntity, params});
            }
            if ("success".equals(matchResult)) {
                markedRule = ruleEntity;
                break;
            }
            matchFailReason.put(ruleEntity.getId(), matchResult);
        }
        this.collectNeedDealSubs(markedRule, subscriptionId, matchFailReason);
    }

    protected boolean isSkip(Long subscriptionId, EvtRuleEntity ruleEntity) {
        return false;
    }

    protected abstract String getTriggerTime();

    protected abstract void collectNeedDealSubs(EvtRuleEntity var1, Long var2, Map<Long, String> var3);

    protected abstract void calculate();
}

