/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule.calculate.cmd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.devops.rule.RuleUtil;
import kd.bos.bec.engine.devops.rule.calculate.cmd.AbstractCalculateCmd;
import kd.bos.bec.engine.devops.rule.calculate.handler.RuleHandlerFactory;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntity;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntityManager;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;
import kd.bos.bec.engine.devops.rule.persistent.HistoricEvtAbnormalSubEntityManager;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class AfterIndicatorCalculateRuleCmd
extends AbstractCalculateCmd {
    private static Log log = LogFactory.getLog(AfterIndicatorCalculateRuleCmd.class);
    private static final String MESSAGE_SCENE = "evtSubscriptionAbnormal";
    private String searchDate;
    private Map<Long, EvtAbnormalSubEntity> matchedAbnormalSubEntitys;
    private Map<Long, List<EvtAbnormalSubEntity>> recentManualRelieveSubs;
    private Map<Long, List<Long>> needMarkRuleOfSubMap = new HashMap<Long, List<Long>>(6);
    private Map<Long, List<EvtAbnormalSubEntity>> needRelieveRuleOfSubMap = new HashMap<Long, List<EvtAbnormalSubEntity>>(4);
    private Map<String, List<EvtAbnormalSubEntity>> needRelieveManualAbnormalSubMap = new HashMap<String, List<EvtAbnormalSubEntity>>(3);

    public AfterIndicatorCalculateRuleCmd(String searchDate) {
        this.searchDate = searchDate;
    }

    @Override
    public void calculate() {
        log.info(String.format("AfterIndicatorCalculateRuleCmd calculate begin:%s", this.searchDate));
        if (WfUtils.isEmpty(this.searchDate)) {
            return;
        }
        this.initMatchedAbnormalSubEntitys();
        Map<Long, Map<String, Object>> recentSubs = this.getRecentSubsExecutedResult(this.searchDate);
        if (WfUtils.isEmptyForMap(recentSubs)) {
            log.info("AfterIndicatorCalculateRuleCmd calculate return");
            return;
        }
        this.initRecentManualRelieveSubs(recentSubs.keySet());
        for (Map.Entry<Long, Map<String, Object>> entry : recentSubs.entrySet()) {
            try {
                log.info(String.format("subscriptionId=%s, begin matchRuleAndDeal", entry.getKey()));
                this.matchRuleAndCollect(entry.getKey(), entry.getValue());
                log.info(String.format("subscriptionId=%s, matchRuleAndDeal success", entry.getKey()));
            }
            catch (Exception ex) {
                log.error(String.format("subscriptionId=%s, matchRuleAndDeal is error, errorInfo is : %s", entry.getKey(), WfUtils.getExceptionStacktrace(ex)));
            }
        }
        this.dealSubsByRuleId();
        log.info("AfterIndicatorCalculateRuleCmd calculate end");
    }

    @Override
    protected String getTriggerTime() {
        return "afterIndicatorCalculate";
    }

    @Override
    protected void collectNeedDealSubs(EvtRuleEntity markedRule, Long subscriptionId, Map<Long, String> matchFailReason) {
        EvtRuleEntity rule;
        EvtAbnormalSubEntity evtAbnormalSubEntity = this.matchedAbnormalSubEntitys.get(subscriptionId);
        if (markedRule != null && markedRule.getShieldSubs().contains(subscriptionId)) {
            markedRule = null;
        }
        if (evtAbnormalSubEntity != null && "auto".equals(evtAbnormalSubEntity.getOperateType()) && (rule = (EvtRuleEntity)this.ruleEntityMap.get(evtAbnormalSubEntity.getRegularId())).getShieldSubs().contains(subscriptionId)) {
            matchFailReason.put(evtAbnormalSubEntity.getRegularId(), "fail");
        }
        if (evtAbnormalSubEntity != null && "manual".equals(evtAbnormalSubEntity.getOperateType())) {
            if (markedRule != null && Integer.parseInt(markedRule.getErrorLevel()) > Integer.parseInt(evtAbnormalSubEntity.getErrorLevel())) {
                this.addNeedRelieveManualAbnormalSubMap(evtAbnormalSubEntity);
                this.addNeedMarkRuleOfSubMap(markedRule.getId(), subscriptionId);
            }
            return;
        }
        if (markedRule == null) {
            if (evtAbnormalSubEntity != null && !"suspendSub".equals(evtAbnormalSubEntity.getDealOption()) && "fail".equals(matchFailReason.get(evtAbnormalSubEntity.getRegularId()))) {
                this.addNeedRelieveRuleOfSubMap(evtAbnormalSubEntity);
            }
            return;
        }
        if (evtAbnormalSubEntity != null && !"suspendSub".equals(evtAbnormalSubEntity.getDealOption()) && !markedRule.getId().equals(evtAbnormalSubEntity.getRegularId())) {
            this.addNeedRelieveRuleOfSubMap(evtAbnormalSubEntity);
            this.addNeedMarkRuleOfSubMap(markedRule.getId(), subscriptionId);
            return;
        }
        if (evtAbnormalSubEntity == null) {
            this.addNeedMarkRuleOfSubMap(markedRule.getId(), subscriptionId);
        }
    }

    private void dealSubsByRuleId() {
        EvtRuleEntity evtRuleEntity;
        ILocaleString message;
        ArrayList<ILocaleString> relieveMessages = new ArrayList<ILocaleString>(16);
        ArrayList<ILocaleString> markMessages = new ArrayList<ILocaleString>(16);
        if (WfUtils.isNotEmptyForMap(this.needRelieveManualAbnormalSubMap)) {
            for (Map.Entry<String, List<EvtAbnormalSubEntity>> entry : this.needRelieveManualAbnormalSubMap.entrySet()) {
                String dealOption = entry.getKey();
                RuleHandlerFactory.getRuleHandler(dealOption).relieve(this.commandContext, entry.getValue(), "auto");
                message = this.getRelieveMessage(dealOption, null, entry.getValue());
                if (message == null) continue;
                relieveMessages.add(message);
            }
        }
        if (WfUtils.isNotEmptyForMap(this.needRelieveRuleOfSubMap)) {
            for (Map.Entry<Object, List<EvtAbnormalSubEntity>> entry : this.needRelieveRuleOfSubMap.entrySet()) {
                evtRuleEntity = this.getEvtRuleById((Long)entry.getKey());
                RuleHandlerFactory.getRuleHandler(evtRuleEntity.getDealOption()).relieve(this.commandContext, entry.getValue(), "auto");
                message = this.getRelieveMessage(null, evtRuleEntity, entry.getValue());
                if (message == null) continue;
                relieveMessages.add(message);
            }
        }
        if (WfUtils.isNotEmptyForMap(this.needMarkRuleOfSubMap)) {
            for (Map.Entry<Object, List<Object>> entry : this.needMarkRuleOfSubMap.entrySet()) {
                evtRuleEntity = this.getEvtRuleById((Long)entry.getKey());
                RuleHandlerFactory.getRuleHandler(evtRuleEntity.getDealOption()).handle(this.commandContext, entry.getValue(), this.getEvtRuleById((Long)entry.getKey()));
                message = this.getMarkMessage(evtRuleEntity, entry.getValue());
                if (message == null) continue;
                markMessages.add(message);
            }
        }
    }

    private EvtRuleEntity getEvtRuleById(Long ruleId) {
        return (EvtRuleEntity)this.commandContext.getEvtRuleEntityManager().findById(ruleId);
    }

    @Override
    public boolean isSkip(Long subscriptionId, EvtRuleEntity ruleEntity) {
        return this.checkIsManualRelieveInToday(ruleEntity, subscriptionId);
    }

    private boolean checkIsManualRelieveInToday(EvtRuleEntity markedRule, Long subscriptionId) {
        List<EvtAbnormalSubEntity> hiSubs = this.recentManualRelieveSubs.get(subscriptionId);
        if (WfUtils.isEmptyForCollection(hiSubs)) {
            return false;
        }
        for (EvtAbnormalSubEntity hiSub : hiSubs) {
            if (markedRule == null || !WfUtils.isNotEmpty(markedRule.getScene()) || !markedRule.getScene().equals(hiSub.getScene())) continue;
            return true;
        }
        return false;
    }

    private void initRecentManualRelieveSubs(Set<Long> subscriptionIds) {
        EvtAbnormalSubEntityManager manager = this.commandContext.getEvtAbnormalSubEntityManager();
        HistoricEvtAbnormalSubEntityManager hiManager = this.commandContext.getHistoricEvtAbnormalSubEntityManager();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(String.format("%s %s", this.searchDate, "000000"));
            endDate = sdf.parse(String.format("%s %s", this.searchDate, "235959"));
        }
        catch (Exception e) {
            log.error("initRecentManualRelieveSubs is error, errorInfo is :" + WfUtils.getExceptionStacktrace(e));
        }
        List<EvtAbnormalSubEntity> entities = manager.findManualRelieveSubs(subscriptionIds, startDate, endDate);
        entities.addAll(hiManager.findManualRelieveSubs(subscriptionIds, startDate, endDate));
        if (WfUtils.isEmptyForCollection(entities)) {
            this.recentManualRelieveSubs = new HashMap<Long, List<EvtAbnormalSubEntity>>(0);
            return;
        }
        this.recentManualRelieveSubs = new HashMap<Long, List<EvtAbnormalSubEntity>>(subscriptionIds.size());
        for (EvtAbnormalSubEntity entity : entities) {
            Long subscriptionId = entity.getSubscriptionId();
            this.recentManualRelieveSubs.putIfAbsent(subscriptionId, new ArrayList(10));
            List<EvtAbnormalSubEntity> abnormalSubs = this.recentManualRelieveSubs.get(subscriptionId);
            if (abnormalSubs == null) continue;
            abnormalSubs.add(entity);
        }
    }

    private Map<Long, Map<String, Object>> getRecentSubsExecutedResult(String dateString) {
        HashMap<Long, Map<String, Object>> result;
        block21: {
            result = new HashMap<Long, Map<String, Object>>(16);
            for (Long subId : this.matchedAbnormalSubEntitys.keySet()) {
                result.put(subId, null);
            }
            int minBaseCount = this.getMinBaseCount();
            String sql = "SELECT fsubscriptionid subscriptionid,fcompletedtotal completedtotal,ferroredtotal erroredtotal,fovertimeconfig overtimeconfig FROM t_wf_evtinstancecollect WHERE fnumber = ?";
            Object[] params = new Object[]{dateString};
            try {
                DataSet ds = DB.queryDataSet((String)"evt.getRecentSubsExecutedResult", (DBRoute)WfUtils.WFS, (String)sql, (Object[])params);
                Throwable throwable = null;
                block14: while (true) {
                    try {
                        while (ds != null && ds.hasNext()) {
                            Row row = ds.next();
                            if (row == null) continue;
                            Integer completedTotal = 0;
                            if (row.get("completedtotal") != null) {
                                completedTotal = row.getInteger("completedtotal");
                            }
                            Integer erroredTotal = 0;
                            if (row.get("erroredtotal") != null) {
                                erroredTotal = row.getInteger("erroredtotal");
                            }
                            if (completedTotal + erroredTotal < minBaseCount) continue;
                            HashMap<String, Object> subsParams = new HashMap<String, Object>(16);
                            result.put(row.getLong("subscriptionid"), subsParams);
                            subsParams.put("completedtotal", completedTotal);
                            subsParams.put("erroredtotal", erroredTotal);
                            String overtimeConfig = row.getString("overtimeconfig");
                            if (!WfUtils.isNotEmpty(overtimeConfig)) continue;
                            try {
                                Map overtimeMap = (Map)SerializationUtils.fromJsonString((String)overtimeConfig, Map.class);
                                if (!WfUtils.isNotEmptyForMap(overtimeMap)) continue block14;
                                subsParams.put("overtimeMap", overtimeMap);
                                continue block14;
                            }
                            catch (Exception ex) {
                                log.error(String.format("AfterIndicatorCalculateRuleCmd.getRecentSubsExecuted---Resultresolve overtimeconfig fail, overtimeconfig is not JSONObject. overtimeconfig=%s", overtimeConfig));
                            }
                        }
                        break block21;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (ds != null) {
                        if (throwable != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error(WfUtils.getExceptionStacktrace(ex));
            }
        }
        return result;
    }

    private int getMinBaseCount() {
        int minBaseCount = ((EvtRuleEntity)this.ruleEntitys.get(0)).getBaseCount();
        for (EvtRuleEntity ruleEntity : this.ruleEntitys) {
            int baseCount = ruleEntity.getBaseCount();
            if (baseCount >= minBaseCount) continue;
            minBaseCount = baseCount;
        }
        return minBaseCount;
    }

    private void initMatchedAbnormalSubEntitys() {
        this.matchedAbnormalSubEntitys = new HashMap<Long, EvtAbnormalSubEntity>(16);
        List<EvtAbnormalSubEntity> matchedEntityList = this.commandContext.getEvtAbnormalSubEntityManager().findAllEvtAbnormalSubEntitys();
        if (WfUtils.isNotEmptyForCollection(matchedEntityList)) {
            for (EvtAbnormalSubEntity entity : matchedEntityList) {
                this.matchedAbnormalSubEntitys.put(entity.getSubscriptionId(), entity);
            }
        }
    }

    private void addNeedRelieveRuleOfSubMap(EvtAbnormalSubEntity evtAbnormalSubEntity) {
        this.needRelieveRuleOfSubMap.putIfAbsent(evtAbnormalSubEntity.getRegularId(), new ArrayList(10));
        List<EvtAbnormalSubEntity> evtAbnormalSubEntityList = this.needRelieveRuleOfSubMap.get(evtAbnormalSubEntity.getRegularId());
        if (evtAbnormalSubEntityList != null) {
            evtAbnormalSubEntityList.add(evtAbnormalSubEntity);
        }
    }

    private void addNeedRelieveManualAbnormalSubMap(EvtAbnormalSubEntity evtAbnormalSubEntity) {
        this.needRelieveManualAbnormalSubMap.putIfAbsent(evtAbnormalSubEntity.getDealOption(), new ArrayList(10));
        List<EvtAbnormalSubEntity> evtAbnormalSubEntityList = this.needRelieveManualAbnormalSubMap.get(evtAbnormalSubEntity.getDealOption());
        if (evtAbnormalSubEntityList != null) {
            evtAbnormalSubEntityList.add(evtAbnormalSubEntity);
        }
    }

    private void addNeedMarkRuleOfSubMap(Long ruleId, Long subscriptionId) {
        this.needMarkRuleOfSubMap.putIfAbsent(ruleId, new ArrayList(10));
        List<Long> needMarkSubList = this.needMarkRuleOfSubMap.get(ruleId);
        if (needMarkSubList != null) {
            needMarkSubList.add(subscriptionId);
        }
    }

    private ILocaleString getMarkMessage(EvtRuleEntity evtRuleEntity, List<Long> subscriptionIds) {
        if (WfUtils.isEmptyForCollection(subscriptionIds)) {
            return null;
        }
        LocaleString contentFormat = ResManager.getLocaleString((String)"\u8ba2\u9605\u7f16\u7801\u4e3a[%1$s]\u7684\u8ba2\u9605\uff0c%2$s\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"AfterIndicatorCalculateRuleCmd_1", (String)"bos-wf-engine");
        LocaleString subsNumber = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            subsNumber.put((Object)lang.name(), (Object)this.getEvtSubscriptionsByIds(subscriptionIds));
        }
        return WfMultiLangUtils.replaceILocaleString((ILocaleString)contentFormat, new ILocaleString[]{subsNumber, RuleUtil.getExplain(evtRuleEntity)});
    }

    private ILocaleString getRelieveMessage(String dealOption, EvtRuleEntity evtRuleEntity, List<EvtAbnormalSubEntity> evtAbnormalSubEntitys) {
        if (WfUtils.isEmptyForCollection(evtAbnormalSubEntitys)) {
            return null;
        }
        LocaleString contentFormat = ResManager.getLocaleString((String)"\u8ba2\u9605\u7f16\u7801\u4e3a[%1$s]\u7684\u8ba2\u9605\u5df2\u89e3\u9664\u5982\u4e0b\u89c4\u5219\uff1a%2$s\u3002", (String)"AfterIndicatorCalculateRuleCmd_2", (String)"bos-wf-engine");
        LocaleString subsNumber = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            subsNumber.put((Object)lang.name(), (Object)this.getEvtSubscriptionsByAbnormalSubs(evtAbnormalSubEntitys));
        }
        ILocaleString content = evtRuleEntity == null ? WfMultiLangUtils.replaceILocaleString((ILocaleString)contentFormat, new ILocaleString[]{subsNumber, RuleUtil.getExplain(dealOption)}) : WfMultiLangUtils.replaceILocaleString((ILocaleString)contentFormat, new ILocaleString[]{subsNumber, RuleUtil.getExplain(evtRuleEntity)});
        return content;
    }

    private void sendMessage(ILocaleString title, ILocaleString content, boolean isMark) {
        if (WfUtils.isEmpty(content)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appnumber", "bec");
        if (isMark) {
            WorkflowDevopsService.create().sendAlarmMessage(MESSAGE_SCENE, String.format("evtRule-mark-%s", WfUtils.now().getTime()), title, content, params);
        } else {
            WorkflowDevopsService.create().sendAlarmMessage(MESSAGE_SCENE, String.format("evtRule-relieve-%s", WfUtils.now().getTime()), title, content, params);
        }
    }

    private String getEvtSubscriptionsByAbnormalSubs(List<EvtAbnormalSubEntity> evtAbnormalSubEntitys) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (EvtAbnormalSubEntity evtAbnormalSubEntity : evtAbnormalSubEntitys) {
            stringJoiner.add(evtAbnormalSubEntity.getSubscriptionNumber());
        }
        return stringJoiner.toString();
    }

    private String getEvtSubscriptionsByIds(List<Long> subscriptionIds) {
        DynamicObjectCollection evtSubscriptions = QueryServiceHelper.query((String)"evt_subscription", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", subscriptionIds)});
        if (WfUtils.isEmptyForCollection((Collection)evtSubscriptions)) {
            return null;
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        for (DynamicObject dyn : evtSubscriptions) {
            stringJoiner.add(dyn.getString("number"));
        }
        return stringJoiner.toString();
    }

    private ILocaleString getTitle(boolean isMark) {
        if (isMark) {
            return ResManager.getLocaleString((String)"\u4e8b\u4ef6\u8ba2\u9605\u6267\u884c\u5f02\u5e38\u901a\u77e5", (String)"AfterIndicatorCalculateRuleCmd_4", (String)"bos-wf-engine");
        }
        return ResManager.getLocaleString((String)"\u5f02\u5e38\u8ba2\u9605\u81ea\u52a8\u89e3\u9664\u901a\u77e5", (String)"AfterIndicatorCalculateRuleCmd_3", (String)"bos-wf-engine");
    }
}

