/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule.calculate.handler;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bec.engine.devops.rule.RuleUtil;
import kd.bos.bec.engine.devops.rule.calculate.handler.IRuleHandler;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntity;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntityManager;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.exception.WFException;

public abstract class AbstractHandler
implements IRuleHandler {
    protected Log log = LogFactory.getLog(this.getClass());

    protected EvtAbnormalSubEntity persistentMark(CommandContext commandContext, Long subscriptionId, EvtRuleEntity markedRule, String dealOption, LocaleString explain) {
        return this.createAbnormalRecord(commandContext, subscriptionId, markedRule, dealOption, explain);
    }

    protected void persistentRelieve(CommandContext commandContext, EvtAbnormalSubEntity evtAbnormalSubEntity, String relieveType) {
        if (evtAbnormalSubEntity == null || WfUtils.isEmpty(evtAbnormalSubEntity.getDealOption()) || WfUtils.isEmpty(relieveType)) {
            return;
        }
        EvtAbnormalSubEntityManager manager = commandContext.getEvtAbnormalSubEntityManager();
        evtAbnormalSubEntity.setRelieveType(relieveType);
        evtAbnormalSubEntity.setRelieveDate(WfUtils.now());
        if ("manual".equals(relieveType)) {
            evtAbnormalSubEntity.setRelieverId(RequestContext.get().getCurrUserId());
            evtAbnormalSubEntity.setRelieverName(WfUtils.findUserName(RequestContext.get().getCurrUserId()));
        }
        manager.moveToHistory(evtAbnormalSubEntity);
    }

    private EvtAbnormalSubEntity createAbnormalRecord(CommandContext commandContext, Long subscriptionId, EvtRuleEntity markedRule, String dealOption, LocaleString explain) {
        if (WfUtils.isEmpty(subscriptionId)) {
            return null;
        }
        EvtAbnormalSubEntityManager manager = commandContext.getEvtAbnormalSubEntityManager();
        EvtAbnormalSubEntity subEntity = (EvtAbnormalSubEntity)manager.create();
        DynamicObject evtSubscription = this.getEvtSubscription(subscriptionId);
        subEntity.setSubscriptionId(evtSubscription.getLong("id"));
        subEntity.setSubscriptionNumber(evtSubscription.getString("number"));
        subEntity.setSubscriptionName(evtSubscription.getLocaleString("name"));
        DynamicObject evtEvent = evtSubscription.getDynamicObject("event");
        subEntity.setEventId(evtEvent.getLong("id"));
        subEntity.setEventNumber(evtEvent.getString("number"));
        subEntity.setEventName(evtEvent.getLocaleString("name"));
        subEntity.setOperateType("auto");
        if (markedRule == null) {
            subEntity.setDealOption(dealOption);
            subEntity.setCreatorId(RequestContext.get().getCurrUserId());
            subEntity.setCreatorName(WfUtils.findUserName(RequestContext.get().getCurrUserId()));
            subEntity.setOperateType("manual");
            if (WfUtils.isEmpty((ILocaleString)explain)) {
                subEntity.setExplain(RuleUtil.getExplain(dealOption));
            } else {
                subEntity.setExplain((ILocaleString)explain);
            }
            switch (dealOption) {
                case "suspendSub": {
                    subEntity.setSubState("1");
                    subEntity.setErrorLevel("40");
                    break;
                }
                case "noRetry": {
                    subEntity.setSubState("0");
                    subEntity.setErrorLevel("30");
                    break;
                }
                case "isolateSlowqueue": {
                    subEntity.setSubState("0");
                    subEntity.setErrorLevel("20");
                    break;
                }
            }
        } else {
            subEntity.setRegularId(markedRule.getId());
            subEntity.setDealOption(markedRule.getDealOption());
            subEntity.setScene(markedRule.getScene());
            subEntity.setErrorLevel(markedRule.getErrorLevel());
            subEntity.setExplain(RuleUtil.getExplain(markedRule));
            subEntity.setOperateType("auto");
            if ("suspendSub".equals(markedRule.getDealOption())) {
                subEntity.setSubState("1");
            } else {
                subEntity.setSubState("0");
            }
        }
        manager.insert(subEntity);
        return subEntity;
    }

    private DynamicObject getEvtSubscription(Long subscriptionId) {
        DynamicObject evtSubscription = BusinessDataServiceHelper.loadSingleFromCache((Object)subscriptionId, (String)"evt_subscription", (String)"id,event,number,name");
        if (evtSubscription == null) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u8ba2\u9605Id\u4e3a%1$s\u7684\u8ba2\u9605\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bb0\u5f55\u5f02\u5e38\u8ba2\u9605\u5931\u8d25\u3002", (String)"AbstractHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), subscriptionId));
        }
        return evtSubscription;
    }

    @Override
    public void handle(CommandContext commandContext, Long subscriptionId, EvtRuleEntity markedRule, LocaleString explain) {
        this.persistentMark(commandContext, subscriptionId, markedRule, this.getDealOption(), explain);
        ArrayList<Long> subscriptionIds = new ArrayList<Long>(1);
        subscriptionIds.add(subscriptionId);
        this.cleanCache(commandContext, subscriptionIds, true);
    }

    @Override
    public void relieve(CommandContext commandContext, EvtAbnormalSubEntity evtAbnormalSubEntity, String relieveType) {
        this.persistentRelieve(commandContext, evtAbnormalSubEntity, relieveType);
        ArrayList<Long> subscriptionIds = new ArrayList<Long>(1);
        subscriptionIds.add(evtAbnormalSubEntity.getSubscriptionId());
        this.cleanCache(commandContext, subscriptionIds, false);
    }

    @Override
    public void handle(CommandContext commandContext, List<Long> subscriptionIds, EvtRuleEntity markedRule) {
        if (WfUtils.isEmptyForCollection(subscriptionIds)) {
            return;
        }
        for (Long subscriptionId : subscriptionIds) {
            this.persistentMark(commandContext, subscriptionId, markedRule, this.getDealOption(), null);
        }
        this.cleanCache(commandContext, subscriptionIds, true);
    }

    @Override
    public void relieve(CommandContext commandContext, List<EvtAbnormalSubEntity> evtAbnormalSubEntitys, String relieveType) {
        if (WfUtils.isEmptyForCollection(evtAbnormalSubEntitys)) {
            return;
        }
        ArrayList<Long> subscriptionIds = new ArrayList<Long>(evtAbnormalSubEntitys.size());
        for (EvtAbnormalSubEntity entity : evtAbnormalSubEntitys) {
            this.persistentRelieve(commandContext, entity, relieveType);
            subscriptionIds.add(entity.getSubscriptionId());
        }
        this.cleanCache(commandContext, subscriptionIds, false);
    }

    abstract String getDealOption();

    abstract void cleanCache(CommandContext var1, List<Long> var2, boolean var3);
}

