/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule.calculate.handler;

import java.util.List;
import kd.bos.bec.engine.EvtEngineUtils;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.devops.rule.calculate.handler.AbstractHandler;
import kd.bos.bec.engine.devops.rule.calculate.handler.IRuleHandler;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntity;
import kd.bos.bec.engine.devops.rule.persistent.EvtAbnormalSubEntityManager;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class SuspendSubHandler
extends AbstractHandler
implements IRuleHandler {
    @Override
    String getDealOption() {
        return "suspendSub";
    }

    @Override
    void cleanCache(CommandContext commandContext, List<Long> subscriptionIds, boolean isForward) {
        EvtCacheHelper.removeSuspendSubs();
    }

    @Override
    public EvtAbnormalSubEntity persistentMark(CommandContext commandContext, Long subscriptionId, EvtRuleEntity markedRule, String dealOption, LocaleString explain) {
        this.forceCompleteRelievingSub(commandContext, subscriptionId);
        EvtAbnormalSubEntity entity = super.persistentMark(commandContext, subscriptionId, markedRule, dealOption, explain);
        EvtEngineUtils.insertOneTask(commandContext, subscriptionId, "1");
        return entity;
    }

    private void forceCompleteRelievingSub(CommandContext commandContext, Long subscriptionId) {
        List relievingSubs = commandContext.getEvtAbnormalSubEntityManager().findByQueryFilters(new QFilter[]{new QFilter("subscriptionId", "=", (Object)subscriptionId), new QFilter("subState", "=", (Object)"2")});
        if (WfUtils.isEmptyForCollection(relievingSubs)) {
            return;
        }
        EvtEngineUtils.deleteTask(commandContext, subscriptionId, "2");
        for (EvtAbnormalSubEntity entity : relievingSubs) {
            entity.setSubState("0");
            commandContext.getEvtAbnormalSubEntityManager().moveToHistory(entity);
        }
    }

    @Override
    protected void persistentRelieve(CommandContext commandContext, EvtAbnormalSubEntity evtAbnormalSubEntity, String relieveType) {
        if (evtAbnormalSubEntity == null || WfUtils.isEmpty(evtAbnormalSubEntity.getDealOption()) || WfUtils.isEmpty(relieveType)) {
            return;
        }
        EvtAbnormalSubEntityManager manager = commandContext.getEvtAbnormalSubEntityManager();
        evtAbnormalSubEntity.setRelieveType(relieveType);
        evtAbnormalSubEntity.setRelieveDate(WfUtils.now());
        evtAbnormalSubEntity.setSubState("2");
        if ("manual".equals(relieveType)) {
            evtAbnormalSubEntity.setRelieverId(RequestContext.get().getCurrUserId());
            evtAbnormalSubEntity.setRelieverName(WfUtils.findUserName(RequestContext.get().getCurrUserId()));
        }
        manager.update(evtAbnormalSubEntity);
        EvtEngineUtils.insertOneTask(commandContext, evtAbnormalSubEntity.getSubscriptionId(), "2");
    }
}

