/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule.calculate.matcher;

import com.tongtech.backport.java.util.Collections;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.bec.engine.devops.rule.calculate.matcher.IRuleMatcher;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;

public class TimeOutRuleMatcher
implements IRuleMatcher {
    @Override
    public String match(EvtRuleEntity evtRuleEntity, Map<String, Object> params) {
        int baseCount;
        if (evtRuleEntity == null || params == null) {
            return "totalTooLess";
        }
        long overtimeDuration = evtRuleEntity.getOvertimeDuration();
        double overtimeRate = evtRuleEntity.getOvertimeRate();
        int overtimeTotal = 0;
        if (params.get("overtimeMap") != null) {
            Map overtimeMap = (Map)params.get("overtimeMap");
            ArrayList<Long> overtimeKeys = new ArrayList<Long>(overtimeMap.size());
            for (Map.Entry overtime : overtimeMap.entrySet()) {
                overtimeKeys.add(Long.parseLong((String)overtime.getKey()));
            }
            Collections.sort(overtimeKeys);
            for (Long overtimeKey : overtimeKeys) {
                if (overtimeDuration > overtimeKey) continue;
                overtimeTotal = (Integer)overtimeMap.get(String.valueOf(overtimeKey));
                break;
            }
        }
        int completedTotal = 0;
        if (params.get("completedtotal") != null) {
            completedTotal = (Integer)params.get("completedtotal");
        }
        if (completedTotal < (baseCount = evtRuleEntity.getBaseCount())) {
            return "totalTooLess";
        }
        return BigDecimal.valueOf(overtimeTotal).divide(BigDecimal.valueOf(completedTotal), 2, 4).compareTo(BigDecimal.valueOf(overtimeRate)) >= 0 ? "success" : "fail";
    }
}

