/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.devops.rule.persistent;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntity;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntityImpl;
import kd.bos.bec.engine.devops.rule.persistent.EvtRuleEntityManager;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;

public class EvtRuleEntityManagerImpl
extends AbstractEntityManager<EvtRuleEntity>
implements EvtRuleEntityManager {
    public EvtRuleEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public String getSelectFields() {
        return "id,number,name,triggertime,explain,scene,errorlevel,dealoption,ispreset,status,priority,param,plugin,shieldsubs,subscriptionid";
    }

    @Override
    public Class<? extends EvtRuleEntity> getManagedEntityClass() {
        return EvtRuleEntityImpl.class;
    }

    @Override
    public String getEntityName() {
        return "evt_rule";
    }

    @Override
    public List<EvtRuleEntity> findRuleByTriggerTime(String triggerTime) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("triggerTime", triggerTime).addFilter("status", "1").orderBy(String.format("%s desc", "priority"));
        return this.findByQueryBuilder(queryBuilder);
    }

    @Override
    public List<Long> findOvertimeDurations() {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("scene", "overtime").setSelectFields("param");
        List rules = this.findByQueryBuilder(queryBuilder);
        ArrayList<Long> result = new ArrayList<Long>(10);
        if (WfUtils.isEmptyForCollection(rules)) {
            return result;
        }
        for (EvtRuleEntity rule : rules) {
            if (result.contains(rule.getOvertimeDuration())) continue;
            result.add(rule.getOvertimeDuration());
        }
        result.sort((a, b) -> a.compareTo((Long)b));
        return result;
    }
}

