/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.eventauxiliary;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kd.bos.bec.engine.eventauxiliary.DefaultEventAuxiliary;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.EventArgs;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.exception.WFErrorCode;

public class EntityEventAuxiliary
extends DefaultEventAuxiliary {
    @Override
    public KDBizEvent createBizEvent(Map<String, Object> payload) {
        String eventNumber = (String)payload.get("eventNumber");
        String entityNumber = (String)payload.get("entityNumber");
        String operation = (String)payload.get("operation");
        List businesskeys = (List)payload.get("businesskeys");
        String srcJson = this.convertToJsonString(eventNumber, entityNumber, businesskeys);
        EntityEvent event = new EntityEvent((Object)srcJson);
        event.setBusinesskeys(businesskeys);
        event.setEntityNumber(entityNumber);
        event.setEventNumber(eventNumber);
        event.setOperation(operation);
        return event;
    }

    @Override
    public KDBizEvent createBizEvent(Map<String, Object> payload, List<String> businesskeys, String json) {
        String eventNumber = (String)payload.get("eventNumber");
        String entityNumber = (String)payload.get("entityNumber");
        String operation = (String)payload.get("operation");
        String srcJson = this.convertToJsonString(eventNumber, entityNumber, businesskeys);
        EntityEvent event = new EntityEvent((Object)srcJson);
        event.setBusinesskeys(businesskeys);
        event.setEntityNumber(entityNumber);
        event.setEventNumber(eventNumber);
        event.setOperation(operation);
        return event;
    }

    public String convertToJsonString(String eventNumber, String entityNumber, List<String> businesskeys) {
        DynamicObject[] bills;
        List<EventArgs> transferEventArgs = this.getTransferEventArgs(eventNumber);
        JSONArray jsonArray = new JSONArray();
        ArrayList<Object> bpks = new ArrayList<Object>(businesskeys.size());
        ISimpleProperty prop = EntityMetadataCache.getDataEntityType((String)entityNumber).getPrimaryKey();
        if (prop instanceof LongProp) {
            for (String itm : businesskeys) {
                bpks.add(Long.valueOf(itm));
            }
        } else {
            for (String itm : businesskeys) {
                bpks.add(String.valueOf(itm));
            }
        }
        for (DynamicObject obj : bills = BusinessDataServiceHelper.load((Object[])bpks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber))) {
            JSONObject objJson = new JSONObject();
            for (EventArgs e : transferEventArgs) {
                String number = e.getConfignumber();
                LinkedList<String> queue = new LinkedList<String>();
                for (String s : number.split("\\.")) {
                    queue.offer(s);
                }
                this.convertItem(objJson, queue, obj);
            }
            if (objJson.isEmpty()) continue;
            objJson.put("businesskey", obj.getPkValue());
            jsonArray.add((Object)objJson);
        }
        return jsonArray.toJSONString();
    }

    private void convertItem(JSONObject base, Queue<String> structures, DynamicObject obj) {
        String key = structures.poll();
        Object result = obj.get(key);
        if (result instanceof DynamicObjectCollection) {
            if (structures.isEmpty()) {
                base.put(key, JSON.parse((String)SerializationUtils.toJsonString((Object)result)));
            } else {
                JSONArray nextBase = base.getJSONArray(key);
                if (nextBase == null) {
                    nextBase = new JSONArray();
                    base.put(key, (Object)nextBase);
                }
                DynamicObjectCollection col = (DynamicObjectCollection)result;
                for (int i = 0; i < col.size(); ++i) {
                    JSONObject jsonItem;
                    LinkedList<String> queue = new LinkedList<String>(structures);
                    if (i > nextBase.size() - 1) {
                        jsonItem = new JSONObject();
                        nextBase.add((Object)jsonItem);
                    } else {
                        jsonItem = nextBase.getJSONObject(i);
                    }
                    this.convertItem(jsonItem, queue, (DynamicObject)col.get(i));
                }
            }
        } else if (result instanceof DynamicObject) {
            if (structures.isEmpty()) {
                base.put(key, JSON.parse((String)SerializationUtils.toJsonString((Object)result)));
            } else {
                JSONObject nextBase = base.getJSONObject(key);
                nextBase = nextBase == null ? new JSONObject() : nextBase;
                this.convertItem(nextBase, structures, (DynamicObject)result);
            }
        } else {
            if (!structures.isEmpty()) {
                throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u679c\u7c7b\u578b\u201c%1$s\u201d\u65e0\u6cd5\u83b7\u53d6\u503c\u201c%2$s\u201d\u3002", (String)"EntityEventAuxiliary_0", (String)"bos-wf-engine", (Object[])new Object[0]), result.getClass(), structures)});
            }
            base.put(key, result);
        }
    }

    @Override
    public VariableScope getVariableScope(Map<String, Object> payload) {
        String entityNumber = (String)payload.get("entityNumber");
        List businesskeys = (List)payload.get("businesskeys");
        if (businesskeys.size() == 1) {
            return new BusinessModelVariableScope((String)businesskeys.get(0), entityNumber);
        }
        return null;
    }

    @Override
    public String getEventBizKey(Map<String, Object> payload) {
        String eventNumber = (String)payload.get("eventNumber");
        String entityNumber = (String)payload.get("entityNumber");
        String operation = (String)payload.get("operation");
        List businesskeys = (List)payload.get("businesskeys");
        if (businesskeys != null && businesskeys.size() == 1) {
            String businesskey = (String)businesskeys.get(0);
            return String.format("%s=%s.%s.%s", eventNumber, entityNumber, businesskey.hashCode(), operation);
        }
        return String.format("%s=%s.%s", eventNumber, entityNumber, operation);
    }
}

