/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.eventauxiliary;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.bec.engine.eventauxiliary.DefaultEventAuxiliary;
import kd.bos.bec.model.EventArgs;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.exception.WFErrorCode;

public class JsonEventAuxiliary
extends DefaultEventAuxiliary {
    @Override
    public KDBizEvent createBizEvent(Map<String, Object> payload) {
        String jsonStr = (String)payload.get("json");
        String eventNumber = (String)payload.get("eventNumber");
        String source = this.convertToJsonString(eventNumber, jsonStr);
        JsonEvent event = new JsonEvent((Object)source);
        event.setEventNumber(eventNumber);
        return event;
    }

    @Override
    public KDBizEvent createBizEvent(Map<String, Object> payload, List<String> businesskeys, String json) {
        String eventNumber = (String)payload.get("eventNumber");
        String source = this.convertToJsonString(eventNumber, json);
        JsonEvent event = new JsonEvent((Object)source);
        event.setEventNumber(eventNumber);
        return event;
    }

    public String convertToJsonString(String eventNumber, String jsonStr) {
        List<EventArgs> transferEventArgs = this.getTransferEventArgs(eventNumber);
        Object json = JSON.parse((String)jsonStr);
        JSONArray jsonArray = new JSONArray();
        if (json instanceof JSONArray) {
            JSONArray srcJsonArray = (JSONArray)json;
            for (int i = 0; i < srcJsonArray.size(); ++i) {
                JSONObject objJson = new JSONObject();
                for (EventArgs e : transferEventArgs) {
                    String number = e.getConfignumber();
                    LinkedList<String> queue = new LinkedList<String>();
                    for (String s : number.split("\\.")) {
                        queue.offer(s);
                    }
                    this.convertItem(objJson, queue, srcJsonArray.getJSONObject(i));
                }
                jsonArray.add((Object)objJson);
            }
        } else if (json instanceof JSONObject) {
            JSONObject objJson = new JSONObject();
            for (EventArgs e : transferEventArgs) {
                String number = e.getConfignumber();
                LinkedList<String> queue = new LinkedList<String>();
                for (String s : number.split("\\.")) {
                    queue.offer(s);
                }
                this.convertItem(objJson, queue, (JSONObject)json);
            }
            jsonArray.add((Object)objJson);
        }
        return jsonArray.toJSONString();
    }

    private void convertItem(JSONObject base, Queue<String> structures, JSONObject srcJson) {
        String key = structures.poll();
        Object result = srcJson.get((Object)key);
        if (structures.isEmpty()) {
            base.put(key, result);
        } else if (result instanceof JSONObject) {
            JSONObject nextBase = base.getJSONObject(key);
            if (nextBase == null) {
                nextBase = new JSONObject();
                base.put(key, (Object)nextBase);
            }
            this.convertItem(nextBase, structures, (JSONObject)result);
        } else if (result instanceof JSONArray) {
            JSONArray resultArray = srcJson.getJSONArray(key);
            if (resultArray == null) {
                resultArray = new JSONArray();
                base.put(key, (Object)resultArray);
            }
            JSONArray srcJa = (JSONArray)result;
            for (int i = 0; i < srcJa.size(); ++i) {
                JSONObject nextBase;
                LinkedList<String> queue = new LinkedList<String>(structures);
                if (i > resultArray.size() - 1) {
                    nextBase = new JSONObject();
                    resultArray.add((Object)nextBase);
                } else {
                    nextBase = resultArray.getJSONObject(i);
                }
                this.convertItem(nextBase, queue, srcJa.getJSONObject(i));
            }
        } else {
            throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u679c\u7c7b\u578b\u201c%1$s\u201d\u65e0\u6cd5\u5411\u4e0b\u83b7\u53d6\u503c%2$s\u3002", (String)"JsonEventAuxiliary_0", (String)"bos-wf-engine", (Object[])new Object[0]), result.getClass(), structures)});
        }
    }

    @Override
    public VariableScope getVariableScope(Map<String, Object> payload) {
        String json = (String)payload.get("json");
        return new EventModelVariableScope(json);
    }

    @Override
    public String getEventBizKey(Map<String, Object> payload) {
        String eventNumber = (String)payload.get("eventNumber");
        return String.format("custom=%s", eventNumber);
    }
}

