/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.impl.jobexecutor;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.EvtConfigurationUtil;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.cmd.job.MoveEvtJobToDeadLetterJobCmd;
import kd.bos.bec.engine.impl.jobexecutor.QueueTypeEnum;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFEngineException;

public class EvtJobUtil {
    private static Log log = LogFactory.getLog(EvtJobUtil.class);
    private static final String SLOW = "slow";
    private static final String URGENT = "urgent";

    public static void handleFailedJob(final ProcessEngineConfigurationImpl processEngineConfiguration, final ExecuteJob job, final Throwable exception) {
        processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                WFEngineException engineException = ExceptionUtil.createContextException(exception, job);
                CommandConfig commandConfig = processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                Command<Object> cmd = commandContext.getFailedJobCommandFactory().getCommand(job, (Throwable)((Object)engineException));
                processEngineConfiguration.getCommandExecutor().execute(commandConfig, cmd);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    try {
                        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, job.getJobHandlerType(), job.getJobHandlerConfiguration(), job, (Throwable)((Object)engineException)));
                    }
                    catch (Exception ignore) {
                        log.warn("Exception occurred while dispatching job failure event, ignoring.", (Throwable)ignore);
                    }
                }
                return null;
            }
        });
    }

    public static void sendMqDirect(List<? extends ExecuteJob> jobs) {
        EvtJobUtil.sendMq(jobs, false);
    }

    public static void sendRetryMqDirect(List<? extends ExecuteJob> jobs) {
        EvtJobUtil.sendMq(jobs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMq(List<? extends ExecuteJob> jobs, boolean isRetry) {
        block15: {
            HashMap<String, MessagePublisher> publisherMap = new HashMap<String, MessagePublisher>();
            try {
                if (!EvtCacheHelper.ifCanSendEventMqDirectly()) {
                    log.info(String.format("\u4e8b\u4ef6\u4e2d\u5fc3\u5b58\u91cfMQ\u5927\u4e8e\u9608\u503c[%s]\u4e0d\u53d1\u9001", EvtConfigurationUtil.getSendEvtMqThreshold()));
                    return;
                }
                boolean ifEvtNeedSubApp = EvtConfigurationUtil.isEvtNeedSubApp();
                int suspendCount = 0;
                for (ExecuteJob executeJob : jobs) {
                    if (executeJob == null) continue;
                    if (EvtConfigurationUtil.ifNeedDownGrade(executeJob.getProcessInstanceId())) {
                        ++suspendCount;
                        continue;
                    }
                    if (EvtJobUtil.suspendJobs(executeJob)) {
                        ++suspendCount;
                        continue;
                    }
                    executeJob.setJobHandlerConfiguration("");
                    String appNumForSubApp = EvtJobUtil.getAppNum(((EvtJobEntity)executeJob).getAppNumForSubApp(), ifEvtNeedSubApp);
                    int type = QueueTypeEnum.ORDINARYSLOW.getCode();
                    if (!isRetry) {
                        type = EvtJobUtil.getQueueConfigVal(executeJob.getProcessInstanceId(), executeJob.getExecutionId(), appNumForSubApp);
                    }
                    ifEvtNeedSubApp = ifEvtNeedSubApp && (type == QueueTypeEnum.SUBAPPURGENT.getCode() || type == QueueTypeEnum.SUBAPPSIMPLE.getCode()) && !"wf".equals(appNumForSubApp);
                    String queueKey = "";
                    queueKey = type == QueueTypeEnum.ORDINARYURGENT.getCode() || type == QueueTypeEnum.SUBAPPURGENT.getCode() && ifEvtNeedSubApp ? "kd.bos.bec.engine.job_queue_urgent" : (type == QueueTypeEnum.ORDINARYSLOW.getCode() || type == QueueTypeEnum.SUBSCRIPTIONSLOW.getCode() ? "kd.bos.bec.engine.job_queue_retry" : "kd.bos.bec.engine.job_queue");
                    String key = QueueTypeEnum.getDescByCode(type);
                    if (ifEvtNeedSubApp) {
                        if (publisherMap.get(key) == null) {
                            publisherMap.put(key, MQFactory.get().createPartitionPublisher("workflow", queueKey, PartitionStrategy.APP_ID));
                        }
                        ((EvtJobEntity)executeJob).setQueueName(appNumForSubApp + "##" + queueKey);
                        ((MessagePublisher)publisherMap.get(key)).publish((Object)executeJob, appNumForSubApp);
                        log.info(String.format("%1$s-%2$s-%3$s-%4$s", key, queueKey, appNumForSubApp, executeJob.getId()));
                        continue;
                    }
                    if (publisherMap.get(key) == null) {
                        publisherMap.put(key, MQFactory.get().createSimplePublisher("workflow", queueKey));
                    }
                    ((EvtJobEntity)executeJob).setQueueName(queueKey);
                    ((MessagePublisher)publisherMap.get(key)).publish((Object)executeJob);
                    log.info(String.format("%1$s-%2$s-%3$s", key, queueKey, executeJob.getId()));
                }
                int realSendCount = jobs.size() - suspendCount;
                if (realSendCount <= 0) break block15;
                EvtJobUtil.collectSendingToMqJobs("becAsyncMessageMinutelySend", realSendCount);
                EvtCacheHelper.incSentEventMqDirectlyDayAmount(realSendCount);
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
            finally {
                for (Map.Entry entry : publisherMap.entrySet()) {
                    MessagePublisher publisher = (MessagePublisher)entry.getValue();
                    if (publisher == null) continue;
                    publisher.close();
                }
            }
        }
    }

    private static String getAppNum(String appNum, boolean ifEvtNeedSubApp) {
        if (!ifEvtNeedSubApp) {
            return "wf";
        }
        if (WfUtils.isEmpty(appNum) || appNum.equalsIgnoreCase("bec") || appNum.equalsIgnoreCase("wfs") || appNum.equalsIgnoreCase("wftask") || appNum.equalsIgnoreCase("bpm")) {
            return "wf";
        }
        String registeredAppIds = System.getProperty("registedAppIds");
        if (StringUtils.isBlank((CharSequence)registeredAppIds)) {
            return "wf";
        }
        List<String> registeredAppIdArray = Arrays.asList(registeredAppIds.split(","));
        if (registeredAppIdArray == null) {
            return "wf";
        }
        return registeredAppIdArray.contains(appNum) ? appNum : "wf";
    }

    private static boolean suspendJobs(ExecuteJob job) {
        if (EvtConfigurationUtil.ifNeedDegrade(((EvtJobEntity)job).getSubscriptionId())) {
            try {
                String info = String.format(ResManager.loadKDString((String)"Job[%s]\u53d1\u9001\u65f6\u88ab\u964d\u7ea7\u5904\u7406\uff0c\u4e0d\u6d88\u8d39\u3002", (String)"BizEventConsumer_10", (String)"bos-wf-engine", (Object[])new Object[0]), job.getId());
                log.info(String.format("Job[%s]\u53d1\u9001\u65f6\u88ab\u964d\u7ea7\u5904\u7406\uff0c\u4e0d\u6d88\u8d39\u3002", job.getId()));
                WFEngineException e = new WFEngineException("", new Exception(info));
                e.setType("handleSuspend");
                ProcessEngineConfigurationImpl pf = Context.getCommandContext().getProcessEngineConfiguration();
                CommandConfig commandConfig = pf.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                pf.getCommandExecutor().execute(commandConfig, new MoveEvtJobToDeadLetterJobCmd((EvtJobEntity)job, (Throwable)((Object)e)));
                return true;
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
                log.info(String.format("Job[%s]\u53d1\u9001\u65f6\u88ab\u964d\u7ea7\u5904\u7406\u65f6\u5931\u8d25\u3002", job.getId()));
                return true;
            }
        }
        return false;
    }

    private static void collectSendingToMqJobs(String captureNumber, int size) {
        if (size < 1) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        String dimValue = format.format(WfUtils.now());
        IndicatorInfo indicatorInfo = new IndicatorInfo(captureNumber, (Object)dimValue, size, true);
        WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
    }

    public static int getQueueConfigVal(Long eventId, Long subscriptionId, String appNumForSubApp) {
        try {
            Map<String, String> evtQueue = EvtCacheHelper.getEvtQueue();
            if (evtQueue == null || evtQueue.isEmpty()) {
                Row row;
                if (evtQueue == null) {
                    evtQueue = new HashMap<String, String>();
                }
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"GetSubscriptionQueueConfig", (String)"evt_abnormalsubs", (String)"subscriptionid", (QFilter[])new QFilter[]{new QFilter("relievedate", "is null", null), new QFilter("dealoption", "in", (Object)new String[]{"isolateSlowqueue", "noRetry"})}, null);){
                    while (ds != null && ds.hasNext()) {
                        row = ds.next();
                        if (!WfUtils.isNotEmpty(row.getString("subscriptionid"))) continue;
                        evtQueue.put(row.getString("subscriptionid"), String.valueOf(QueueTypeEnum.SUBSCRIPTIONSLOW.getCode()));
                    }
                }
                ds = QueryServiceHelper.queryDataSet((String)"GetEventQueueConfig", (String)"evt_queue_config", (String)"id,type,appnum,entryentity,entryentity.event", null, null);
                var5_7 = null;
                try {
                    while (ds != null && ds.hasNext()) {
                        row = ds.next();
                        String type = row.getString("type");
                        String appnum = row.getString("appnum");
                        if (WfUtils.isEmpty(type) || WfUtils.isEmpty(appnum)) continue;
                        String evtId = row.getString("entryentity.event");
                        if (!(appnum.equalsIgnoreCase("wf") || appnum.equalsIgnoreCase("bec") || appnum.equalsIgnoreCase("wfs") || appnum.equalsIgnoreCase("wftask") || appnum.equalsIgnoreCase("bpm"))) {
                            if (!evtQueue.containsKey(appnum)) {
                                evtQueue.put(appnum, String.valueOf(QueueTypeEnum.SUBAPPSIMPLE.getCode()));
                            }
                            if (!URGENT.equals(type) || !WfUtils.isNotEmpty(evtId) || "0".equals(evtId)) continue;
                            evtQueue.put(evtId, String.valueOf(QueueTypeEnum.SUBAPPURGENT.getCode()));
                            continue;
                        }
                        if (WfUtils.isEmpty(evtId) || "0".equals(evtId)) continue;
                        int queue = QueueTypeEnum.ORDINARY.getCode();
                        if (evtQueue.containsKey(evtId)) {
                            queue = Integer.parseInt(evtQueue.get(evtId));
                        }
                        if (SLOW.equals(type)) {
                            evtQueue.put(evtId, String.valueOf(queue >= QueueTypeEnum.ORDINARYSLOW.getCode() ? queue : QueueTypeEnum.ORDINARYSLOW.getCode()));
                            continue;
                        }
                        if (!URGENT.equals(type)) continue;
                        evtQueue.put(evtId, String.valueOf(queue >= QueueTypeEnum.ORDINARYURGENT.getCode() ? queue : QueueTypeEnum.ORDINARYURGENT.getCode()));
                    }
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (var5_7 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                var5_7.addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                if (evtQueue.size() < 1) {
                    evtQueue.put("000", "1000");
                }
                EvtCacheHelper.putEvtQueue(evtQueue);
            }
            if (WfUtils.isNotEmpty(subscriptionId) && evtQueue.containsKey(String.valueOf(subscriptionId))) {
                return Integer.parseInt(evtQueue.get(String.valueOf(subscriptionId)));
            }
            int res = QueueTypeEnum.ORDINARY.getCode();
            if (evtQueue.containsKey(String.valueOf(eventId))) {
                res = Integer.parseInt(evtQueue.get(String.valueOf(eventId)));
            }
            if ("wf".equalsIgnoreCase(appNumForSubApp)) {
                res = res < QueueTypeEnum.ORDINARYURGENT.getCode() ? QueueTypeEnum.ORDINARY.getCode() : res;
            } else if (evtQueue.containsKey(appNumForSubApp)) {
                res = Math.max(res, QueueTypeEnum.SUBAPPSIMPLE.getCode());
            }
            return res;
        }
        catch (Exception e) {
            log.info(String.format("there is error on getQueueConfigVal value,msg is [%s]", e.getMessage()));
            return QueueTypeEnum.ORDINARY.getCode();
        }
    }

    public static boolean subscriptionIsSuspend(CommandContext commandContext, Long subscriptionId) {
        if (WfUtils.isEmpty(subscriptionId)) {
            return false;
        }
        Object[] suspendSubs = EvtCacheHelper.getSuspendSubs();
        if (ArrayUtils.isEmpty((Object[])suspendSubs)) {
            List<Long> suspendSubList = commandContext.getEvtAbnormalSubEntityManager().findAbnormalSubsIdByDealOption("suspendSub");
            if (WfUtils.isEmptyForCollection(suspendSubList)) {
                suspendSubs = new String[]{"000"};
            } else {
                suspendSubs = new String[suspendSubList.size()];
                for (int i = 0; i < suspendSubList.size(); ++i) {
                    suspendSubs[i] = String.valueOf(suspendSubList.get(i));
                }
            }
            EvtCacheHelper.addSuspendSubs((String[])suspendSubs);
        }
        for (Object sub : suspendSubs) {
            if (!((String)sub).equals(String.valueOf(subscriptionId))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotRetryByRule(CommandContext commandContext, Long subscriptionId) {
        if (WfUtils.isEmpty(subscriptionId)) {
            return false;
        }
        String[] noRetrySubs = EvtCacheHelper.getNoRetrySubs();
        if (noRetrySubs == null || noRetrySubs.length == 0) {
            List<Long> noRetrySubList = commandContext.getEvtAbnormalSubEntityManager().findAbnormalSubsIdByDealOption("noRetry");
            if (WfUtils.isEmptyForCollection(noRetrySubList)) {
                noRetrySubs = new String[]{"000"};
            } else {
                noRetrySubs = new String[noRetrySubList.size()];
                for (int i = 0; i < noRetrySubList.size(); ++i) {
                    noRetrySubs[i] = String.valueOf(noRetrySubList.get(i));
                }
            }
            EvtCacheHelper.addNoRetrySubs(noRetrySubs);
        }
        for (String sub : noRetrySubs) {
            if (!sub.equals(String.valueOf(subscriptionId))) continue;
            return true;
        }
        return false;
    }
}

