/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.persistence.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.bec.engine.EvtEngineUtils;
import kd.bos.bec.engine.EvtJobDAO;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.cmd.job.MoveEvtJobToDeadLetterJobCmd;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntityImpl;
import kd.bos.bec.engine.persistence.job.EvtJobEntityManager;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.Page;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchVerifySqlInfo;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class EvtJobEntityManagerImpl
extends AbstractEntityManager<EvtJobEntity>
implements EvtJobEntityManager {
    public EvtJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public String getEntityName() {
        return "evt_job";
    }

    @Override
    public Class<? extends EvtJobEntity> getManagedEntityClass() {
        return EvtJobEntityImpl.class;
    }

    @Override
    public String getSelectFields() {
        return "id,jobType,lockExpirationTime,exclusive,lockOwnerId,executionid,processinstanceid,processdefinitionid,retries,entityNumber,businessKey,operation,exceptionmessage,duedate,repeat,jobhandlertype,jobhandlerconfiguration,createdate,modifydate,elementid,srcjobid,rootTraceNo,executor,success,endTime,duration,state,source,rootJobId,srcTraceId,bizKey,rootEventInstId";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EvtJobEntity> findEvtJobsToExecute(Page page) {
        String sharingId = EvtCacheHelper.getSharingIdOfDbRouteKey(DBRoute.workflow.getRouteKey());
        if (sharingId != null && !EvtEngineUtils.checkIfContinue(sharingId)) {
            return Collections.emptyList();
        }
        ArrayList<EvtJobEntity> result = new ArrayList<EvtJobEntity>();
        Date now = this.getClock().getCurrentTime();
        Object val = WfConfigurationUtil.getConfigCenterVal("acquireStepBec");
        Object countVal = WfConfigurationUtil.getConfigCenterVal("acquireCountBec");
        int step = 3;
        int count = 50;
        try {
            if (val != null) {
                step = Integer.parseInt(String.valueOf(val));
            }
            if (countVal != null) {
                count = Integer.parseInt(String.valueOf(countVal));
            }
        }
        catch (Exception e) {
            this.logger.warn("val\u5728\u7c7b\u578b\u8f6c\u6362\u65f6\u51fa\u9519\uff01\u539f\u56e0\uff1a%s" + e.getMessage());
        }
        Date startTime = new Date(now.getTime() - (long)step * 24L * 60L * 60L * 1000L);
        ArrayList<String> param = new ArrayList<String>();
        param.add(JobStateEnum.CREATED.getNumber());
        param.add(JobStateEnum.PREEXECUTING.getNumber());
        param.add(JobStateEnum.EXECUTING.getNumber());
        QFilter lockTimeLargeFilter = new QFilter("lockExpirationTime", ">=", (Object)startTime);
        QFilter lockTimeLessFilter = new QFilter("lockExpirationTime", "<=", (Object)now);
        QFilter stateFilter = new QFilter("state", "in", param);
        QFilter[] filters = new QFilter[]{lockTimeLargeFilter, lockTimeLessFilter, stateFilter};
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"evt_job", (String)this.getSelectFields(), (QFilter[])filters, (String)"lockExpirationTime asc", (int)count);
        ArrayList ret = new ArrayList(dys.length);
        if (dys != null && dys.length > 0) {
            for (DynamicObject t : dys) {
                ret.add(this.create(t));
            }
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List services = WfCommonUtil.getServiceNodes();
        if (!ret.isEmpty()) {
            for (EvtJobEntity entity : ret) {
                if (WfUtils.isEmpty(entity.getId())) continue;
                if (WfCacheHelper.isCurrentExecutingJob(entity.getRootJobId())) {
                    this.logger.debug(String.format("job[%s] \u6b63\u5728\u88ab\u6267\u884c,\u8fd9\u4e48\u7f55\u89c1\u7684\u60c5\u51b5\u90fd\u88ab\u4f60\u9047\u5230\u4e86\uff0c\u5728\u6267\u884c\u6d88\u606f\u7684\u8fc7\u7a0b\u4e2d\uff0c\u670d\u52a1\u505c\u6b62\u4e86\uff0c\u6b64\u65f6job\u88ab\u9501\u5b9a\uff0c\u6807\u5fd7\u65e0\u6cd5\u89e3\u9664\uff0c\u53ea\u80fd\u624b\u5de5\u5904\u7406\u4e86\u3002", entity.getId()));
                    continue;
                }
                if ((JobStateEnum.PREEXECUTING.getNumber().equals(entity.getState()) || JobStateEnum.EXECUTING.getNumber().equals(entity.getState())) && EvtUtils.checkJobExecutorAlive(entity, services)) continue;
                try {
                    JSONObject jsonObject;
                    if (entity.getCreateDate() != null && new Date(WfUtils.now().getTime() - 86400000L).after(entity.getCreateDate())) {
                        String markId = String.format("wf/movetodeadjob/%s", entity.getId());
                        boolean flag = false;
                        try {
                            if (WfCacheHelper.putCurrentExecuteBySceneAndKey(markId) <= 0) continue;
                            flag = true;
                            WFEngineException e = new WFEngineException(new RuntimeException(ResManager.loadKDString((String)"\u5e95\u5c42\u7ec4\u4ef6\u5f02\u5e38", (String)"EvtJobEntityManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.jobUnKnowError(), new Object[0]);
                            new MoveEvtJobToDeadLetterJobCmd(entity, (Throwable)((Object)e)).execute(Context.getCommandContext());
                            continue;
                        }
                        finally {
                            if (flag) {
                                WfCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
                            }
                            continue;
                        }
                    }
                    JobUtil.setJobLockProperty(entity, this.processEngineConfiguration, this.getAsyncExecutor());
                    if (JobStateEnum.EXECUTING.getNumber().equalsIgnoreCase(entity.getState())) {
                        entity.setState(JobStateEnum.PREEXECUTING.getNumber());
                    }
                    if ((jsonObject = JSON.parseObject((String)entity.getJobHandlerConfiguration())) != null) {
                        String appNumForSubApp = jsonObject.getString("appNumForSubApp");
                        this.logger.debug(String.format("findExpiredJobs--Id[%s]--AppId--[%s]", entity.getId(), appNumForSubApp));
                        entity.setAppNumForSubApp(appNumForSubApp);
                    }
                    params.add(new Object[]{entity.getLockExpirationTime(), entity.getLockOwnerId(), entity.getRetries(), entity.getState(), entity.getId()});
                    result.add(entity);
                }
                catch (Exception e) {
                    this.logger.warn(String.format("job[%s] occurs error when acquiring query in wfs job, error msg is [%s]", entity.getId(), e.getMessage()));
                }
            }
            if (!params.isEmpty()) {
                EvtJobDAO jobDao = (EvtJobDAO)TypesContainer.getOrRegisterSingletonInstance((String)EvtJobDAO.class.getName());
                jobDao.update(DBRoute.workflow.getRouteKey(), params);
            }
        }
        EvtCacheHelper.removeAcquireEvtJobId(sharingId);
        if (result != null) {
            if (result.size() == 1) {
                EvtCacheHelper.putAcquireEvtJobId(sharingId, new String[]{((EvtJobEntity)result.get(0)).getId().toString()});
            } else if (result.size() > 1) {
                EvtCacheHelper.putAcquireEvtJobId(sharingId, new String[]{((EvtJobEntity)result.get(0)).getId().toString(), ((EvtJobEntity)result.get(result.size() - 1)).getId().toString()});
            }
        }
        return result;
    }

    @Override
    public boolean insertJobEntity(EvtJobEntity job) {
        return this.doInsert(job, true);
    }

    @Override
    public void insert(EvtJobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(EvtJobEntity jobEntity, boolean fireCreateEvent) {
        super.insert(jobEntity, fireCreateEvent);
        if (WfUtils.isEmpty(jobEntity.getRootJobId())) {
            jobEntity.setRootJobId(jobEntity.getId());
        }
        return true;
    }

    @Override
    public EvtJobEntity findByTraceId(String srcTraceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("rootTraceNo", "=", srcTraceId).addFilter("executionid", "!=", 0).setLimit(1);
        List ret = this.findByQueryBuilder(eb, false);
        if (!ret.isEmpty()) {
            return (EvtJobEntity)ret.get(0);
        }
        EvtJobEntity retHis = Context.getCommandContext().getEvtHiJobEntityManager().findHiJobByTraceId(srcTraceId);
        if (retHis != null) {
            return retHis;
        }
        return null;
    }

    @Override
    public List<EvtJobEntity> findByRootEvtInstIds(Long firstEvtInstId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("rootEventInstId", "=", firstEvtInstId);
        List<EvtJobEntity> res = this.findByQueryBuilder(eb, false);
        List<EvtJobEntity> resHis = Context.getCommandContext().getEvtHiJobEntityManager().findHiJobByRootEvtInstIds(firstEvtInstId);
        if (res == null || res.size() < 1) {
            return resHis;
        }
        if (resHis == null || resHis.size() < 1) {
            return res;
        }
        res.addAll(resHis);
        return res;
    }

    @Override
    public EvtJobEntity findBothJobById(Long jobId) {
        EvtJobEntity job = (EvtJobEntity)this.findById(jobId);
        if (job == null) {
            job = (EvtJobEntity)Context.getCommandContext().getEvtHiJobEntityManager().findById(jobId);
        }
        return job;
    }

    @Override
    public void saveOrUpdateByVerifySql(ExecuteJob job, boolean ifWillInsert) {
        String sql = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        if (ifWillInsert) {
            sql = "insert into t_evt_jobrecord(fid, ftype, flockexptime, flockownerid, fexclusive, fexecutionid, fprocessinstanceid, fprocdefid, fretries, fduedate, frepeat, fhandlertype, fbusinesskey, foperation, fentitynumber, felementid, fcreatedate, fmodifydate, fsrcjobid, froottraceno, fexecutor, fsuccess, fendtime, fduration, fstate, fsource, frootjobid, fexceptionmsg, fhandlercfg, frooteventinstid, fsrctraceid,fbizkey)select ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? where not exists (select 1 from t_evt_jobrecord where fid = ?) and not exists (select 1 from t_evt_deadletterjob where fid = ?)";
            params.add(new Object[]{job.getId(), this.defultString(job.getJobType()), job.getLockExpirationTime(), this.defultString(job.getLockOwnerId()), Character.valueOf(job.isExclusive() ? (char)'1' : '0'), this.defultLong(job.getExecutionId()), this.defultLong(job.getProcessInstanceId()), this.defultLong(job.getProcessDefinitionId()), job.getRetries(), job.getDuedate(), this.defultString(job.getRepeat()), this.defultString(job.getJobHandlerType()), this.defultString(job.getBusinessKey()), this.defultString(job.getOperation()), this.defultString(job.getEntityNumber()), this.defultString(job.getElementId()), job.getCreateDate(), job.getModifyDate(), this.defultLong(job.getSrcJobId()), this.defultString(job.getRootTraceNo()), this.defultString(job.getExecutor()), Character.valueOf(job.isSuccess() ? (char)'1' : '0'), Context.getProcessEngineConfiguration().getClock().getCurrentTime(), this.defultLong(job.getDuration()), this.defultString(job.getState()), this.defultString(job.getSource()), this.defultLong(((EvtJobEntity)job).getRootJobId()), this.defultString(job.getExceptionMessage()), this.defultString(job.getJobHandlerConfiguration()), this.defultLong(((EvtJobEntity)job).getRootEventInstId()), this.defultString(((EvtJobEntity)job).getSrcTraceId()), this.defultString(((EvtJobEntity)job).getBizKey()), job.getId(), job.getId()});
        } else {
            sql = "update t_evt_jobrecord set fstate = ?,fexceptionmsg = ?,fendtime = ?,fduration = ?,fexclusive = ?,fbizkey = ?,fretries = ?,frooteventinstid = ?,fsuccess = ? where fid = ? and fstate in ('created','received','executing')";
            params.add(new Object[]{this.defultString(job.getState()), this.defultString(job.getExceptionMessage()), Context.getProcessEngineConfiguration().getClock().getCurrentTime(), this.defultLong(job.getDuration()), Character.valueOf(job.isExclusive() ? (char)'1' : '0'), this.defultString(((EvtJobEntity)job).getBizKey()), job.getRetries(), this.defultLong(((EvtJobEntity)job).getRootEventInstId()), Character.valueOf(job.isSuccess() ? (char)'1' : '0'), job.getId()});
        }
        this.getDbSqlSession().addVerifySqlInfos(new BatchVerifySqlInfo(sql, params, 1, !ifWillInsert, job.getClass(), job.getId()));
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, job));
        }
    }

    private Long defultLong(Long inputLong) {
        if (inputLong == null) {
            return 0L;
        }
        return inputLong;
    }

    private String defultString(String inputString) {
        if (inputString == null) {
            return " ";
        }
        return inputString;
    }
}

