/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.exception.EVTIgnoreRetryException;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.EventParticipantCalculatorUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.exception.WFErrorCode;

public abstract class AbstractEventServiceJobHandler
extends AbstractJobHandler {
    protected static Log logger = LogFactory.getLog(AbstractEventServiceJobHandler.class);
    public static final String SERVICEID = "serviceId";
    public static final String EVENTID = "eventId";
    public static final String EXPRESSION = "expression";
    public static final String SUBSCRIPTIONNUMBER = "subscriptionNumber";
    public static final String SUBSCRIPTIONID = "subscriptionId";
    public static final String SUBSCRIPTIONCONFIG = "subscriptionConfig";
    public static final String SERVICENUMBER = "serviceNumber";
    public static final String SERVICEIMPL = "serviceImpl";
    public static final String ERRORNOTIFY = "errorNotify";
    public static final String ERRORSTRATEGY = "errorStrategy";
    public static final String EXECUTORVALUE = "executorvalue";
    public static final String SERVICE = "service";

    @Override
    public String getType() {
        return null;
    }

    public String getName() {
        return "execute event operation service";
    }

    public EventDispatchContext restoreEventContext(String configuration) {
        EventDispatchContext context = new EventDispatchContext();
        if (WfUtils.isNotEmpty(configuration)) {
            context = new EventDispatchContext();
            Map tmp = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
            context.set_requestContext_((Map)tmp.get("_requestContext_"));
            context.setJson((String)tmp.get("json"));
            context.setSubscriptionId((Long)tmp.get(SUBSCRIPTIONID));
            context.setSubscriptionConfig(this.getStringVal(tmp.get(SUBSCRIPTIONCONFIG)));
            context.setSubscriptionNumber(this.getStringVal(tmp.get(SUBSCRIPTIONNUMBER)));
            context.setServiceId((Long)tmp.get(SERVICEID));
            context.setServiceNumber(this.getStringVal(tmp.get(SERVICENUMBER)));
            context.setErrorNotify(String.valueOf(tmp.get(ERRORNOTIFY)));
            context.setErrorStrategy(String.valueOf(tmp.get(ERRORSTRATEGY)));
            context.setExecutorvalue(String.valueOf(tmp.get(EXECUTORVALUE)));
            context.setEventBizkeyLine(String.valueOf(tmp.get("eventBizkeyLine")));
            Map eventMap = (Map)tmp.get("event");
            if (eventMap != null) {
                String entityNumber = this.getStringVal(eventMap.get("entityNumber"));
                List businesskeys = (List)eventMap.get("businesskeys");
                Object source = eventMap.get("source");
                Object variables = eventMap.get("variables");
                Long eventId = (Long)eventMap.get(EVENTID);
                String eventNumber = this.getStringVal(eventMap.get("eventNumber"));
                if (WfUtils.isNotEmpty(entityNumber)) {
                    EntityEvent event = new EntityEvent((Object)String.valueOf(source));
                    event.setEntityNumber(entityNumber);
                    event.setBusinesskeys(businesskeys);
                    event.setOperation(this.getStringVal(eventMap.get("operation")));
                    event.setEventId(eventId);
                    event.setEventNumber(eventNumber);
                    if (variables != null) {
                        event.setVariables(String.valueOf(variables));
                    }
                    context.setEvent((KDBizEvent)event);
                } else {
                    JsonEvent event = new JsonEvent((Object)String.valueOf(source));
                    event.setEventId(eventId);
                    event.setEventNumber(eventNumber);
                    if (variables != null) {
                        event.setVariables(String.valueOf(variables));
                    }
                    context.setEvent((KDBizEvent)event);
                }
            }
        }
        return AbstractEventServiceJobHandler.rebuildConfiguration(context);
    }

    public void changeContext(String configuration, EventDispatchContext edContext) {
        Long participant;
        String executorvalue;
        String receiver = executorvalue = edContext.getExecutorvalue();
        KDBizEvent event = edContext.getEvent();
        ArrayList<String> businesskeys = new ArrayList();
        String entityNumber = "";
        if (event instanceof EntityEvent) {
            EntityEvent entityEvent = (EntityEvent)event;
            entityNumber = entityEvent.getEntityNumber();
            businesskeys = entityEvent.getBusinesskeys();
        } else {
            Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
            String json = (String)payload.get("json");
            this.buildBusinesskeys(json, businesskeys);
        }
        Map<String, List<Long>> participantMap = EventParticipantCalculatorUtil.participantCalculator(receiver, event, businesskeys, entityNumber, edContext);
        List<Long> participantList = participantMap.get(businesskeys.get(0));
        if (participantList != null && !participantList.isEmpty()) {
            participant = participantList.get(0);
            ArrayList<Long> userEnable = new ArrayList<Long>();
            userEnable.add(participant);
            if (!((Boolean)UserServiceHelper.isUserEnable(userEnable).get(participant)).booleanValue()) {
                throw new KDException(new ErrorCode("bos.wf.Event.AbstractEventServiceJobHandler.error", ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u4eba\u89e3\u6790\u5931\u8d25\u3002", (String)"AbstractEventServiceJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0])), new Object[]{configuration});
            }
        }
        if (participantList != null && !participantList.isEmpty()) {
            participant = participantList.get(0);
            Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
            Map context = (Map)payload.get("_requestContext_");
            context.put("userId", participant.toString());
            payload.put("_requestContext_", context);
            JSONObject json = new JSONObject(payload);
            WfUtils.restoreRequestContext(json.toString());
        }
    }

    public static EventDispatchContext rebuildConfiguration(EventDispatchContext edContext) {
        StringBuilder sbs = new StringBuilder();
        sbs.append("SELECT ").append("fid, ").append("fnumber, ").append("fserviceconfig, ").append("ferrorstrategy, ").append("ferrornotify, ").append("fexecutorvalue, ").append("fservice ").append("from ").append("t_evt_subscription ").append("where fid = ? ");
        boolean flag = true;
        try (DataSet ds = DB.queryDataSet((String)"be.subscription", (DBRoute)DBRoute.workflow, (String)sbs.toString(), (Object[])new Object[]{edContext.getSubscriptionId()});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                flag = false;
                edContext.setSubscriptionId(row.getLong("fid"));
                edContext.setSubscriptionConfig((String)row.get("fserviceconfig"));
                edContext.setSubscriptionNumber((String)row.get("fnumber"));
                edContext.setErrorNotify((String)row.get("ferrornotify"));
                edContext.setExecutorvalue((String)row.get("fexecutorvalue"));
                edContext.setErrorStrategy((String)row.get("ferrorstrategy"));
            }
        }
        if (flag) {
            throw new EVTIgnoreRetryException(new KDBizException(ResManager.loadKDString((String)"\u8ba2\u9605\u65e0\u6548\uff0c\u53ef\u80fd\u5df2\u7ecf\u7981\u7528\u6216\u5220\u9664\u3002", (String)"AbstractEventServiceJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0])), WFErrorCode.bizEventError(), ResManager.loadKDString((String)"\u8ba2\u9605\u65e0\u6548\uff0c\u53ef\u80fd\u5df2\u7ecf\u7981\u7528\u6216\u5220\u9664\u3002", (String)"AbstractEventServiceJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return edContext;
    }

    public void transferEvtLine(EvtJobEntity job, CommandContext commandContext, StringBuilder sb, EventDispatchContext edContext) {
        String eventBizKeyLine = edContext.getEventBizkeyLine();
        sb.append(String.format(ResManager.loadKDString((String)"\u8ba2\u9605\u65e0\u6548\uff0c\u53ef\u80fd\u5df2\u7ecf\u7981\u7528\u6216\u5220\u9664\u3002", (String)"AbstractEventServiceJobHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]), job.getId()));
        if (WfUtils.isNotEmpty(eventBizKeyLine)) {
            String traceId = RequestContext.get().getTraceId();
            sb.append(String.format(ResManager.loadKDString((String)"%1$s,\u5e76\u8bbe\u7f6etrace[%2$s]\u7684\u4e8b\u4ef6\u94fe\u8def\u4e3a[%3$s]", (String)"AbstractEventServiceJobHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]), eventBizKeyLine, traceId, eventBizKeyLine));
        } else {
            sb.append("null or empty\u3002");
        }
    }

    protected static void setOperationParams(String configuration, OperateOption options) {
        try {
            if (configuration == null) {
                return;
            }
            Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
            Map event = (Map)payload.get("event");
            String operationParams = null;
            if (event != null && (operationParams = (String)event.get("variables")) == null) {
                return;
            }
            Map paramMap = (Map)SerializationUtils.fromJsonString(operationParams, Map.class);
            if (paramMap != null) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    options.setVariableValue((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (Exception se) {
            logger.info("\u64cd\u4f5c\u53c2\u6570\u89e3\u6790\u5931\u8d25\u3002");
        }
    }
}

