/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.EvtLogUtils;
import kd.bos.bec.engine.asyncexecutor.EvtJobManager;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.eventauxiliary.EventAuxiliaryFactory;
import kd.bos.bec.engine.eventauxiliary.IEventAuxiliary;
import kd.bos.bec.engine.impl.jobexecutor.EvtJobUtil;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntityManager;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.log.entity.EventLogEsEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.WFConditionParseException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class EventDispatchJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-event-dispatch";
    public static final String SERVICEID = "serviceId";
    public static final String EVENTID = "eventId";
    public static final String EXPRESSION = "expression";
    public static final String SUBSCRIPTIONNUMBER = "subscriptionNumber";
    public static final String SUBSCRIPTIONID = "subscriptionId";
    public static final String SUBSCRIPTIONCONFIG = "subscriptionConfig";
    public static final String SERVICENUMBER = "serviceNumber";
    public static final String SERVICEIMPL = "serviceImpl";
    public static final String ERRORNOTIFY = "errorNotify";
    public static final String ERRORSTRATEGY = "errorStrategy";
    public static final String EXECUTORVALUE = "executorvalue";
    public static final String ERROR_EVENTSHOWERERROR = "eventShowerError";
    private static final List<String> MESSAGE_EVENTS = Arrays.asList("wf.AfterCreateMessageEvent", "wf.AfterChangeMessageStateEvent", "wf.AfterDeleteMessageEvent");
    public static final String EVENTSOURCE = "eventSource";
    public static final String EVENTENTITY = "eventEntity";
    public static final String APPID = "appId";
    public static final String OPERATEPARAMSCONF = "operateparamsconf";
    public static final String OPTYPE = "optype";
    public static final String INNERSERVICE = "innerService";
    public static final String EVENTSPLITCONF = "eventSplitConfig";
    public static final String EXECUTIONSTRATEGY = "executionStrategy";
    public static final String SPLITSIZE = "splitsize";
    public static final String SPLITSIZE_REGULAR = "^([1-9][0-9]{0,2}|1000)$";
    private static final String BUSINESSKEY = "businesskey";
    public static final String SPLITTYPE = "splittype";
    public static final String SPLITWORD = "splitword";
    public static final String SUBSCRIPAPPID = "subscripAppId";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        long begin;
        EventLogEsEntityImpl evtLog;
        StringBuilder sb;
        block20: {
            List<Map<String, Object>> subscriptions;
            String eventBizKeyLineInfo;
            IEventAuxiliary eventAuxiliary;
            Map<String, Object> payload;
            block19: {
                sb = new StringBuilder();
                evtLog = null;
                begin = System.currentTimeMillis();
                evtLog = EventLogEsEntityImpl.create();
                evtLog.setScene("dispatchEventJob");
                evtLog.setJobid(job.getId());
                evtLog.setEntitynumber(job.getEntityNumber());
                evtLog.setBusinesskey(job.getBusinessKey());
                evtLog.setEventid(job.getProcessInstanceId());
                payload = this.restoreContext(configuration);
                String evtNumber = (String)payload.get("eventNumber");
                evtLog.setEventnumber(evtNumber);
                sb.append(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4e8b\u4ef6[%s]job\u5206\u6790\u4e0e\u5206\u53d1:", (String)"EventDispatchJobHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]), evtNumber));
                String eventType = (String)payload.get("eventType");
                eventAuxiliary = EventAuxiliaryFactory.getEventAuxiliary(eventType);
                String eventBizKey = job.getBizKey();
                if (WfUtils.isEmpty(eventBizKey)) {
                    sb.append(String.format("job%s bizKey,", job.getId()));
                    eventBizKey = eventAuxiliary.getEventBizKey(payload);
                    job.setBizKey(eventBizKey);
                }
                List<Object> eventBizKeyLine = new ArrayList(16);
                eventBizKeyLineInfo = "";
                try {
                    eventBizKeyLine = this.fixJobAndDealEvtCycle(job, sb, commandContext.getEvtJobEntityManager());
                    eventBizKeyLineInfo = WfUtils.listToString(eventBizKeyLine, ",");
                }
                catch (KDException e) {
                    if (!e.getErrorCode().getCode().equals(ERROR_EVENTSHOWERERROR)) {
                        throw e;
                    }
                    long end = System.currentTimeMillis();
                    sb.append(String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventDispatchJobHandler_24", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                    if (evtLog != null) {
                        evtLog.setContent(sb.toString());
                        EvtLogUtils.saveEvtLog(evtLog);
                    }
                    return;
                }
                subscriptions = this.getSubscriptions(evtNumber);
                if (!subscriptions.isEmpty()) break block19;
                this.log.debug("\u6d88\u8d39\u5206\u53d1job\u65f6\u8ba2\u9605\u4e3a\u7a7a\uff0c\u4f46\u662f\u4e00\u822c\u4e0d\u4f1a\u5230\u8fd9\u91cc\uff0c\u5728\u521b\u5efa\u5206\u53d1job\u7684\u65f6\u5019\u5df2\u7ecf\u5224\u65ad\u5b58\u5728\u6027\u4e86\u3002");
                long end = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventDispatchJobHandler_24", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                if (evtLog != null) {
                    evtLog.setContent(sb.toString());
                    EvtLogUtils.saveEvtLog(evtLog);
                }
                return;
            }
            try {
                sb.append(String.format(ResManager.loadKDString((String)"\u627e\u5230\u8ba2\u9605%d\u4e2a\uff1b", (String)"EventDispatchJobHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]), subscriptions.size()));
                KDBizEvent event = null;
                Long evtId = Long.valueOf(subscriptions.get(0).get(EVENTID).toString());
                VariableScope variableScope = eventAuxiliary.getVariableScope(payload);
                ArrayList<EvtJobEntity> evtJobs = new ArrayList<EvtJobEntity>();
                String json = (String)payload.get("json");
                for (Map<String, Object> subscription : subscriptions) {
                    List<EvtJobEntity> jobs;
                    boolean meetCondition;
                    String expression = (String)subscription.get(EXPRESSION);
                    sb.append(String.format(ResManager.loadKDString((String)"%1$s\u5224\u65ad\u8ba2\u9605\u3010%2$s\u3011\u6761\u4ef6\u3010%3$s\u3011", (String)"EventDispatchJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0]), "\r\n", subscription.get(SUBSCRIPTIONNUMBER), expression));
                    boolean bl = meetCondition = variableScope == null || WfUtils.isEmpty(expression);
                    if (!meetCondition && !this.ifHashCondition(expression, variableScope, sb)) continue;
                    JSONObject jsonObject = this.getSubscriptionJson(subscription);
                    Map<String, String> appMap = this.getAppNumAndId(subscription, jsonObject);
                    subscription.put("eventBizKeyLineInfo", eventBizKeyLineInfo);
                    if (jsonObject != null) {
                        subscription.put("jsonObject", jsonObject);
                    }
                    if (appMap != null) {
                        subscription.put("appMap", appMap);
                    }
                    if ((jobs = this.createEvtJobs(job, eventAuxiliary, subscription, json, sb, payload)) != null && !jobs.isEmpty()) {
                        evtJobs.addAll(jobs);
                        continue;
                    }
                    if (event == null || event.getVariables() != null && event.getVariables().trim().length() > 0) {
                        event = eventAuxiliary.createBizEvent(payload);
                    }
                    event.setEventId(evtId);
                    this.addListIfNotNull(evtJobs, job.getBusinessKey(), this.createEventJob(job, event, subscription, json, sb, payload));
                }
                if (evtJobs.isEmpty()) break block20;
                sb.append(String.format(ResManager.loadKDString((String)"\u751f\u6210serviceJob\uff1a%s\u4e2a\uff0c\u53d1\u9001MQ\u3002", (String)"EventDispatchJobHandler_8", (String)"bos-wf-engine", (Object[])new Object[0]), evtJobs.size()));
                commandContext.getEvtJobManager().eventSendMqdirct(evtJobs);
                this.collectEvtJobs(evtJobs);
            }
            catch (RuntimeException e) {
                try {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5206\u53d1\u51fa\u9519\uff0c\u539f\u56e0\uff1a%1$s%2$s\u3002%1$s", (String)"EventDispatchJobHandler_10", (String)"bos-wf-engine", (Object[])new Object[0]), "\r\n", WfUtils.getExceptionStacktrace(e)));
                    throw e;
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    sb.append(String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventDispatchJobHandler_24", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                    if (evtLog != null) {
                        evtLog.setContent(sb.toString());
                        EvtLogUtils.saveEvtLog(evtLog);
                    }
                    throw throwable;
                }
            }
        }
        long end = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventDispatchJobHandler_24", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
        if (evtLog != null) {
            evtLog.setContent(sb.toString());
            EvtLogUtils.saveEvtLog(evtLog);
        }
    }

    private boolean ifHashCondition(String expression, VariableScope variableScope, StringBuilder sb) {
        try {
            if (!ConditionUtil.hasTrueCondition(expression, variableScope, null)) {
                sb.append(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u3002", (String)"EventDispatchJobHandler_7", (String)"bos-wf-engine", (Object[])new Object[0]));
                return false;
            }
        }
        catch (WFConditionParseException e) {
            if (e.getCause() instanceof WFObjectNotFoundException) {
                sb.append(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002", (String)"EventDispatchJobHandler_32", (String)"bos-wf-engine", (Object[])new Object[0]));
                return false;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        return true;
    }

    private List<EvtJobEntity> createEvtJobs(EvtJobEntity srcJob, IEventAuxiliary eventAuxiliary, Map<String, Object> subscription, String json, StringBuilder sb, Map<String, Object> payload) {
        if (!"1".equalsIgnoreCase((String)subscription.get(EXECUTIONSTRATEGY))) {
            return null;
        }
        boolean isCostom = "jsonEvent".equals((String)payload.get("eventType"));
        String splitType = BUSINESSKEY;
        ArrayList<String> businesskeys = new ArrayList();
        int splitSize = 100;
        String eventsplitconf = (String)subscription.get(EVENTSPLITCONF);
        if (WfUtils.isNotEmpty(eventsplitconf)) {
            Map eventsplitconfMap = (Map)SerializationUtils.fromJsonString((String)eventsplitconf, Map.class);
            String size = (String)eventsplitconfMap.get(SPLITSIZE);
            if (WfUtils.isNotEmpty(size) && this.matchPattern(SPLITSIZE_REGULAR, size)) {
                splitSize = Integer.parseInt(size);
            }
            if (isCostom) {
                String type = (String)eventsplitconfMap.get(SPLITTYPE);
                String word = (String)eventsplitconfMap.get(SPLITWORD);
                if ("eventparam".equalsIgnoreCase(type) && WfUtils.isNotEmpty(word)) {
                    splitType = word;
                }
            }
        }
        if (isCostom) {
            sb.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u62c6\u5206\uff0c\u81ea\u5b9a\u4e49\u4e8b\u4ef6\uff0cjob-%1$s-splitType-%2$s", (String)"EventDispatchJobHandler_28", (String)"bos-wf-engine", (Object[])new Object[0]), srcJob.getId(), splitType));
            this.buildBks(json, businesskeys, splitType);
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u62c6\u5206\uff0c\u82cd\u7a79\u4e8b\u4ef6\uff0cjob-%s", (String)"EventDispatchJobHandler_29", (String)"bos-wf-engine", (Object[])new Object[0]), srcJob.getId()));
            businesskeys = (List)payload.get("businesskeys");
        }
        ArrayList<EvtJobEntity> evtJobList = new ArrayList<EvtJobEntity>(0);
        if (businesskeys == null) {
            sb.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u62c6\u5206\uff0c\u4f20\u5165\u7684pk\u662fnull", (String)"EventDispatchJobHandler_30", (String)"bos-wf-engine", (Object[])new Object[0]));
            return null;
        }
        int size = businesskeys.size();
        if (size < 2 || size <= splitSize) {
            sb.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u62c6\u5206\uff0c\u4f20\u5165\u7684pk-size:%s", (String)"EventDispatchJobHandler_31", (String)"bos-wf-engine", (Object[])new Object[0]), size));
            return null;
        }
        ArrayList businesskeysList = new ArrayList(0);
        ArrayList<String> tem = new ArrayList<String>(size);
        for (int i = 1; i <= size; ++i) {
            String businesskey = (String)businesskeys.get(i - 1);
            tem.add(businesskey);
            if (i % splitSize != 0 && i != size) continue;
            ArrayList<String> item = new ArrayList<String>(0);
            item.addAll(tem);
            businesskeysList.add(item);
            tem.clear();
        }
        int eventSize = businesskeysList.size();
        sb.append(String.format(ResManager.loadKDString((String)"\u5171\u5206-%s\u6279", (String)"EventDispatchJobHandler_26", (String)"bos-wf-engine", (Object[])new Object[0]), eventSize));
        for (int i = 0; i < eventSize; ++i) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c-%s\u6279\u521b\u5efajob", (String)"EventDispatchJobHandler_27", (String)"bos-wf-engine", (Object[])new Object[0]), i + 1));
            if (isCostom) {
                this.buildJson(json, (List)businesskeysList.get(i), splitType);
            }
            KDBizEvent event = eventAuxiliary.createBizEvent(payload, (List)businesskeysList.get(i), json);
            event.setEventId(Long.valueOf(subscription.get(EVENTID).toString()));
            this.addListIfNotNull(evtJobList, null, this.createEventJob(srcJob, event, subscription, json, sb, payload));
        }
        return evtJobList;
    }

    private boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    private void addListIfNotNull(List<EvtJobEntity> list, String businessKey, EvtJobEntity job) {
        if (list == null || job == null) {
            return;
        }
        if (WfUtils.isNotEmpty(businessKey)) {
            job.setBusinessKey(businessKey);
        }
        if (EvtJobUtil.subscriptionIsSuspend(Context.getCommandContext(), job.getSubscriptionId())) {
            ArrayList<EvtJobEntity> jobs = new ArrayList<EvtJobEntity>(1);
            jobs.add(job);
            Context.getCommandContext().getEvtJobManager().eventSuspend(jobs);
        } else {
            list.add(job);
        }
    }

    private void buildJson(String json, List<String> businesskeys, String splitType) {
        if (json == null || json.trim().equals("") || businesskeys == null || businesskeys.isEmpty()) {
            return;
        }
        String businesskeyStr = String.join((CharSequence)",", businesskeys);
        JSONObject obj = JSON.parseObject((String)json);
        obj.put(splitType, (Object)businesskeyStr);
        json = obj.toJSONString();
    }

    private void buildBks(String json, List<String> businesskeys, String splitType) {
        JSONObject obj;
        String businesskey;
        if (json != null && !json.trim().equals("") && WfUtils.isNotEmpty(businesskey = (obj = JSON.parseObject((String)json)).getString(splitType))) {
            if (businesskey.contains(",")) {
                String[] pk;
                for (String p : pk = businesskey.split("\\,")) {
                    if (!WfUtils.isNotEmpty(p)) continue;
                    businesskeys.add(p);
                }
            } else {
                businesskeys.add(businesskey);
            }
        }
        if (businesskeys.isEmpty()) {
            businesskeys.add(BUSINESSKEY);
        }
    }

    private void collectEvtJobs(List<EvtJobEntity> evtJobs) {
        StringBuilder config = new StringBuilder();
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>();
        int len = evtJobs.size();
        for (int i = 0; i < len; ++i) {
            EvtJobEntity job = evtJobs.get(i);
            config.append(job.getServiceId()).append(",").append(job.getEventId()).append(",").append(job.getSubscriptionId()).append(";");
            if (config.length() < 600 && i != len - 1) continue;
            IndicatorInfo info = new IndicatorInfo("businessEventJobByEvent", null);
            info.addToSpecialProperty("evtSubServiceIds", (Object)config.toString());
            info.addToSpecialProperty("createDate", (Object)job.getCreateDate());
            infos.add(info);
            config = new StringBuilder();
        }
        WorkflowDevopsService.create().batchExceutionDataCollection(infos);
    }

    private List<String> fixJobAndDealEvtCycle(EvtJobEntity job, StringBuilder sb, EvtJobEntityManager evtJobMgr) {
        String eventBizKey = job.getBizKey();
        ArrayList<String> eventBizKeyLine = new ArrayList<String>(16);
        String srcTraceId = job.getSrcTraceId();
        job.setRootEventInstId(job.getRootJobId());
        if (WfUtils.isEmpty(srcTraceId)) {
            sb.append(String.format(ResManager.loadKDString((String)"job[%s]\u6ca1\u6709srcTraceId\uff0c\u4e5f\u5f88\u7a00\u5947\u5462\uff0c\u5f53\u6210\u8d77\u59cb\u4e8b\u4ef6\u5904\u7406\u3002", (String)"EventDispatchJobHandler_23", (String)"bos-wf-engine", (Object[])new Object[0]), job.getId()));
            eventBizKeyLine.add(eventBizKey);
            return eventBizKeyLine;
        }
        EvtJobEntity srcJob = evtJobMgr.findByTraceId(srcTraceId);
        if (srcJob == null) {
            sb.append(String.format(ResManager.loadKDString((String)"job[%s]\u4e3a\u6e90\u5934\u4e8b\u4ef6;", (String)"EventDispatchJobHandler_16", (String)"bos-wf-engine", (Object[])new Object[0]), job.getRootJobId()));
            eventBizKeyLine.add(eventBizKey);
            return eventBizKeyLine;
        }
        String jobHandlerConfiguration = srcJob.getJobHandlerConfiguration();
        try {
            String eventBizKeyLineStr;
            Map jobHandlerConfigurationMap;
            if (jobHandlerConfiguration != null && (jobHandlerConfigurationMap = (Map)SerializationUtils.fromJsonString((String)jobHandlerConfiguration, Map.class)) != null && WfUtils.isNotEmpty(eventBizKeyLineStr = (String)jobHandlerConfigurationMap.get("eventBizkeyLine"))) {
                sb.append(String.format(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u4e8b\u4ef6\u94fe\u8def[%s];", (String)"EventDispatchJobHandler_13", (String)"bos-wf-engine", (Object[])new Object[0]), eventBizKeyLineStr));
                eventBizKeyLine = new ArrayList<String>(Arrays.asList(eventBizKeyLineStr.split(",")));
            }
        }
        catch (KDException e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
        }
        if (eventBizKeyLine.contains(eventBizKey)) {
            String infoMsg = String.format(ResManager.loadKDString((String)"\u5f62\u6210\u4e8b\u4ef6\u98ce\u66b4\uff0c\u5373\u5b58\u5728\u73af\u5f62\u7684\u4e8b\u4ef6\u8c03\u7528\u94fe\uff0c\u5f53\u524d\u4e8b\u4ef6\u6807\u5fd7%1$s\uff0c\u4e8b\u4ef6\u94fe%2$s", (String)"EventDispatchJobHandler_22", (String)"bos-wf-engine", (Object[])new Object[0]), eventBizKey, WfUtils.listToString(eventBizKeyLine, ","));
            job.setExceptionMessage(infoMsg);
            sb.append(infoMsg);
            throw new KDException(new ErrorCode(ERROR_EVENTSHOWERERROR, infoMsg), new Object[]{""});
        }
        eventBizKeyLine.add(eventBizKey);
        return eventBizKeyLine;
    }

    private EvtJobEntity createEventJob(EvtJobEntity srcJob, KDBizEvent event, Map<String, Object> subscription, String json, StringBuilder sb, Map<String, Object> payload) {
        EventDispatchContext context = new EventDispatchContext();
        String serviceImpl = (String)subscription.get(SERVICEIMPL);
        Object jsonObject = subscription.get("jsonObject");
        if (jsonObject != null) {
            this.setOperParam(event, (JSONObject)jsonObject, serviceImpl, payload);
        }
        Map appMap = (Map)subscription.get("appMap");
        context.setEvent(event);
        context.setJson(json);
        context.setSubscriptionId(Long.valueOf(subscription.get(SUBSCRIPTIONID).toString()));
        context.setSubscriptionNumber((String)subscription.get(SUBSCRIPTIONNUMBER));
        context.setServiceId(Long.valueOf(subscription.get(SERVICEID).toString()));
        context.setServiceNumber((String)subscription.get(SERVICENUMBER));
        context.setEventBizkeyLine((String)subscription.get("eventBizKeyLineInfo"));
        context.setErrorNotify((String)subscription.get(ERRORNOTIFY));
        context.setExecutorvalue((String)subscription.get(EXECUTORVALUE));
        context.setErrorStrategy((String)subscription.get(ERRORSTRATEGY));
        String appId = appMap != null ? (String)appMap.get(APPID) : null;
        String appNum = appMap != null ? (String)appMap.get("appNum") : null;
        sb.append("appId[").append(appId).append("],appNum[").append(appNum).append("]");
        if (WfUtils.isNotEmpty(appNum)) {
            context.setAppNumForSubApp(appNum);
        }
        context.setSrcLang(RequestContext.get().getLang().toString());
        StringBuilder param = new StringBuilder();
        EvtJobEntity evtJob = this.getEventJobEntity(serviceImpl, context, param);
        evtJob.setSrcJobId(srcJob.getId());
        evtJob.setRootEventInstId(srcJob.getRootEventInstId());
        evtJob.setBizKey(srcJob.getBizKey());
        evtJob.setSrcTraceId(RequestContext.get().getTraceId());
        if (WfUtils.isNotEmpty(appNum)) {
            evtJob.setAppNumForSubApp(appNum);
        }
        sb.append(String.format(ResManager.loadKDString((String)"\u6ee1\u8db3\uff0c\u521b\u5efa\u670d\u52a1Job\u3010%1$s-%2$d\u3011", (String)"EventDispatchJobHandler_11", (String)"bos-wf-engine", (Object[])new Object[0]), param, evtJob.getId()));
        if (WfUtils.isEmpty((String)subscription.get(SUBSCRIPAPPID)) && WfUtils.isNotEmpty(appId)) {
            this.updateEvtSubscription(Long.valueOf(subscription.get(SUBSCRIPTIONID).toString()), appId);
        }
        if (this.ifSuspendDueToAppDisabled(appNum, appId, sb, evtJob)) {
            ArrayList<EvtJobEntity> evtJobs = new ArrayList<EvtJobEntity>(1);
            evtJobs.add(evtJob);
            this.collectEvtJobs(evtJobs);
            return null;
        }
        return evtJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEvtSubscription(Long id, String appId) {
        String sql = "update  t_evt_subscription set FAPPID = ? where FID = ?";
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{appId, id});
        }
    }

    private boolean ifSuspendDueToAppDisabled(String appNum, String appId, StringBuilder sb, EvtJobEntity evtJob) {
        if (appNum == null || appNum.trim().length() <= 0 || appNum.equalsIgnoreCase("wf") || appNum.equalsIgnoreCase("bec") || appNum.equalsIgnoreCase("wfs") || appNum.equalsIgnoreCase("wftask") || appNum.equalsIgnoreCase("bpm")) {
            return false;
        }
        try {
            Set disabledSet = ManageServiceHelper.getDisabledAppIds();
            if (disabledSet != null && disabledSet.contains(appId)) {
                String info = String.format(ResManager.loadKDString((String)"\u56e0\u4e3a%s-\u5e94\u7528\u88ab\u7981\u7528\uff0c\u76f4\u63a5\u6302\u8d77\u670d\u52a1JOB", (String)"EventDispatchJobHandler_25", (String)"bos-wf-engine", (Object[])new Object[0]), appId);
                this.log.debug(String.format("%s-\u5e94\u7528\u88ab\u7981\u7528\uff0c\u76f4\u63a5\u6302\u8d77", appId));
                WFEngineException e = new WFEngineException("", new Exception(info));
                e.setType("appDisableSuspend");
                EvtDeadLetterJobEntity deadletterJob = Context.getCommandContext().getEvtJobManager().moveEvtJobToDeadLetterJob(evtJob, (Throwable)((Object)e));
                if (deadletterJob != null) {
                    sb.append(info);
                    this.log.debug(String.format("\u76f4\u63a5\u6302\u8d77\u6210\u529f\uff1aid:\u3010%s\u3011", deadletterJob.getId()));
                    return true;
                }
                return false;
            }
        }
        catch (Throwable exp) {
            this.log.warn(WfUtils.getExceptionStacktrace(exp));
            return false;
        }
        return false;
    }

    private void setOperParam(KDBizEvent event, JSONObject jsonObject, String serviceImpl, Map<String, Object> payload) {
        try {
            JSONObject valueObject;
            String value;
            String operateparamsconf = null;
            if ("kd.bos.bec.engine.servicehanler.ExecutePluginJobHandler".equalsIgnoreCase(serviceImpl) && WfUtils.isNotEmpty(value = jsonObject.getString("value")) && (valueObject = JSON.parseObject((String)value)) != null) {
                operateparamsconf = valueObject.getString(OPERATEPARAMSCONF);
            }
            if ("kd.bos.bec.engine.servicehanler.ExecuteOperationJobHandler".equalsIgnoreCase(serviceImpl)) {
                operateparamsconf = jsonObject.getString(OPERATEPARAMSCONF);
            }
            if (WfUtils.isEmpty(operateparamsconf)) {
                return;
            }
            String[] operateparamsconfArr = null;
            operateparamsconfArr = operateparamsconf.split(",");
            if (operateparamsconfArr == null || operateparamsconfArr.length < 1) {
                return;
            }
            Map operationParamsMap = (Map)payload.get("becEventOperationParams");
            JSONObject paramJson = new JSONObject();
            for (int i = 0; i < operateparamsconfArr.length; ++i) {
                int length;
                String paramsconf = operateparamsconfArr[i];
                String[] operateparamArr = (paramsconf = paramsconf.substring(1, paramsconf.length() - 1)).split("/");
                if (operateparamArr == null || (length = operateparamArr.length) < 2) continue;
                String type = operateparamArr[0];
                String key = operateparamArr[1];
                if (type == null || key == null) continue;
                if ("0".equalsIgnoreCase(type) && length > 2) {
                    paramJson.put(key, (Object)operateparamArr[2]);
                    continue;
                }
                if (operationParamsMap == null) continue;
                if (operationParamsMap.containsKey(key)) {
                    paramJson.put(key, (Object)((String)operationParamsMap.get(key)));
                    continue;
                }
                if (!operationParamsMap.containsKey(key.toLowerCase())) continue;
                paramJson.put(key, (Object)((String)operationParamsMap.get(key.toLowerCase())));
            }
            if (!paramJson.isEmpty()) {
                event.setVariables(paramJson.toJSONString());
            }
        }
        catch (Exception se) {
            this.log.debug("\u64cd\u4f5c\u53c2\u6570\u52a0\u8f7d\u5931\u8d25\u3002");
        }
    }

    private JSONObject getSubscriptionJson(Map<String, Object> subscription) {
        String subscriptionConfig;
        String impl = (String)subscription.get(SERVICEIMPL);
        if (("kd.bos.bec.engine.servicehanler.ExecutePluginJobHandler".equalsIgnoreCase(impl) || "kd.bos.bec.engine.servicehanler.ExecuteOperationJobHandler".equalsIgnoreCase(impl)) && (subscriptionConfig = (String)subscription.get(SUBSCRIPTIONCONFIG)) != null) {
            return JSON.parseObject((String)subscriptionConfig);
        }
        return null;
    }

    private Map<String, String> getAppNumAndId(Map<String, Object> subscription, JSONObject jsonObject) {
        String subscriptionConfig = (String)subscription.get(SUBSCRIPTIONCONFIG);
        String impl = (String)subscription.get(SERVICEIMPL);
        try {
            if ("0".equalsIgnoreCase((String)subscription.get(INNERSERVICE))) {
                String appId = (String)subscription.get(APPID);
                if (appId != null) {
                    return this.createAppMap(appId, BizAppServiceHelp.getAppNumByAppId((String)appId));
                }
                return null;
            }
            switch (impl) {
                case "kd.bos.bec.engine.servicehanler.ExecutePluginJobHandler": {
                    JSONObject jsonObjectPlugin;
                    JSONObject jSONObject = jsonObjectPlugin = jsonObject == null ? JSON.parseObject((String)subscriptionConfig) : jsonObject;
                    if (jsonObjectPlugin == null) break;
                    String value = jsonObjectPlugin.getString("value");
                    if (WfUtils.isNotEmpty(value)) {
                        JSONObject valueObject = JSON.parseObject((String)value);
                        return this.getAppNumAndIdByAppNum(valueObject.getString("appid"));
                    }
                    break;
                }
                case "kd.bos.bec.engine.servicehanler.ExecuteOperationJobHandler": {
                    JSONObject jsonObjectOperation;
                    JSONObject jSONObject = jsonObjectOperation = jsonObject == null ? JSON.parseObject((String)subscriptionConfig) : jsonObject;
                    if (jsonObjectOperation == null) break;
                    String optype = jsonObjectOperation.getString(OPTYPE);
                    String targetentity = jsonObjectOperation.getString("targetentity");
                    if ("custom".equalsIgnoreCase(optype)) {
                        return this.getAppNumAndIdByEntityNumber(MetadataDao.getNumberById((String)targetentity));
                    }
                    return WfUtils.isNotEmpty(targetentity) ? this.getAppNumAndIdByEntityNumber(targetentity) : this.getAppNumAndIdByEntityNumber(jsonObjectOperation.getString("evententity"));
                }
                case "kd.bos.bec.engine.servicehanler.EventMicroServiceJobHandler": {
                    JSONObject jsonObjectMicro = JSON.parseObject((String)subscriptionConfig);
                    if (jsonObjectMicro == null) break;
                    return this.getAppNumAndIdByAppNum(jsonObjectMicro.getString("appid"));
                }
                case "kd.bos.bec.engine.servicehanler.EventExecuteRPAJobHandler": {
                    String appId = (String)subscription.get(APPID);
                    if (appId == null) break;
                    return this.createAppMap(appId, BizAppServiceHelp.getAppNumByAppId((String)appId));
                }
            }
        }
        catch (Exception e) {
            this.log.warn("\u670d\u52a1job\u83b7\u53d6apppid\u5931\u8d25:" + WfUtils.getExceptionStacktrace(e));
            return null;
        }
        return null;
    }

    private Map<String, String> getAppNumAndIdByEntityNumber(String entityNumber) {
        if (WfUtils.isEmpty(entityNumber)) {
            return null;
        }
        String appId = WfCacheHelper.getAppIdByEntityNumber(entityNumber);
        if (WfUtils.isEmpty(appId)) {
            return null;
        }
        return this.createAppMap(appId, BizAppServiceHelp.getAppNumByAppId((String)appId));
    }

    private Map<String, String> getAppNumAndIdByAppNum(String appNum) {
        if (WfUtils.isEmpty(appNum)) {
            return null;
        }
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNum);
        if (WfUtils.isEmpty(appId)) {
            return null;
        }
        return this.createAppMap(appId, appNum);
    }

    private Map<String, String> createAppMap(String appId, String appNum) {
        HashMap<String, String> appMap = new HashMap<String, String>();
        appMap.put(APPID, appId);
        appMap.put("appNum", appNum);
        return appMap;
    }

    private List<Map<String, Object>> getSubscriptionsFromDb(String evtNumber) {
        StringBuilder sbs = new StringBuilder();
        sbs.append("SELECT ").append("a.fappid subscripAppId, ").append("a.fexecutionstrategy executionStrategy, ").append("a.feventsplitconfig eventsplitconfig, ").append("c.fsource eventSource, ").append("c.fentity eventEntity, ").append("c.ftype optype, ").append("b.fapp appId, ").append("b.finnerservice innerService, ").append("a.fevent eventId, ").append("a.fid subscriptionId, ").append("a.fnumber subscriptionNumber, ").append("a.fserviceconfig subscriptionConfig, ").append("a.fservice serviceId, ").append("b.fimplementation serviceImpl, ").append("a.fservicenumber serviceNumber, ").append("a.ferrorstrategy errorStrategy, ").append("a.ferrornotify errorNotify, ").append("a.fexecutorvalue executorvalue, ").append("a.fexpression expression ").append("FROM ").append("t_evt_subscription a ").append("LEFT JOIN t_evt_service b ON a.FSERVICE = b.fid ").append("LEFT JOIN t_evt_event c ON a.fevent = c.fid ").append("WHERE a.feventnumber = ? ").append("and a.fstatus = '1' ").append("and b.fstatus = '1'").append("and c.fstatus = '1'");
        if (MESSAGE_EVENTS.contains(evtNumber)) {
            sbs.append(" and b.fnumber != 'sendMsg' ");
        }
        ArrayList<Map<String, Object>> subscriptions = new ArrayList<Map<String, Object>>();
        try (DataSet ds = DB.queryDataSet((String)"be.subscription", (DBRoute)DBRoute.workflow, (String)sbs.toString(), (Object[])new Object[]{evtNumber});){
            for (Row row : ds) {
                HashMap<String, Object> tmp = new HashMap<String, Object>(32);
                tmp.put(EVENTID, row.getLong(EVENTID));
                tmp.put(SUBSCRIPTIONID, row.getLong(SUBSCRIPTIONID));
                tmp.put(SUBSCRIPTIONNUMBER, row.get(SUBSCRIPTIONNUMBER));
                tmp.put(SUBSCRIPTIONCONFIG, row.get(SUBSCRIPTIONCONFIG));
                tmp.put(SERVICEID, row.getLong(SERVICEID));
                tmp.put(SERVICENUMBER, row.get(SERVICENUMBER));
                tmp.put(SERVICEIMPL, row.getString(SERVICEIMPL));
                tmp.put(ERRORNOTIFY, row.get(ERRORNOTIFY));
                tmp.put(ERRORSTRATEGY, row.get(ERRORSTRATEGY));
                tmp.put(EXPRESSION, row.get(EXPRESSION));
                tmp.put(EXECUTORVALUE, row.get(EXECUTORVALUE));
                tmp.put(EVENTSOURCE, row.get(EVENTSOURCE));
                tmp.put(EVENTENTITY, row.get(EVENTENTITY));
                tmp.put(APPID, row.get(APPID));
                tmp.put(OPTYPE, row.get(OPTYPE));
                tmp.put(INNERSERVICE, row.get(INNERSERVICE));
                tmp.put(EXECUTIONSTRATEGY, row.get(EXECUTIONSTRATEGY));
                tmp.put(EVENTSPLITCONF, row.get(EVENTSPLITCONF));
                tmp.put(SUBSCRIPAPPID, row.get(SUBSCRIPAPPID));
                subscriptions.add(tmp);
            }
        }
        this.cacheTheList(subscriptions, evtNumber);
        return subscriptions;
    }

    private void cacheTheList(List<Map<String, Object>> list, String evtNumber) {
        if (list == null || list.size() < 1) {
            return;
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> eventParams = list.get(i);
                for (Map.Entry<String, Object> entry : eventParams.entrySet()) {
                    String key = entry.getKey();
                    String kkey = String.format("%1$s-%2$s", key, i);
                    map.put(kkey, entry.getValue() == null ? null : entry.getValue().toString());
                }
            }
            if (map.size() > 0) {
                EvtCacheHelper.addCacheSubscriptionMap(evtNumber, map);
            }
        }
        catch (KDException e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
        }
    }

    private List<Map<String, Object>> getSubscriptions(String evtNumber) {
        try {
            Map<String, String> eventParams = EvtCacheHelper.getCacheSubscriptionMap(evtNumber);
            if (eventParams != null && !eventParams.isEmpty()) {
                HashMap mapGroup = new HashMap(32);
                Map map = new HashMap();
                for (Map.Entry<String, String> entry : eventParams.entrySet()) {
                    String key = entry.getKey();
                    String kkey = key.split("-")[1];
                    map = mapGroup.containsKey(kkey) ? (Map)mapGroup.get(kkey) : new HashMap();
                    map.put(key.split("-")[0], entry.getValue());
                    mapGroup.put(kkey, map);
                }
                if (!mapGroup.isEmpty()) {
                    return new ArrayList<Map<String, Object>>(mapGroup.values());
                }
            }
        }
        catch (KDException e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
        }
        return this.getSubscriptionsFromDb(evtNumber);
    }

    private EvtJobEntity getEventJobEntity(String impl, EventDispatchContext ctx, StringBuilder sb) {
        EvtJobManager jobMgr = Context.getCommandContext().getEvtJobManager();
        EvtJobEntity job = null;
        switch (impl) {
            case "kd.bos.bec.engine.servicehanler.ExecutePluginJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "event-execute-plugin");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.ExecuteOperationJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "event-execute-operation");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.EventSendMsgJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "event-send-message");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.TriggerHttpApiJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "trigger-http-api");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.ExeCustomEvtOperationJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "customevent-execute-operation");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.EventStartProcessJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "event-start-process");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.EventMicroServiceJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "event-execute-microservice");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.TryCloseBizFlowEventHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "tryCloseBizFlow");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.EventExecuteRPAJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "event-execute-rpa");
                break;
            }
            case "kd.bos.bec.engine.servicehanler.UpdateRPAStatusJobHandler": {
                job = jobMgr.createCommonEvtJob(ctx, "update-RPA-status");
                break;
            }
            default: {
                job = jobMgr.createCommonEvtJob(ctx, "execute-ext-event");
            }
        }
        sb.append(impl);
        KDBizEvent event = ctx.getEvent();
        if (event instanceof EntityEvent) {
            List businesskeys = ((EntityEvent)event).getBusinesskeys();
            String entityNumber = ((EntityEvent)event).getEntityNumber();
            if (businesskeys != null && !businesskeys.isEmpty()) {
                job.setBusinessKey((String)businesskeys.get(0));
                job.setEntityNumber(entityNumber);
            }
        }
        job.setProcessInstanceId(event.getEventId());
        job.setProcessDefinitionId(ctx.getServiceId());
        job.setExecutionId(ctx.getSubscriptionId());
        return job;
    }
}

