/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.EvtLogUtils;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.event.EventLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class EventExecuteRPAJobHandler
extends AbstractEventServiceJobHandler {
    public static final String TYPE = "event-execute-rpa";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return "execute event rpa service";
    }

    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        StringBuilder sb = new StringBuilder();
        long begin = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884cRpacpExecuteRPAJobHandler\uff1a%s", (String)"EventExecuteRPAJobHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]), begin));
        EventDispatchContext edContext = this.restoreEventContext(configuration);
        sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u8c03\u7528RPA\u670d\u52a1\u3002", (String)"EventExecuteRPAJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        EventLogEntity evtLog = null;
        Map proceParm = (Map)SerializationUtils.fromJsonString((String)this.restoreEventContext(configuration).getSubscriptionConfig(), Map.class);
        String procCode = proceParm.get("procCode").toString();
        String robotId = proceParm.get("robotId").toString();
        ArrayList parmsResult = (ArrayList)proceParm.get("parms");
        List<HashMap<String, String>> pResult = EventExecuteRPAJobHandler.getRealList(parmsResult, configuration, edContext);
        try {
            this.transferEvtLine(job, commandContext, sb, edContext);
            if (WfUtils.isNotEmpty(configuration)) {
                this.changeContext(configuration, edContext);
            }
            evtLog = this.buildEventLog(edContext, job);
            long beginSendMessage = System.currentTimeMillis();
            sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65b0\u5efa\u4efb\u52a1\u3002", (String)"EventExecuteRPAJobHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            String taskId = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"addTask", (Object[])new Object[]{procCode, robotId, "", pResult});
            long endSendMessage = System.currentTimeMillis();
            sb.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u7f16\u53f7\u201c%1$s\u201d\u65b0\u5efa\u4efb\u52a1\u5b8c\u6210\u3002\u8017\u65f6%2$dms\uff0c\u4efb\u52a1ID\u4e3a%3$s\uff0c\u4efb\u52a1\u6267\u884c\u60c5\u51b5\u8bf7\u8fdb\u5165\u201cRPA\u670d\u52a1\u4e91>RPA\u63a7\u5236\u53f0>\u4efb\u52a1\u5217\u8868\u201d\u67e5\u770b\u3002", (String)"EventExecuteRPAJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0]), procCode, endSendMessage - beginSendMessage, taskId));
        }
        catch (Exception e) {
            try {
                sb.append(String.format(ResManager.loadKDString((String)"\u65b0\u5efa\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"EventExecuteRPAJobHandler_7", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage() + pResult.toString()));
                throw e;
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884cRpacpExecuteRPAJobHandler\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventExecuteRPAJobHandler_9", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                if (evtLog != null) {
                    evtLog.setContent(sb.toString());
                    EvtLogUtils.saveEvtLog(evtLog);
                }
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884cRpacpExecuteRPAJobHandler\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventExecuteRPAJobHandler_9", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
        if (evtLog != null) {
            evtLog.setContent(sb.toString());
            EvtLogUtils.saveEvtLog(evtLog);
        }
    }

    private static List<HashMap<String, String>> getRealList(List<HashMap<String, String>> list, String configuration, EventDispatchContext edContext) {
        ArrayList<HashMap<String, String>> pResult = new ArrayList<HashMap<String, String>>(16);
        for (HashMap<String, String> map : list) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String realResultKey = EventExecuteRPAJobHandler.getRealResult(entry.getKey());
                String realResultVal = "";
                realResultVal = realResultKey.equals("Value") ? EventExecuteRPAJobHandler.getRealValue(entry.getValue(), configuration, edContext) : entry.getValue();
                m.put(realResultKey, realResultVal);
            }
            pResult.add(m);
        }
        return pResult;
    }

    private static String getRealValue(String value, String configuration, EventDispatchContext edContext) {
        Object val = null;
        if (value.startsWith("${") && value.endsWith("}")) {
            KDBizEvent event = edContext.getEvent();
            if (event instanceof EntityEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                String entityNumber = entityEvent.getEntityNumber();
                List businesskeys = entityEvent.getBusinesskeys();
                String busineseeKey = (String)businesskeys.get(0);
                BusinessModelVariableScope bvs = new BusinessModelVariableScope(busineseeKey, entityNumber);
                val = ExpressionCalculatorUtil.parseValue(BusinessDataServiceHelper.loadSingle((Object)busineseeKey, (String)entityNumber), bvs, value, new HashMap<String, Object>());
            } else {
                Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
                String entityNumber = (String)payload.get("json");
                EventModelVariableScope bvs = new EventModelVariableScope(entityNumber);
                val = ExpressionCalculatorUtil.parseValue(null, bvs, value, new HashMap<String, Object>());
            }
        } else {
            val = value;
        }
        return String.valueOf(val);
    }

    private static String getRealResult(String parm) {
        String result = "";
        switch (parm) {
            case "required_parm": {
                result = "IsEmpty";
                break;
            }
            case "des_parm": {
                result = "Desc";
                break;
            }
            case "type_parm": {
                result = "Type";
                break;
            }
            case "help": {
                result = "Help";
                break;
            }
            case "fileextname": {
                result = "FileExtName";
                break;
            }
            case "value_parm": {
                result = "Value";
                break;
            }
            case "itempos": {
                result = "ItemPos";
                break;
            }
            case "childnode": {
                result = "ChildNode";
                break;
            }
            case "name_parm": {
                result = "Name";
                break;
            }
            default: {
                return result;
            }
        }
        return result;
    }
}

