/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.EvtLogUtils;
import kd.bos.bec.engine.EvtUtils;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.event.EventLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.exception.WFErrorCode;

public class EventMicroServiceJobHandler
extends AbstractEventServiceJobHandler {
    public static final String TYPE = "event-execute-microservice";
    public static final String CLOUD = "cloud";
    public static final String APPID = "appid";
    public static final String SERVICENAME = "servicename";
    public static final String METHODNAME = "methodname";
    public static final String PARAMS = "params";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_DATETIME = "datetime";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return "execute event operation service";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        EventLogEntity evtLog;
        long begin;
        StringBuilder sb;
        block24: {
            sb = new StringBuilder();
            begin = System.currentTimeMillis();
            sb.append(ResManager.loadKDString((String)"\u6267\u884cEventMicroServiceJobHandler\uff1a{0}", (String)"EventMicroServiceJobHandler_0", (String)"bos-wf-engine", (Object[])new Object[]{begin}));
            EventDispatchContext edContext = this.restoreEventContext(configuration);
            String executorvalue = edContext.getExecutorvalue();
            sb.append(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4e8b\u4ef6%s\u89e6\u53d1\u7684\u5fae\u670d\u52a1\uff1b", (String)"EventMicroServiceJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), edContext.getEvent().getEventNumber()));
            evtLog = null;
            try {
                this.transferEvtLine(job, commandContext, sb, edContext);
                if (WfUtils.isNotEmpty(configuration)) {
                    if (!executorvalue.isEmpty()) {
                        sb.append(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6307\u5b9a\u7684\u64cd\u4f5c\u6267\u884c\u4eba\u3002", (String)"EventMicroServiceJobHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                    this.changeContext(configuration, edContext);
                }
                evtLog = this.buildEventLog(edContext, job);
                String subscriptionCfg = edContext.getSubscriptionConfig();
                if (!WfUtils.isNotEmpty(subscriptionCfg)) break block24;
                Map cfg = (Map)SerializationUtils.fromJsonString((String)subscriptionCfg, Map.class);
                String cloud = (String)cfg.get(CLOUD);
                DynamicObject cloudobj = null;
                ILocaleString cloudname = null;
                if (WfUtils.isNotEmpty(cloud)) {
                    cloudobj = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizcloud", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)cloud)});
                    cloudname = cloudobj.getLocaleString("name");
                }
                String app = (String)cfg.get(APPID);
                DynamicObject appobj = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)app)});
                ILocaleString appname = appobj.getLocaleString("name");
                String servicename = (String)cfg.get(SERVICENAME);
                String methodname = (String)cfg.get(METHODNAME);
                ArrayList params = (ArrayList)cfg.get(PARAMS);
                Object result = null;
                LinkedHashMap<Object, Object> extraParams = new LinkedHashMap<Object, Object>();
                DynamicObject obj = null;
                for (int i = 0; i < params.size(); ++i) {
                    Map param = (Map)params.get(i);
                    String name = (String)param.get("name");
                    String string = (String)param.get("val");
                    String type = (String)param.get("type");
                    Object value = string;
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    if (string.startsWith("${")) {
                        VariableScopeImpl bvs;
                        Object val = null;
                        KDBizEvent event = edContext.getEvent();
                        if (event instanceof EntityEvent) {
                            EntityEvent entityEvent = (EntityEvent)event;
                            String entityNumber = entityEvent.getEntityNumber();
                            List businesskeys = entityEvent.getBusinesskeys();
                            String busineseeKey = (String)businesskeys.get(0);
                            bvs = new BusinessModelVariableScope(busineseeKey, entityNumber);
                            if (obj == null) {
                                obj = EvtUtils.findBusinessObject(busineseeKey, entityNumber);
                            }
                            if (obj == null) {
                                extraParams.put(name, null);
                                continue;
                            }
                            val = ExpressionCalculatorUtil.parseValue(obj, bvs, string, new HashMap<String, Object>());
                            extraParams.put(name, val);
                            continue;
                        }
                        Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
                        String json = (String)payload.get("json");
                        bvs = new EventModelVariableScope(json);
                        val = ExpressionCalculatorUtil.parseValue(null, bvs, string, new HashMap<String, Object>());
                        extraParams.put(name, val);
                        continue;
                    }
                    value = this.parseValue(sb, string, type, value, map);
                    extraParams.put(name, value);
                }
                Object[] objParams = new Object[extraParams.size()];
                int i = 0;
                for (Map.Entry entry : extraParams.entrySet()) {
                    objParams[i] = entry.getValue();
                    ++i;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add("WFS");
                list.add("DEV");
                list.add("EIP");
                list.add("SYS");
                String string = (String)cfg.get(CLOUD);
                if (list.contains(string)) {
                    Object var28_37 = null;
                }
                long beginMicroService = System.currentTimeMillis();
                try {
                    void var28_38;
                    if (WfUtils.isNotEmpty((String)var28_38)) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u3010%1$s\u3011\u4e91\u4e0b\u3010%2$s\u3011\u5e94\u7528\u7684\u5fae\u670d\u52a1\u63a5\u53e3\uff1b", (String)"EventMicroServiceJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0]), cloudname, appname));
                        result = DispatchServiceHelper.invokeBizService((String)cloud.toLowerCase(), (String)app, (String)servicename, (String)methodname, (Object[])objParams);
                    } else {
                        sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5e73\u53f0\u3010%s\u3011\u5e94\u7528\u7684\u5fae\u670d\u52a1\u63a5\u53e3\uff1b", (String)"EventMicroServiceJobHandler_8", (String)"bos-wf-engine", (Object[])new Object[0]), appname));
                        result = DispatchServiceHelper.invokeBOSService((String)app, (String)servicename, (String)methodname, (Object[])objParams);
                    }
                }
                finally {
                    TimeoutHandleFactory.get().doTimeoutMarker(true);
                }
                long endMicroService = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5fae\u670d\u52a1\u63a5\u53e3\u8017\u65f6%d\u5fae\u670d\u52a1\u6267\u884c\u5b8c\u6bd5\u3002", (String)"EventMicroServiceJobHandler_22", (String)"bos-wf-engine", (Object[])new Object[0]), endMicroService - beginMicroService));
                if (result != null) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a%s\u3002", (String)"EventMicroServiceJobHandler_11", (String)"bos-wf-engine", (Object[])new Object[0]), result));
                    break block24;
                }
                sb.append(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u63a5\u53e3\u65e0\u8fd4\u56de\u503c\u3002", (String)"EventMicroServiceJobHandler_21", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            catch (Exception e) {
                try {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u3010%1$d\u3011\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"EventMicroServiceJobHandler_12", (String)"bos-wf-engine", (Object[])new Object[0]), job.getId(), e.getMessage()));
                    String errorMsg = this.formatExecptionMsg(job, edContext, e);
                    try {
                        this.sendEventErrorMsg(edContext, errorMsg, job);
                    }
                    catch (Exception se) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u5f02\u5e38\u6d88\u606f\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"EventMicroServiceJobHandler_14", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.getExceptionStacktrace(se)));
                    }
                    throw new KDException((Throwable)e, WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6267\u884c\u5fae\u670d\u52a1\u5931\u8d25\uff1a%s\u3002", (String)"EventMicroServiceJobHandler_15", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage())});
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    sb.append(String.format(ResManager.loadKDString((String)"EventMicroServiceJobHandler\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventMicroServiceJobHandler_25", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                    if (evtLog != null) {
                        evtLog.setContent(sb.toString());
                        EvtLogUtils.saveEvtLog(evtLog);
                    }
                    throw throwable;
                }
            }
        }
        long end = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"EventMicroServiceJobHandler\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"EventMicroServiceJobHandler_25", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
        if (evtLog != null) {
            evtLog.setContent(sb.toString());
            EvtLogUtils.saveEvtLog(evtLog);
        }
    }

    private Object parseValue(StringBuilder sb, String expression, String type, Object value, Map<Object, Object> map) throws Exception {
        switch (type) {
            case "string": {
                value = this.transString(expression, value);
                break;
            }
            case "int": {
                value = this.transInt(expression, value);
                break;
            }
            case "double": {
                value = this.transDouble(expression, value);
                break;
            }
            case "long": {
                value = this.transLong(expression, value);
                break;
            }
            case "boolean": {
                value = this.transBoolean(expression, value);
                break;
            }
            case "datetime": {
                value = this.transDate(expression, value);
                break;
            }
            case "STRUCT": {
                ArrayList<Object> aList = new ArrayList<Object>();
                if (!(value instanceof String)) break;
                JSONObject jsonObject = JSONObject.parseObject((String)((String)((Object)value)));
                if ("List".equals(jsonObject.get((Object)"collection"))) {
                    String[] strs = this.formatList(jsonObject);
                    switch ((String)jsonObject.get((Object)"combofield1")) {
                        case "string": {
                            Object listVal;
                            String val;
                            int j;
                            for (j = 0; j < strs.length; ++j) {
                                val = strs[j];
                                listVal = (String)this.transString(strs[j], val);
                                aList.add(listVal);
                            }
                            break;
                        }
                        case "int": {
                            Object listVal;
                            String val;
                            int j;
                            for (j = 0; j < strs.length; ++j) {
                                val = strs[j];
                                listVal = (Integer)this.transInt(strs[j], val);
                                aList.add(listVal);
                            }
                            break;
                        }
                        case "double": {
                            Object listVal;
                            String val;
                            int j;
                            for (j = 0; j < strs.length; ++j) {
                                val = strs[j];
                                listVal = (BigDecimal)this.transDouble(strs[j], val);
                                aList.add(listVal);
                            }
                            break;
                        }
                        case "long": {
                            Object listVal;
                            String val;
                            int j;
                            for (j = 0; j < strs.length; ++j) {
                                val = strs[j];
                                listVal = (Long)this.transLong(strs[j], val);
                                aList.add(listVal);
                            }
                            break;
                        }
                        case "boolean": {
                            Object listVal;
                            String val;
                            int j;
                            for (j = 0; j < strs.length; ++j) {
                                val = strs[j];
                                listVal = (Boolean)this.transBoolean(strs[j], val);
                                aList.add(listVal);
                            }
                            break;
                        }
                        case "datetime": {
                            Object listVal;
                            String val;
                            int j;
                            for (j = 0; j < strs.length; ++j) {
                                val = strs[j];
                                listVal = (Boolean)this.transDate(strs[j], val);
                                aList.add(listVal);
                            }
                            break;
                        }
                    }
                    value = aList;
                }
                if (!"Map".equals(jsonObject.get((Object)"collection"))) break;
                String objValue = (String)jsonObject.get((Object)"value");
                if (WfUtils.isNotEmpty(objValue)) {
                    int j;
                    String combofield2 = (String)jsonObject.get((Object)"combofield2");
                    String combofield3 = (String)jsonObject.get((Object)"combofield3");
                    String str = objValue.substring(1, objValue.length() - 1);
                    String[] strs = str.split(",");
                    try {
                        for (j = 0; j < strs.length; ++j) {
                            String strList = strs[j];
                            String[] strLists = strList.split("=");
                            String param1 = strLists[0];
                            String param2 = strLists[1];
                            String parValue1 = strLists[0];
                            String parValue2 = strLists[1];
                            this.transList(aList, combofield2, param1, parValue1);
                            this.transList(aList, combofield3, param2, parValue2);
                        }
                    }
                    catch (Exception e) {
                        sb.append(String.format(ResManager.loadKDString((String)"Map\u503c%s\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\u3002", (String)"EventMicroServiceJobHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]), objValue));
                        break;
                    }
                    for (j = 0; j < aList.size(); j += 2) {
                        Object key = aList.get(j);
                        Object listValue = aList.get(j + 1);
                        map.put(key, listValue);
                    }
                    value = map;
                    break;
                }
                value = map;
            }
        }
        return value;
    }

    private void transList(List aList, String combofield, String param, Object parValue) throws Exception {
        switch (combofield) {
            case "string": {
                String listVal = null;
                listVal = (String)this.transString(param, parValue);
                aList.add(listVal);
                break;
            }
            case "int": {
                Integer listVal = (Integer)this.transInt(param, parValue);
                aList.add(listVal);
                break;
            }
            case "double": {
                BigDecimal listVal = (BigDecimal)this.transDouble(param, parValue);
                aList.add(listVal);
                break;
            }
            case "long": {
                Long listVal = (Long)this.transLong(param, parValue);
                aList.add(listVal);
                break;
            }
            case "boolean": {
                Boolean listVal = (Boolean)this.transBoolean(param, parValue);
                aList.add(listVal);
                break;
            }
            case "datetime": {
                Date listVal = (Date)this.transDate(param, parValue);
                aList.add(listVal);
                break;
            }
        }
    }

    public Object transString(String expression, Object value) throws Exception {
        if (!(value instanceof String)) {
            value = expression;
        }
        return value;
    }

    public Object transDouble(String expression, Object value) throws KDException {
        if (value instanceof String) {
            value = Double.parseDouble(expression);
        } else if (!(value instanceof Number)) {
            throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210\u6570\u5b57\uff1bval=%s", (String)"EventMicroServiceJobHandler_16", (String)"bos-wf-engine", (Object[])new Object[0]), value)});
        }
        return value;
    }

    public Object transInt(String expression, Object value) throws KDException {
        if (value instanceof String) {
            value = Integer.parseInt(expression);
        } else if (!(value instanceof Integer)) {
            throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3aint\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210int\u7c7b\u578b\uff1bval=%s", (String)"EventMicroServiceJobHandler_17", (String)"bos-wf-engine", (Object[])new Object[0]), value)});
        }
        return value;
    }

    public Object transLong(String expression, Object value) throws KDException {
        if (value instanceof String) {
            value = Long.valueOf((String)value);
        } else if (!(value instanceof Long)) {
            throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3aLong\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210Long\uff1bval=%s", (String)"EventMicroServiceJobHandler_18", (String)"bos-wf-engine", (Object[])new Object[0]), value)});
        }
        return value;
    }

    public Object transBoolean(String expression, Object value) throws KDException {
        if (value instanceof String) {
            value = Boolean.valueOf((String)value);
        } else if (!(value instanceof Boolean)) {
            throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3aBoolean\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210Boolean\uff1bval=%s", (String)"EventMicroServiceJobHandler_19", (String)"bos-wf-engine", (Object[])new Object[0]), value)});
        }
        return value;
    }

    public Object transDate(String expression, Object value) throws KDException {
        if (value instanceof String) {
            value = new Date((String)value);
        } else if (!(value instanceof Date)) {
            throw new KDException(WFErrorCode.eventArgsParseJsonError(), new Object[]{String.format(ResManager.loadKDString((String)"val\u7c7b\u578b\u5e94\u8be5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0c\u4f46\u662f\u4e0d\u80fd\u8f6c\u6362\u6210\u65e5\u671f\uff1bval=%s", (String)"EventMicroServiceJobHandler_20", (String)"bos-wf-engine", (Object[])new Object[0]), value)});
        }
        return value;
    }

    public String[] formatList(JSONObject jsonObject) {
        String value = (String)jsonObject.get((Object)"value");
        String str = "";
        String[] strs = null;
        if (WfUtils.isNotEmpty(value)) {
            str = value.substring(1, value.length() - 1);
            strs = str.split(",");
        }
        return strs;
    }
}

