/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.bec.model.EntityEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.BECEngineException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;

public class EventStartProcessJobHandler
extends AbstractEventServiceJobHandler {
    public static final String TYPE = "event-start-process";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        EventDispatchContext edContext = null;
        try {
            edContext = this.restoreEventContext(configuration);
            WorkflowServiceImpl service = (WorkflowServiceImpl)ServiceFactory.getService(WorkflowService.class);
            String json = edContext.getJson();
            JSONObject jsonParam = JSON.parseObject((String)json);
            String businessKey = null;
            String entityNumber = null;
            if (jsonParam != null) {
                entityNumber = (String)jsonParam.remove((Object)"entityNumber");
                businessKey = (String)jsonParam.remove((Object)"businessKey");
            } else if (edContext.getEvent() instanceof EntityEvent) {
                EntityEvent entityEvent = (EntityEvent)edContext.getEvent();
                entityNumber = entityEvent.getEntityNumber();
                List businessKeys = entityEvent.getBusinesskeys();
                if (businessKeys != null && !businessKeys.isEmpty()) {
                    businessKey = (String)businessKeys.get(0);
                }
            }
            if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmpty(businessKey)) {
                throw new BECEngineException("entityNumber is empty or businessKey is empty,cannot be null.", null);
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("entityNumber", entityNumber);
            variables.put("businessKey", businessKey);
            if (jsonParam != null && !jsonParam.isEmpty()) {
                variables.put("biztraceno", jsonParam.remove((Object)"biztraceno"));
                variables.put("targetProcEntityNumber", jsonParam.remove((Object)"targetProcEntityNumber"));
                variables.put("processInstanceId", jsonParam.getLong("processInstanceId"));
                Iterator iter = jsonParam.keySet().iterator();
                if (iter.hasNext()) {
                    String key = (String)iter.next();
                    variables.put(key, jsonParam.get((Object)key));
                }
            }
            service.tryTriggerProcessByEvent(entityNumber, new String[]{businessKey}, edContext.getEvent().getEventNumber(), variables);
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
            throw e;
        }
    }
}

