/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventService;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.EvtLogUtils;
import kd.bos.bec.engine.exception.EVTIgnoreRetryException;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.script.ScriptExecutor;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.event.EventLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class ExecutePluginJobHandler
extends AbstractEventServiceJobHandler {
    private static final String HANDLE_EVENT = "handleEvent";
    private static final String INVOKE_EVENT_PLUGIN = "invokeEventPlugin";
    public static final String CFG_TYPE = "type";
    public static final String CFG_VALUE = "value";
    public static final String CLASS = "class";
    public static final String TYPE_SCRIPT = "script";
    public static final String TYPE = "event-execute-plugin";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return "execute java plugin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        long begin = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        String plugin = "";
        EventLogEntity evtLog = null;
        EventDispatchContext edContext = this.restoreEventContext(configuration);
        String appIdInput = null;
        try {
            block23: {
                this.transferEvtLine(job, commandContext, sb, edContext);
                if (WfUtils.isNotEmpty(configuration)) {
                    this.changeContext(configuration, edContext);
                }
                sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u8c03\u7528\u6267\u884c\u63d2\u4ef6\u670d\u52a1\uff1a", (String)"ExecutePluginJobHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                evtLog = this.buildEventLog(edContext, job);
                String serviceCfg = edContext.getSubscriptionConfig();
                Map cfg = (Map)SerializationUtils.fromJsonString((String)serviceCfg, Map.class);
                if (TYPE_SCRIPT.equals(cfg.get(CFG_TYPE))) {
                    plugin = (String)cfg.get(CFG_VALUE);
                    sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u811a\u672c\u63d2\u4ef6\uff1a%s\u3002", (String)"ExecutePluginJobHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]), plugin));
                    String content = this.getScriptContent(plugin);
                    ScriptExecutor executor = ScriptExecutor.getOrCreate();
                    executor.init(ctx -> ctx.require(new String[]{"/WorkflowScriptModule.conf"}));
                    try {
                        executor.begin();
                        executor.exec(new String[]{content});
                        try {
                            executor.call("plugin.handleEvent", new Object[]{edContext.getEvent()});
                            break block23;
                        }
                        finally {
                            TimeoutHandleFactory.get().doTimeoutMarker(true);
                        }
                    }
                    catch (Exception e) {
                        this.log.error(String.format("\u5916\u90e8\u63a5\u53e3(\u811a\u672c)\u6267\u884c\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
                        throw e;
                    }
                    finally {
                        executor.end();
                    }
                }
                plugin = (String)cfg.get(CFG_VALUE);
                Map plugincfg = null;
                String appId = "wf";
                long beginExecutePlugin = System.currentTimeMillis();
                if (plugin.contains("appid") && plugin.endsWith("}")) {
                    plugincfg = (Map)SerializationUtils.fromJsonString((String)plugin, Map.class);
                    sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884cJava\u63d2\u4ef6\uff1a%s\u3002", (String)"ExecutePluginJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0]), plugincfg.get(CLASS)));
                    if (!WfUtils.isEmpty((String)plugincfg.get("appid"))) {
                        appIdInput = appId = (String)plugincfg.get("appid");
                    }
                    WfCommonUtil.invokeBOSServiceByAppId((String)appId, (String)IEventService.class.getSimpleName(), (String)INVOKE_EVENT_PLUGIN, (Object[])new Object[]{plugincfg.get(CLASS), HANDLE_EVENT, new Object[]{edContext.getEvent()}});
                } else {
                    sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884cJava\u63d2\u4ef6\uff1a%s\u3002", (String)"ExecutePluginJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0]), plugin));
                    KDBizEvent event = edContext.getEvent();
                    if (event instanceof EntityEvent) {
                        String entityNumber = ((EntityEvent)event).getEntityNumber();
                        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
                        appId = dt.getAppId();
                    }
                    WfCommonUtil.invokeBOSServiceByAppId((String)appId, (String)IEventService.class.getSimpleName(), (String)INVOKE_EVENT_PLUGIN, (Object[])new Object[]{plugin, HANDLE_EVENT, new Object[]{edContext.getEvent()}});
                }
                long endExecutePlugin = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5fae\u670d\u52a1\u8c03\u7528\u63d2\u4ef6\u8017\u65f6%d", (String)"ExecutePluginJobHandler_8", (String)"bos-wf-engine", (Object[])new Object[0]), endExecutePlugin - beginExecutePlugin));
            }
            sb.append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecutePluginJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (Exception e) {
            try {
                List<String> registeredAppIdArray;
                String registeredAppIds;
                String errorMsg = this.formatExecptionMsg(job, edContext, e);
                sb.append(String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u3010\u6267\u884c\u63d2\u4ef6[%1$s]\uff08%2$d\uff09\u3011\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%3$s", (String)"ExecutePluginJobHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]), plugin, job.getId(), WfUtils.getExceptionStacktrace(e)));
                try {
                    this.sendEventErrorMsg(edContext, errorMsg, job);
                }
                catch (Exception se) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u5f02\u5e38\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ExecutePluginJobHandler_6", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.getExceptionStacktrace(se)));
                }
                if (appIdInput != null && StringUtils.isNotBlank((CharSequence)(registeredAppIds = System.getProperty("registedAppIds"))) && (registeredAppIdArray = Arrays.asList(registeredAppIds.split(","))) != null && registeredAppIdArray.size() > 0 && !registeredAppIdArray.contains(appIdInput)) {
                    this.log.debug(String.format("appid-%s\u6ca1\u6709\u6ce8\u518c\uff0c\u4e0d\u91cd\u8bd5\uff0c\u76f4\u63a5\u6302\u8d77\u3002", appIdInput));
                    sb.append(String.format(ResManager.loadKDString((String)"appid-%s\u6ca1\u6709\u6ce8\u518c\uff0c\u4e0d\u91cd\u8bd5\uff0c\u76f4\u63a5\u6302\u8d77\u3002", (String)"ExecutePluginJobHandler_10", (String)"bos-wf-engine", (Object[])new Object[0]), appIdInput));
                    throw new EVTIgnoreRetryException(e, WFErrorCode.bizEventError(), String.format(ResManager.loadKDString((String)"\u6267\u884c\u63d2\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ExecutePluginJobHandler_7", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
                }
                throw new KDException((Throwable)e, WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6267\u884c\u63d2\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ExecutePluginJobHandler_7", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage())});
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"ExecutePluginJobHandler\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"ExecutePluginJobHandler_9", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                if (evtLog != null) {
                    evtLog.setContent(sb.toString());
                    EvtLogUtils.saveEvtLog(evtLog);
                }
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"ExecutePluginJobHandler\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"ExecutePluginJobHandler_9", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
        if (evtLog != null) {
            evtLog.setContent(sb.toString());
            EvtLogUtils.saveEvtLog(evtLog);
        }
    }

    private String getScriptContent(String scriptId) {
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)"ikUhzW1W", (String)"ide_pluginscript", (String)"id,txt_scriptcontext_tag");
        return dynObj.getString("txt_scriptcontext_tag");
    }
}

