/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.EvtLogUtils;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.bec.engine.servicehanler.EventJobHandlerUtil;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.event.EventLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.HttpClientUtil;

public class TriggerHttpApiJobHandler
extends AbstractEventServiceJobHandler {
    public static final String TYPE = "trigger-http-api";
    public static final String AUTHTYPE = "authtype";
    public static final String AUTHTYPE_NOAUTH = "noAuth";
    public static final String AUTHTYPE_AUTH = "auth";
    public static final String AUTHCCONFIG = "authcconfig";
    public static final String REQUESTTYPE = "requesttype";
    public static final String REQUESTTYPE_GET = "GET";
    public static final String REQUESTTYPE_POST = "POST";
    public static final String URL = "url";
    public static final String HEAD = "head";
    public static final String BODY = "body";
    public static final String ENTRY_URL = "urlentry";
    public static final String CERTIFICATION = "certification";
    public static final String CERTIFICATION_CLIENT = "client_credentials";
    public static final String TOKENURL = "tokenurl";
    public static final String CLIENTID = "clientid";
    public static final String CLIENTSECRET = "clientsecret";
    public static final String TOKENPATH = "tokenpath";
    public static final String TOKENKEY = "tokenkey";
    public static final String TOKENPOSITION = "tokenposition";
    public static final String EXTPARAMS = "extparams";
    public static final String STATEPATH = "statepath";
    public static final String SUCCESSCODE = "successcode";
    public static final String BODYEQ = ",body=";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return "trigger http api";
    }

    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        long begin = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884cTriggerHttpApiJobHandler\uff1a%d", (String)"TriggerHttpApiJobHandler_22", (String)"bos-wf-engine", (Object[])new Object[0]), begin));
        EventLogEntity evtLog = null;
        EventDispatchContext edContext = this.restoreEventContext(configuration);
        try {
            if (WfUtils.isNotEmpty(configuration)) {
                this.changeContext(configuration, edContext);
            }
            sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u8c03\u7528http\u670d\u52a1\uff1a", (String)"TriggerHttpApiJobHandler_10", (String)"bos-wf-engine", (Object[])new Object[0]));
            evtLog = this.buildEventLog(edContext, job);
            String config = edContext.getSubscriptionConfig();
            Map httpConfig = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
            String requestType = (String)httpConfig.get(REQUESTTYPE);
            String url = (String)httpConfig.get(URL);
            VariableScope vs = this.getVariableScope(job, edContext.getEvent());
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            header.putAll(this.formatMapDescToMap((List)httpConfig.get(HEAD), "headkey", "headvalue", vs));
            Map body = this.formatMapDescToMap((List)httpConfig.get(BODY), "bodykey", "bodyvalue", vs);
            Map extURL = this.formatMapDescToMap((List)httpConfig.get(ENTRY_URL), "urlkey", "urlvalue", vs);
            url = this.buildURL(url, extURL);
            String authType = (String)httpConfig.get(AUTHTYPE);
            if (!AUTHTYPE_NOAUTH.equals(authType)) {
                String position;
                Map authConfig = (Map)SerializationUtils.fromJsonString((String)((String)httpConfig.get(AUTHCCONFIG)), Map.class);
                String token = this.getToken(authConfig, vs, authType, sb);
                if (WfUtils.isEmpty(token)) {
                    throw new KDException(WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a\uff0c\u53c2\u6570\u201c%s\u201d\u3002", (String)"TriggerHttpApiJobHandler_0", (String)"bos-wf-engine", (Object[])new Object[0]), token)});
                }
                String tokenKey = (String)httpConfig.get(TOKENKEY);
                switch (position = (String)httpConfig.get(TOKENPOSITION)) {
                    case "head": {
                        header.put(tokenKey, token);
                        break;
                    }
                    case "body": {
                        body.put(tokenKey, token);
                        break;
                    }
                    case "url": {
                        url = url.contains("?") ? String.format("%s&%s=%s", url, tokenKey, token) : String.format("%s?%s=%s", url, tokenKey, token);
                        break;
                    }
                    default: {
                        throw new KDException(WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u62fc\u63a5token\u5931\u8d25\uff0c\u53c2\u6570\u201c%1$s\u201d\uff0ctoken\u201c%2$s\u201d\u3002", (String)"TriggerHttpApiJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), authConfig, token)});
                    }
                }
            }
            this.triggerHttpService(httpConfig, requestType, url, header, body, sb);
        }
        catch (Exception e) {
            try {
                sb.append(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s%2$s\u3002%1$s", (String)"TriggerHttpApiJobHandler_11", (String)"bos-wf-engine", (Object[])new Object[0]), "\r\n", WfUtils.getExceptionStacktrace(e)));
                String errorMsg = this.formatExecptionMsg(job, edContext, e);
                try {
                    this.sendEventErrorMsg(edContext, errorMsg, job);
                }
                catch (Exception se) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u53d1\u9001\u5f02\u5e38\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"TriggerHttpApiJobHandler_19", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.getExceptionStacktrace(se)));
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"TriggerHttpApiJobHandler\u6267\u884c\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"TriggerHttpApiJobHandler_20", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
                if (evtLog != null) {
                    evtLog.setContent(sb.toString());
                    EvtLogUtils.saveEvtLog(evtLog);
                }
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"TriggerHttpApiJobHandler\u6267\u884c\u8017\u65f6\uff1a%dms\uff0c\u6267\u884c\u961f\u5217\uff1a%s\u3002", (String)"TriggerHttpApiJobHandler_20", (String)"bos-wf-engine", (Object[])new Object[0]), end - begin, job.getQueueName()));
        if (evtLog != null) {
            evtLog.setContent(sb.toString());
            EvtLogUtils.saveEvtLog(evtLog);
        }
    }

    private void triggerHttpService(Map<String, Object> map, String requestType, String url, Map<String, String> header, Map<String, Object> body, StringBuilder sb) {
        long beginTriggerHttpService = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"\u89e6\u53d1http\u63a5\u53e3\uff1a%d", (String)"TriggerHttpApiJobHandler_23", (String)"bos-wf-engine", (Object[])new Object[0]), beginTriggerHttpService));
        try {
            String result = "";
            if (REQUESTTYPE_GET.equals(requestType)) {
                sb.append(String.format(ResManager.loadKDString((String)"\u901a\u8fc7GET\u65b9\u5f0f\u8c03\u7528http\uff0c\u53c2\u6570url\uff1a%1$s\uff0cheader\uff1a%2$s\uff0cbody\uff1a%3$s\u3002", (String)"TriggerHttpApiJobHandler_12", (String)"bos-wf-engine", (Object[])new Object[0]), url, WfUtils.mapToString(header), WfUtils.mapToString(body)));
                result = HttpClientUtil.get(url, header, body);
            } else {
                String bjson = SerializationUtils.toJsonString(body);
                sb.append(String.format(ResManager.loadKDString((String)"\u901a\u8fc7POST\u65b9\u5f0f\u8c03\u7528http\uff0c\u53c2\u6570url\uff1a%1$s\uff0cheader\uff1a%2$s\uff0cbody\uff1a%3$s\u3002", (String)"TriggerHttpApiJobHandler_13", (String)"bos-wf-engine", (Object[])new Object[0]), url, WfUtils.mapToString(header), bjson));
                result = HttpClientUtil.postjson(url, header, bjson);
            }
            sb.append(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\uff1a\u3010%s\u3011\uff1b", (String)"TriggerHttpApiJobHandler_14", (String)"bos-wf-engine", (Object[])new Object[0]), result));
            String statePath = (String)map.get(STATEPATH);
            String successCode = (String)map.get(SUCCESSCODE);
            if (WfUtils.isNotEmpty(statePath)) {
                if (WfUtils.isEmpty(result)) {
                    throw new KDException(WFErrorCode.bizEventError(), new Object[]{ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u72b6\u6001\u8def\u5f84\u3002", (String)"TriggerHttpApiJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                if (WfUtils.isNotEmpty(successCode)) {
                    JSONObject rsJson = JSON.parseObject((String)result);
                    String[] path = statePath.split("\\.");
                    Object tmp = rsJson;
                    for (int i = 0; i < path.length; ++i) {
                        if ((tmp = tmp.get((Object)path[i])) != null) continue;
                        throw new KDException(WFErrorCode.bizEventError(), new Object[]{ResManager.loadKDString((String)"\u62ff\u4e0d\u5230\u72b6\u6001\u3002", (String)"TriggerHttpApiJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0])});
                    }
                    if (!successCode.equals(String.valueOf(tmp))) {
                        throw new KDException(WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u4fe1\u606f\u5e94\u4e3a\u3010%1$s\u3011\uff0c\u771f\u5b9e\u4e3a\u3010%2$s\u3011\u3002", (String)"TriggerHttpApiJobHandler_6", (String)"bos-wf-engine", (Object[])new Object[0]), successCode, tmp)});
                    }
                }
            }
            sb.append(ResManager.loadKDString((String)"\u8c03\u7528http\u670d\u52a1\u6210\u529f\u3002", (String)"TriggerHttpApiJobHandler_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (Exception e) {
            try {
                throw new KDException(WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u8c03\u7528http\u5931\u8d25\u539f\u56e0\uff1a\u3010%1$s\u3011\uff0curl\u3010%2$s\u3011\uff0cheader\u3010%3$s\u3011\uff0cbody\u3010%4$s\u3011\uff0c\u5806\u6808\u3010%5$s\u3011", (String)"TriggerHttpApiJobHandler_7", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage(), url, WfUtils.mapToString(header), WfUtils.mapToString(body), WfUtils.getExceptionStacktrace(e))});
            }
            catch (Throwable throwable) {
                long endTriggerHttpService = System.currentTimeMillis();
                sb.append(String.format(ResManager.loadKDString((String)"\u89e6\u53d1HTTP\u63a5\u53e3\u8017\u65f6\uff1a%d\u3002", (String)"TriggerHttpApiJobHandler_21", (String)"bos-wf-engine", (Object[])new Object[0]), beginTriggerHttpService - endTriggerHttpService));
                throw throwable;
            }
        }
        long endTriggerHttpService = System.currentTimeMillis();
        sb.append(String.format(ResManager.loadKDString((String)"\u89e6\u53d1HTTP\u63a5\u53e3\u8017\u65f6\uff1a%d\u3002", (String)"TriggerHttpApiJobHandler_21", (String)"bos-wf-engine", (Object[])new Object[0]), beginTriggerHttpService - endTriggerHttpService));
    }

    private String getToken(Map<String, Object> authConfig, VariableScope vs, String authType, StringBuilder sb) throws IOException {
        try {
            JSONObject rsJson;
            String certification = (String)authConfig.get(CERTIFICATION);
            String tokenUrl = (String)authConfig.get(TOKENURL);
            JSONObject params = new JSONObject();
            if (AUTHTYPE_AUTH.equals(authType)) {
                params.put("grant_type", (Object)certification);
                params.put("client_id", authConfig.get(CLIENTID));
                if (!"password".equals(certification)) {
                    String cilentSecret = (String)authConfig.get(CLIENTSECRET);
                    if (!WfUtils.isEmpty(cilentSecret)) {
                        cilentSecret = cilentSecret.startsWith("d@f*g:") ? Encrypters.decode((String)cilentSecret) : cilentSecret;
                    }
                    params.put("client_secret", (Object)cilentSecret);
                }
            }
            params.putAll(this.formatMapDescToMap((List)authConfig.get(EXTPARAMS), "key", "value", vs));
            HashMap<String, String> tokenHeader = new HashMap<String, String>();
            tokenHeader.put("Content-Type", "application/json");
            String bodyJson = SerializationUtils.toJsonString((Object)params);
            sb.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\uff0c\u53c2\u6570tokenUrl\uff1a%1$s\uff0ctokenHeader=%2$s\u3002", (String)"TriggerHttpApiJobHandler_16", (String)"bos-wf-engine", (Object[])new Object[0]), tokenUrl, WfUtils.mapToString(tokenHeader)));
            String tokenJson = HttpClientUtil.postjson(tokenUrl, tokenHeader, bodyJson);
            sb.append(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u3010%s\u3011\uff1b", (String)"TriggerHttpApiJobHandler_17", (String)"bos-wf-engine", (Object[])new Object[0]), tokenJson));
            String tokenPath = (String)authConfig.get(TOKENPATH);
            if (WfUtils.isEmpty(tokenJson)) {
                throw new KDException(WFErrorCode.bizEventError(), new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6token\u4e3a\u7a7a\u3002", (String)"TriggerHttpApiJobHandler_8", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            String[] path = tokenPath.split("\\.");
            Object tmp = rsJson = JSON.parseObject((String)tokenJson);
            String token = "";
            for (int i = 0; i < path.length; ++i) {
                if ((tmp = tmp.get((Object)path[i])) != null) continue;
                throw new KDException(WFErrorCode.bizEventError(), new Object[]{ResManager.loadKDString((String)"\u62ff\u4e0d\u5230\u72b6\u6001\u3002", (String)"TriggerHttpApiJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            token = (String)tmp;
            sb.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token=%s\u3002", (String)"TriggerHttpApiJobHandler_18", (String)"bos-wf-engine", (Object[])new Object[0]), token));
            return token;
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u51fa\u9519\uff0c\u539f\u56e0\uff1a%1$s\uff0c\u5806\u6808\uff1a%2$s\u3002", (String)"TriggerHttpApiJobHandler_9", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage(), WfUtils.getExceptionStacktrace(e))});
        }
    }

    private String buildURL(String url, Map<String, Object> extURL) {
        String newURL;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url);
        if (!extURL.isEmpty()) {
            urlBuilder.append('?');
            Set<Map.Entry<String, Object>> entrys = extURL.entrySet();
            for (Map.Entry<String, Object> entry : entrys) {
                urlBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
            }
        }
        newURL = (newURL = urlBuilder.toString()).endsWith("&") ? newURL.substring(0, newURL.length() - 1) : newURL;
        return newURL;
    }

    private Map formatMapDescToMap(List<Map<String, Object>> mapDesc, String keyName, String valueName, VariableScope variableScope) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (mapDesc != null && !mapDesc.isEmpty()) {
            for (Map<String, Object> item : mapDesc) {
                String key = (String)item.get(keyName);
                if (!WfUtils.isNotEmpty(key)) continue;
                String expression = (String)item.get(valueName);
                if (!WfUtils.isEmpty(expression)) {
                    expression = expression.startsWith("d@f*g:") ? Encrypters.decode((String)expression) : expression;
                }
                Object value = expression;
                if (WfUtils.isNotEmpty(expression) && expression.startsWith("${")) {
                    value = ExpressionCalculatorUtil.parseValue(null, variableScope, expression, null, true);
                }
                result.put(key, (String)value);
            }
        }
        return result;
    }

    private VariableScope getVariableScope(EvtJobEntity job, KDBizEvent event) {
        if (event instanceof EntityEvent) {
            return new BusinessModelVariableScope((String)((EntityEvent)event).getBusinesskeys().get(0), ((EntityEvent)event).getEntityNumber());
        }
        String json = EventJobHandlerUtil.getJsonEventSrcByJobId(job.getSrcJobId());
        return new EventModelVariableScope(json);
    }
}

