/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.pojo.BusinessObject;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.bec.model.EntityEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;

public class TryCloseBizFlowEventHandler
extends AbstractEventServiceJobHandler {
    public static final String TYPE = "tryCloseBizFlow";
    private static final String APSETTLERECORD = "ap_settlerecord";
    private static final String MAINBILLID = "mainbillid";
    private static final String BILLENTITY = "billentity";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return "try Close BizFlow";
    }

    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        block17: {
            EventDispatchContext edContext = null;
            try {
                edContext = this.restoreEventContext(configuration);
                WorkflowServiceImpl service = (WorkflowServiceImpl)ServiceFactory.getService(WorkflowService.class);
                String json = edContext.getJson();
                JSONObject jsonParam = JSON.parseObject((String)json);
                List businessKeys = new ArrayList<String>(4);
                String entityNumber = null;
                if (jsonParam != null) {
                    entityNumber = (String)jsonParam.remove((Object)"entityNumber");
                    String businessKey = (String)jsonParam.remove((Object)"businessKey");
                    businessKeys.add(businessKey);
                } else if (edContext.getEvent() instanceof EntityEvent) {
                    EntityEvent entityEvent = (EntityEvent)edContext.getEvent();
                    entityNumber = entityEvent.getEntityNumber();
                    businessKeys = entityEvent.getBusinesskeys();
                }
                if (WfUtils.isEmpty(entityNumber) || WfUtils.isEmptyForCollection(businessKeys)) {
                    return;
                }
                if (!APSETTLERECORD.equalsIgnoreCase(entityNumber) || !WfUtils.isNotEmptyForCollection(businessKeys)) break block17;
                QFilter[] qFilters = new QFilter[]{new QFilter("entitynumber", "=", (Object)"ap_finapbill"), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())};
                if (!QueryServiceHelper.exists((String)"wf_processconfig", (QFilter[])qFilters)) {
                    return;
                }
                ArrayList<Long> t = new ArrayList<Long>(businessKeys.size());
                for (String str : businessKeys) {
                    t.add(Long.parseLong(str));
                }
                DynamicObject[] o = BusinessDataServiceHelper.load((String)entityNumber, (String)String.format("%s,%s,%s,%s", MAINBILLID, BILLENTITY, "entry.billid", "entry.e_billentity"), (QFilter[])new QFilter[]{new QFilter("id", "in", t)});
                if (o == null || o.length <= 0) break block17;
                ArrayList<String> apBillBo = new ArrayList<String>(o.length);
                HashMap<String, List<BusinessObject>> casbills = new HashMap<String, List<BusinessObject>>();
                for (DynamicObject dyn : o) {
                    String apBillId = dyn.getString(MAINBILLID);
                    apBillBo.add(apBillId);
                    DynamicObjectCollection cols = dyn.getDynamicObjectCollection("entry");
                    if (cols == null || cols.isEmpty()) continue;
                    for (DynamicObject col : cols) {
                        Long srcBillId = col.getLong("billid");
                        String srcEntity = col.getString("e_billentity");
                        if (!"cas_paybill".equalsIgnoreCase(srcEntity)) continue;
                        ArrayList<BusinessObject> allEntry = (ArrayList<BusinessObject>)casbills.get(apBillId);
                        if (allEntry == null) {
                            allEntry = new ArrayList<BusinessObject>();
                        }
                        allEntry.add(new BusinessObject(srcEntity, WfUtils.isEmpty(srcBillId) ? "" : String.valueOf(srcBillId)));
                        casbills.put(apBillId, allEntry);
                    }
                }
                if (WfUtils.isNotEmptyForCollection(apBillBo)) {
                    try {
                        service.tryCloseBizFlow(apBillBo);
                    }
                    catch (Exception e) {
                        logger.info(String.format("tryCloseBizFlow error for [%s],error is [%s]", WfUtils.listToString(apBillBo, ","), WfUtils.getExceptionStacktrace(e)));
                    }
                }
                if (WfUtils.isNotEmptyForMap(casbills)) {
                    try {
                        service.tryMountTargetBySrcBill(casbills);
                    }
                    catch (Exception e) {
                        logger.info(String.format("addToCirculateRelationBySrcBill error for [%s],error is [%s]", WfUtils.mapToString(casbills), WfUtils.getExceptionStacktrace(e)));
                    }
                }
            }
            catch (Exception e) {
                this.log.info(WfUtils.getExceptionStacktrace(e));
                throw e;
            }
        }
    }
}

