/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.servicehanler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.AbstractEventServiceJobHandler;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class UpdateRPAStatusJobHandler
extends AbstractEventServiceJobHandler {
    public static final String TYPE = "update-RPA-status";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(EvtJobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        try {
            EventDispatchContext edContext = this.restoreEventContext(configuration);
            String json = edContext.getJson();
            if (WfUtils.isEmpty(json)) {
                this.log.debug(String.format("json is null. %s", job.getId()));
                return;
            }
            JSONObject jsonParam = JSON.parseObject((String)json);
            String rpaTaskId = jsonParam.getString("rpa_taskid");
            String rpaStatus = jsonParam.getString("rpa_status");
            WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Comment comment = service.createNewComment();
            comment.setMessage(this.getStatus(rpaStatus));
            service.updateTrdRelatedProcComment(rpaTaskId, comment);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
            throw e;
        }
    }

    private ILocaleString getStatus(String rpaStatus) {
        switch (rpaStatus) {
            case "running": {
                return WfUtils.getPromptWordLocaleString("\u6b63\u5728\u8fd0\u884c", "UpdateRPAStatusJobHandler_1", "bos-wf-engine");
            }
            case "pending": {
                return WfUtils.getPromptWordLocaleString("\u5f85\u6267\u884c", "UpdateRPAStatusJobHandler_2", "bos-wf-engine");
            }
            case "success": {
                return WfUtils.getPromptWordLocaleString("\u8fd0\u884c\u6210\u529f", "UpdateRPAStatusJobHandler_3", "bos-wf-engine");
            }
            case "failed": {
                return WfUtils.getPromptWordLocaleString("\u8fd0\u884c\u5931\u8d25", "UpdateRPAStatusJobHandler_4", "bos-wf-engine");
            }
            case "stopping": {
                return WfUtils.getPromptWordLocaleString("\u51c6\u5907\u505c\u6b62", "UpdateRPAStatusJobHandler_5", "bos-wf-engine");
            }
            case "stopped": {
                return WfUtils.getPromptWordLocaleString("\u5df2\u505c\u6b62", "UpdateRPAStatusJobHandler_6", "bos-wf-engine");
            }
            case "pendout": {
                return WfUtils.getPromptWordLocaleString("\u7b49\u5f85\u8d85\u65f6", "UpdateRPAStatusJobHandler_7", "bos-wf-engine");
            }
        }
        return new LocaleString(rpaStatus);
    }
}

