/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.engine.utils;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.bec.engine.utils.BatchStandardTipsBodyBuilder;
import kd.bos.bec.engine.utils.BatchStandardTipsTitleBuilder;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;

public class StandardTips {
    private IFormView view;

    public static StandardTips view(IFormView view) {
        StandardTips standardTips = new StandardTips();
        standardTips.view = view;
        return standardTips;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public void notSelectRow() {
        this.view.showTipNotification(StandardTips.notSelectRowTips());
    }

    public void selectMultiRow(int count) {
        if (count == 0) {
            this.notSelectRow();
            return;
        }
        this.view.showTipNotification(StandardTips.selectMultiRowTips(count));
    }

    public void noPerm(String entityName, String permName) {
        String tips = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StandardTips_7", (String)"bos-wf-engine", (Object[])new Object[0]);
        String format = String.format(tips, entityName, permName);
        this.view.showErrorNotification(format);
    }

    public void batchOptionMsg(String handleName, List<?> successList, List<?> failList) {
        this.batchOptionMsg(handleName, successList, failList, null);
    }

    public void batchAllSuccess(String handleName) {
        String tips = ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"StandardTips_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        String format = String.format(tips, handleName);
        this.view.showSuccessNotification(format);
    }

    public void batchOptionMsg(String handleName, int total, List<?> failList) {
        if (failList == null || failList.isEmpty()) {
            this.batchAllSuccess(handleName);
            return;
        }
        String title = new BatchStandardTipsTitleBuilder().setFailCount(failList.size()).setSuccessCount(total - failList.size()).setHandleName(handleName).setTotal(total).build();
        String body = StandardTips.batchOptionMsgContent(failList);
        FormShowParameter parameter = this.buildTipsParam(title, body, null);
        this.view.showForm(parameter);
    }

    public void batchOptionMsg(String handleName, List<?> successList, List<?> failList, FormShowParameter hyperLink) {
        if (failList == null || failList.isEmpty()) {
            this.batchAllSuccess(handleName);
            return;
        }
        String titleTemplate = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"StandardTips_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        successList = Optional.ofNullable(successList).orElseGet(() -> new ArrayList(0));
        String title = String.format(titleTemplate, successList.size() + failList.size(), handleName, successList.size(), failList.size());
        String body = StandardTips.batchOptionMsgContent(failList);
        FormShowParameter parameter = this.buildTipsParam(title, body, hyperLink);
        this.view.showForm(parameter);
    }

    public void batchOptionMsg(String handleName, int successCount, int failCount, String content, FormShowParameter hyperLink) {
        if (failCount == 0) {
            this.batchAllSuccess(handleName);
            return;
        }
        String titleTemplate = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"StandardTips_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        String title = String.format(titleTemplate, successCount + failCount, handleName, successCount, failCount);
        String body = "<div style=\"width: 100%; height: initial;\">\n" + content + "</div>";
        FormShowParameter parameter = this.buildTipsParam(title, body, hyperLink);
        this.view.showForm(parameter);
    }

    public void batchOptionMsg(String handleName, int successCount, int failCount, String content) {
        this.batchOptionMsg(handleName, successCount, failCount, content, null);
    }

    public void batchOptionMsg(String title, String body) {
        FormShowParameter parameter = this.buildTipsParam(title, body, null);
        this.view.showForm(parameter);
    }

    public void batchOptionMsg(String msg) {
        FormShowParameter parameter = this.buildTipsParam(msg, null, null);
        this.view.showForm(parameter);
    }

    public FormShowParameter buildTipsParam(String title, String body, FormShowParameter hyperLink) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_batchstandardtips");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("title", (Object)title);
        param.setCustomParam("body", (Object)body);
        if (hyperLink != null) {
            param.setCustomParam("parameterConfig", (Object)FormShowParameter.toJsonString((FormShowParameter)hyperLink));
        }
        return param;
    }

    public FormShowParameter buildTipsParam(BatchStandardTipsTitleBuilder title, BatchStandardTipsBodyBuilder body, FormShowParameter hyperLink) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_batchstandardtips");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("title", (Object)Optional.ofNullable(title).map(BatchStandardTipsTitleBuilder::build).orElseGet(() -> ""));
        param.setCustomParam("body", (Object)Optional.ofNullable(body).map(BatchStandardTipsBodyBuilder::build).orElseGet(() -> ""));
        if (hyperLink != null) {
            param.setCustomParam("parameterConfig", (Object)FormShowParameter.toJsonString((FormShowParameter)hyperLink));
        }
        return param;
    }

    public void batchOptionMsg(String title, String body, FormShowParameter hyperLink) {
        FormShowParameter parameter = this.buildTipsParam(title, body, hyperLink);
        this.view.showForm(parameter);
    }

    public static String notSelectRowTips() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"StandardTips_0", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String selectMultiRowTips(int count) {
        if (count == 0) {
            return StandardTips.notSelectRowTips();
        }
        return String.format(StandardTips.selectMultiRowTips(), count);
    }

    public static String selectMultiRowTips() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86%s\u884c\u3002", (String)"StandardTips_1", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    public static String noPermTips(String entityName, String handleName) {
        String tips = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StandardTips_7", (String)"bos-wf-engine", (Object[])new Object[0]);
        return String.format(tips, entityName, handleName);
    }

    public static String batchOptionMsgTips(String handleName, int successCount, int failCount) {
        String titleTemplate = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"StandardTips_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        return String.format(titleTemplate, successCount + failCount, handleName, successCount, failCount);
    }

    public static String batchOptionMsgContent(List<?> failList) {
        return StandardTips.batchOptionMsgContent(failList, null);
    }

    @Deprecated
    public static String batchOptionMsgContent(List<?> failList, List<?> successList) {
        String failBody = "";
        if (failList != null && !failList.isEmpty()) {
            String failTitleTemplate = ResManager.loadKDString((String)"\u5931\u8d25%s\u6761\uff1a</br>", (String)"StandardTips_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            String failTitle = String.format(failTitleTemplate, failList.size());
            String failTips = Joiner.on((String)"</br>").join(failList);
            failBody = failTitle + failTips;
        }
        return "<div style=\"width: 100%; height: initial;\">\n" + failBody + "</div>";
    }

    public static String getComma() {
        return ResManager.loadKDString((String)"\uff0c", (String)"StandardTips_9", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

