/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class AbstractWorkflowApiService
implements IBillWebApiPlugin {
    protected Log logger = LogFactory.getLog(this.getClass());

    private static DispatchService serviceLookup(String appId) {
        DispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        return service;
    }

    public static Object invokeBOSServiceByAppId(String appId, String serviceName, String methodName, Object ... paras) {
        DispatchService service = AbstractWorkflowApiService.serviceLookup(appId);
        return service.invoke("kd.bos.service.ServiceFactory", serviceName, methodName, paras);
    }

    public static Object invokeBOSService(String serviceName, String methodName, Object ... paras) {
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        return service.invoke("kd.bos.service.ServiceFactory", serviceName, methodName, paras);
    }

    public void assertInServiceAndLog(String methodName, Map<String, Object> map) {
        Object[] args;
        boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
        if (canRunWf) {
            if (map != null && !map.isEmpty()) {
                args = new Object[map.size() + 1];
                args[0] = methodName;
                int i = 1;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    args[i] = entry.getKey() + ":" + entry.getValue();
                    ++i;
                }
            } else {
                args = new Object[]{methodName};
            }
        } else {
            throw new KDException(WFErrorCode.workflowEngineNotConfiguration(), new Object[0]);
        }
        this.dispatchBizInvokeLog(args);
    }

    private void dispatchBizInvokeLog(Object ... args) {
        List<Object> params;
        if (args != null && (params = Arrays.asList(args)) != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Workflow-webApi-Method:[%s]", params.get(0).toString())).append("Params:[");
            for (int i = 1; i < params.size(); ++i) {
                sb.append(params.get(i)).append(',');
            }
            sb.append(']');
            this.logger.debug(sb.toString());
        }
    }

    public Long getUserIdByNumber(String userNumber) {
        if (StringUtils.isNotBlank((CharSequence)userNumber)) {
            ArrayList<String> userNumbers = new ArrayList<String>(1);
            userNumbers.add(userNumber);
            List<Long> userIds = this.getUserIdsByNumbers(userNumbers);
            if (userIds.isEmpty()) {
                return null;
            }
            return userIds.get(0);
        }
        return null;
    }

    public List<Long> getUserIdsByNumbers(List<String> userNumbers) {
        ArrayList<Long> userIds = new ArrayList<Long>(userNumbers.size());
        QFilter numberFilter = new QFilter("number", "in", userNumbers);
        QFilter[] numberFilters = new QFilter[]{numberFilter};
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id", (QFilter[])numberFilters);
        for (Map.Entry userEntry : userMap.entrySet()) {
            Long userId;
            DynamicObject userObject = (DynamicObject)userEntry.getValue();
            if (userObject == null || !StringUtils.isNotBlank((Object)(userId = Long.valueOf(userObject.getLong("id"))))) continue;
            userIds.add(userId);
        }
        return userIds;
    }

    public boolean isTaskExist(Long taskId) {
        return QueryServiceHelper.exists((String)"wf_hitaskinst", (Object)taskId);
    }

    public List<Long> getUserIdsByTaskId(Long taskId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        QFilter taskIdFilter = new QFilter("taskId", "in", (Object)taskId);
        QFilter[] taskIdFilters = new QFilter[]{taskIdFilter};
        Map participantMap = BusinessDataServiceHelper.loadFromCache((String)"wf_participant", (String)"userid", (QFilter[])taskIdFilters);
        for (Map.Entry userEntry : participantMap.entrySet()) {
            Long userId;
            DynamicObject userObject = (DynamicObject)userEntry.getValue();
            if (userObject == null || !StringUtils.isNotBlank((Object)(userId = Long.valueOf(userObject.getLong("userid"))))) continue;
            userIds.add(userId);
        }
        return userIds;
    }
}

