/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.exception.TaskErrorCodeEnum;

public class AddSignByAdminApiService
extends AbstractWorkflowApiService {
    private static final String PROCINSTID = "procinstId";
    private static final String ACTIVITYID = "activityId";
    private static final String ADDSIGNINFO = "addSignInfo";

    public ApiResult doCustomService(Map<String, Object> params) {
        if (!WfPermUtils.hasProcessAddSignPerm("api_v1")) {
            return ApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode());
        }
        if (WfUtils.isEmptyString(params.get(PROCINSTID)) || WfUtils.isEmptyString(params.get(ACTIVITYID)) || WfUtils.isEmptyString(params.get(ADDSIGNINFO))) {
            return ApiResult.fail((String)WFMultiLangConstants.getParamsErrorName());
        }
        this.assertInServiceAndLog("AddSignByAdmin", params);
        Long procinstId = null;
        String activityId = null;
        AddSignInfo addSignInfo = new AddSignInfo();
        try {
            procinstId = Long.parseLong(params.get(PROCINSTID).toString());
            activityId = params.get(ACTIVITYID).toString();
            LinkedHashMap addSignInfoMap = new LinkedHashMap();
            if (params.get(ADDSIGNINFO) instanceof Map) {
                addSignInfoMap = (LinkedHashMap)params.get(ADDSIGNINFO);
            } else if (params.get(ADDSIGNINFO) instanceof String) {
                addSignInfoMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)((String)params.get(ADDSIGNINFO)), Map.class);
            }
            String[] userIdsArr = addSignInfoMap.get("userIds").toString().replace(" ", "").split(",");
            List userIds = Stream.of(userIdsArr).map(userId -> Long.parseLong(userId)).collect(Collectors.toList());
            String addSignType = (String)addSignInfoMap.get("addSignType");
            LocaleString addSingMsg = new LocaleString();
            Object addSignMsg = addSignInfoMap.get("addSignMsg");
            if (addSignMsg instanceof Map) {
                LinkedHashMap addSignMsgMap = (LinkedHashMap)addSignMsg;
                for (Lang lang : WfUtils.getSupportLangs()) {
                    addSingMsg.put(lang.name(), (Object)((String)addSignMsgMap.get(lang.name())));
                }
            } else if (addSignMsg instanceof String) {
                addSingMsg = new LocaleString(addSignMsg.toString());
            }
            String addSignDealType = (String)addSignInfoMap.get("addSignDealType");
            String yzjType = (String)addSignInfoMap.get("yzjType");
            Boolean isAllowAddSign = null;
            Object allowAddSign = addSignInfoMap.get("allowAddSign");
            isAllowAddSign = allowAddSign != null && ("true".equalsIgnoreCase(allowAddSign.toString()) || "false".equalsIgnoreCase(allowAddSign.toString())) ? Boolean.valueOf(Boolean.parseBoolean(addSignInfoMap.get("allowAddSign").toString())) : (Boolean)allowAddSign;
            addSignInfo.setUserIds(userIds);
            addSignInfo.setAddSignDealType(addSignDealType);
            addSignInfo.setAddSingMsg((Map)addSingMsg);
            addSignInfo.setAddSignType(addSignType);
            addSignInfo.setAllowAddSign(isAllowAddSign);
            addSignInfo.setYzjType(yzjType);
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddSignByAdminApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            Object taskResult = AddSignByAdminApiService.invokeBOSService("IWorkflowService", "addSignByAdmin", procinstId, activityId, addSignInfo);
            return ApiResult.success((Object)taskResult);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

