/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.TaskErrorCodeEnum;

public class AddSignClearByAdminApiService
extends AbstractWorkflowApiService {
    private static final String PROCINSTID = "procinstId";
    private static final String ACTIVITYID = "activityId";

    public ApiResult doCustomService(Map<String, Object> params) {
        if (!WfPermUtils.hasProcessAddSignPerm("api_v1")) {
            return ApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode());
        }
        if (WfUtils.isEmptyString(params.get(PROCINSTID)) || WfUtils.isEmptyString(params.get(ACTIVITYID))) {
            return ApiResult.fail((String)WFMultiLangConstants.getParamsErrorName());
        }
        this.assertInServiceAndLog("AddSignClearByAdmin", params);
        Long procinstId = null;
        String activityId = null;
        try {
            procinstId = Long.parseLong(params.get(PROCINSTID).toString());
            activityId = params.get(ACTIVITYID).toString();
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddSignClearByAdminApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            Object taskResult = AddSignClearByAdminApiService.invokeBOSService("IWorkflowService", "addSignClearByAdmin", procinstId, activityId);
            return ApiResult.success((Object)taskResult);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

